/********************************************************************

  Module: TiStartWindow

  Author: Carlo Ordonez

  Description:

    Front screen

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiStartWindow_h_
#define _TiStartWindow_h_

#include "TiTopLevelWindow.h"
#include "TiMenu.h"
#include "TiSprite.h"
#include "TiBoxDraw.h"
#include "SyTime.h"
#include "TiGlowyText.h"
#include "SyCamera.h"

class TiUIControl;
class TitanUII;
class TitanI;
class TiClassWindow;
class TiNameWindow;
class TiLoadSaveGameWindow;


class TiStartWindow : public TiTopLevelWindow
{
public:
  TiStartWindow( TiApp* pApp, TitanUII *pTitanUI );
  ~TiStartWindow();

  // overrides
  virtual void          DrawSelf();
  virtual void          OnProcessFrame();
  virtual bool          ProcessButtonDown( int32 DeviceId, int32 ButtonId );
  virtual bool          ProcessKeyDown( int32 KeyCode );
  virtual void          ProcessMessage( TiWindowMessage* pMessage );

  void                  StartScreen();

private:
  void                  OnNewMenuItem();
  void                  UpdateMenuSelectionWidth();
  void                  OnSwitchLanguage(int32 iMenuCommand);
  void                  LoadMenuText();

  void                  Next();
  void                  Prev();
  void                  Select();
  void                  Back();
  void                  NextMode();

  void                  BeginCharacterCreation();

  void                  ProcessCreateMessage( TiWindowMessage* pMessage );

  enum Mode
  {
    kEsrbLogo,
    kSoeLogo,
    kStartScreen,
    kCharacter,
	kLoadGame,

    kBSDownloads,
  };

private:

  // menu IDs
  enum 
  {
    Id_Go               ,
    Id_NewGame          ,
    Id_LoadGame         ,
    Id_Options          ,
    Id_Downloads        ,
    Id_Credits          ,
    Id_Normal           ,
    Id_Internet         ,
    Id_1Player          ,
    Id_2Players         ,
    Id_3Players         ,
    Id_4Players         ,
    Id_Campaign         ,
    Id_Arena            ,
    Id_Easy             ,
    Id_Medium           ,
    Id_Hard             ,
    Id_Expert           ,
    Id_Exit_Titan       ,
    Id_Language_English ,
    Id_Language_French  ,
    Id_Language_German  ,
  };

  TiUIControl*          mpCtrl;
  TiMenu*               mpCurrentMenu;

  TiMenu                mMenuMain;
  TiMenu                mMenuNewGame;
  TiMenu                mMenuPlayers;
  TiMenu                mMenuGameType;
  TiMenu                mMenuDifficulty;
  TiMenu                mMenuOptions;

  SyTime                mTime;
  Mode                  mMode;

  int32                 mNumPlayers;
  bool                  mInternet;
  bool                  mCampaign;
  int32                 mClass;
  int32                 mDifficulty;

  TiLoadSaveGameWindow*  mpLoadGameWindow;

	/*
	 * Useful pointers
	 */
  TitanUII*             mpTitanUI;
  TiClassWindow*        mpClassWindow;
  TiNameWindow*         mpNameWindow;
  SyScene              *mpScene;
  SyRaster             *mpRaster;

	/*
	 * 2D
	 */
  TiSprite              mSprSoeLogo;
  TiSprite              mSprLogo;
  TiSprite              mSprMenuBackground;
  TiSprite              mSprLeftNinjaStar;
  TiSprite              mSprRightNinjaStar;
  TiSprite              mSprChecked;
  TiSprite              mSprUnchecked;
  TiSprite              mSprBSDownloads;
  TiBoxDraw             mBoxSelection;
	/*
	 * 3D
	 */
  SyCamera              mCamera;
  int32	                mPaperDollSprite;

  /*
	 * Selection
	 */
  float                 mfCurrentWidth;
  float                 mfTargetWidth;
  float                 mfWidthVelocity;
  TiUiParticleEmitter   mEmitterLeft;
  TiUiParticleEmitter   mEmitterRight;
};

#endif

