/********************************************************************

  Module: TiStatsWindow

  Author: Carlo Ordonez

  Description:

    Character Stats Window

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiStatsWindow_h_
#define _TiStatsWindow_h_

#include "TiCharacterPage.h"
#include "TiSprite.h"
#include "TiBoxDraw.h"
#include "TiChildFrameDraw.h"

class TiCharacterData;

enum 
{
  SW_Health,
  SW_Mana,
  SW_AttackPower,
  SW_MagicPower,
  SW_MeleeDefense,
  SW_SpellDefense,
  SW_MaxStats = 6,
};

class TiStatsWindow : public TiCharacterPage
{
public:
  TiStatsWindow( TiWindow* pParent, TiCharacterData* pData, int32 PlayerId );
  ~TiStatsWindow();

  // overrides
  virtual int32     Init();
  virtual void      DrawSelf();
  virtual bool      ProcessKeyDown( int32 KeyCode );
  virtual bool      ProcessKeyUp( int32 KeyCode ) { return( false ); }
  virtual bool      ProcessButtonDown( int32 DeviceId, int32 ButtonId );
  virtual bool      ProcessButtonUp( int32 DeviceId, int32 ButtonId ) { return( false ); }
  virtual void      ProcessReloadLayout();

private:
  void              Next();
  void              Prev();
  void              AssignPoint(int iStat);
  void              UnassignPoint(int iStat);
  void              CommitPoints();
  void              RollbackPoints();

  bool              m_bLevelingUp;
  int32             m_iStat;
  TiSprite          m_sprStatIcons[SW_MaxStats];
  TiSprite          m_sprArrowLeft;
  TiSprite          m_sprArrowRight;
  TiChildFrameDraw  m_cfd;

  int32             m_nBonusPoints;
  int32             m_nDeltaPerPoint[SW_MaxStats];
  int32             m_nStats[SW_MaxStats];
  int32             m_nAdjustments[SW_MaxStats];
};

#endif

