/********************************************************************

  Module: TiUILayout

  Author: Carlo Ordonez

  Description:

    Layout information for UI windows

  Copyright 2006 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiUILayout_h_
#define _TiUILayout_h_

#include "SyString.h"
#include "SyMap.h"
#include "SyVect2I.h"

class TiUILayoutItem
{
public:
  TiUILayoutItem();

  SyString      mName;
  SyString      mFilename;
  SyVect2I      mOffset;
  SyVect2I      mSize;
};

class TiUILayout
{
public:
  TiUILayout();
  ~TiUILayout();

  int32 Init( const char8* pFilename );
  int32 Reload();

  const SyVect2I GetOffset( const char8* pImageName );
  int32 GetLayoutInfo( const char8* pImageName, TiUILayoutItem* pInfo );

private:

  SyString mFilename;
  SyString mName;
  SyMap< SyString, TiUILayoutItem > mItems;
};

#endif

