/********************************************************************

  Module: TiWindow

  Author: Carlo Ordonez

  Description:

    Window base class

  Copyright 2005 Sony Online Entertainment.  All rights reserved.

*********************************************************************/

#ifndef _TiWindow_h_
#define _TiWindow_h_

#include "SyTypes.h"
#include "SyNew.h"
#include "TiButtonMap.h"
#include "TiPtSizeRect.h"
#include <set>

class TiApp;
class TiUI;
class TiWindowMessage;

class TiWindow
{
public:
  TiWindow( TiApp* pApp );
  TiWindow( TiWindow* pParent );
  virtual ~TiWindow();

  virtual void        ProcessFrame();
  virtual void        OnProcessFrame() {}
  virtual void        Draw();
  virtual void        DrawSelf() {}
  virtual bool        ProcessKeyDown( int32 KeyCode );
  virtual bool        ProcessKeyUp( int32 KeyCode );
  virtual bool        ProcessButtonDown( int32 DeviceId, int32 ButtonId );
  virtual bool        ProcessButtonUp( int32 DeviceId, int32 ButtonId );
  virtual bool        ProcessAxisMove( int32 iDevice, int32 x, int32 y, int32 nButtonStates);
  virtual void        ProcessMessage( TiWindowMessage* pMessage );

  virtual void        ReloadLayout();
  virtual void        ProcessReloadLayout() {}

  virtual void        Show( bool Visible ) { mVisible = Visible; }
  virtual bool        IsVisible() const { return( mVisible ); }

  virtual bool        IsTopLevel() const { return( false ); }

  virtual int32       Init() { return( 0 ); }

  virtual void        CloseWindow();

  TiWindow*           FindFocus();
  bool                SetFocus();
  void                Move(TiRect rect);
  void                Move(TiPoint pt);
  void                SetCenter(TiPoint pt);
  TiRect              GetScreenRect() const;

  TiWindow*           GetParent() const;

  static void         SetButtonMap( TiButtonMap::Mapping Mapping );
  static TiButtonMap::Button GetButton( int32 ButtonId );

protected:

  void                AddChild( TiWindow* pChild );
  void                RemoveChild( TiWindow* pChild );

  TiApp*              mpApp;
  TiWindow*           mpParent;
  bool                mVisible;

  // Jon's framework additions
  TiRect              m_rect;
  bool                m_bRelativeToParent;

private:
  static TiButtonMap    mButtonMap;
  std::set< TiWindow* > mChildren;
};

#endif

