// A controller object with buttons & axes named in terms of game functions
// buttons and axis mappings are already done.

#ifndef __TITANCONTROLLER_H__
#define __TITANCONTROLLER_H__

#include "TitanI.h"

class RawController;

class TitanController : public TitanControllerI
{
public:
  TitanController( RawController* pRawController );
  virtual ~TitanController();

  // returns true if the controller is connected.
  virtual bool GetConnected() const;

  // returns true if the specified button is depressed.
  virtual bool GetButtonState( TitanButton tb ) const;

  // returns a value in the range [-10000,+10000] that indicates whether
  // the directional control is pushed completely forward (+10000),
  // completely backward (-10000) or somewhere in between.
  virtual int GetForward() const;

  // returns a value in the range [-10000,+10000] that indicates whether
  // the directional control is pushed completely to the right (+10000),
  // completely to the left (-10000) or somewhere in between.
  virtual int GetRight() const;

  // returns a value in the range [-10000,+10000] that indicates whether
  // the right directional control is pushed completely forward (+10000),
  // completely backward (-10000) or somewhere in between.
  virtual int GetRightStickForward() const;

  // returns a value in the range [-10000,+10000] that indicates whether
  // the right directional control is pushed completely to the right (+10000),
  // completely to the left (-10000) or somewhere in between.
  virtual int GetRightStickRight() const;

  virtual float Normalize(int in) const;

private:
  RawController* mpRawController;
};

#endif // __TITANCONTROLLER_H__

