/* SCE CONFIDENTIAL
 * PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

/* libdaisy assert macro definitions */

#ifndef __CELL_DAISY_ASSERT_H__
#define __CELL_DAISY_ASSERT_H__

#define CELL_DAISY_MIN_QUEUE_SIZE		1
#define CELL_DAISY_MAX_LOCAL_QUEUE_SIZE		32
#define CELL_DAISY_MAX_ATO_QUEUE_SIZE		32
#define CELL_DAISY_MAX_SNR_QUEUE_SIZE	12

#define CELL_DAISY_MIN_ENTRY_SIZE		16
#define CELL_DAISY_MAX_ENTRY_SIZE		(16*1024)
#define CELL_DAISY_ENTRY_SIZE(x)	(!((x) & 0xf))

#define CELL_DAISY_MAX_DMA_TAG			31

#define CELL_DAISY_EA_ATOMIC(x)		(!((uint32_t)(x) & 0x7f))
#define CELL_DAISY_EA_DMA(x)		(!((x) & 0xf))

#include <spu_printf.h>

/* cellDaisyAssert */
/* Assert Definition (Dafault : Enable Assert) */

#ifdef CELL_DAISY_NO_ASSERT
#define cellDaisyAssert(cond) do{}while (false)

#else /* CELL_DAISY_NO_ASSERT */

#ifdef CELL_DAISY_ASSERT_VERBOSE

#ifdef __SPU__
#define cellDaisyAssert(cond) \
do { \
	if (__builtin_expect(!(cond), 0)) { \
		spu_printf("daisy assert!! %s %d\n",__FILE__,__LINE__); \
		__builtin_spu_hcmpeq_0(0, 0); \
		while(1); \
	} \
} while (false)
#else
#define cellDaisyAssert(cond) \
do { \
	if (!(cond)) { \
		printf("daisy assert!! %s %d\n",__FILE__,__LINE__); \
		assert(0);\
	} \
} while (false)
#endif /* __SPU__ */

#else /* CELL_DAISY_ASSERT_VERBOSE */

#ifdef __SPU__
#define cellDaisyAssert(cond) __builtin_spu_hcmpeq_0(cond, 0)
#else
#define cellDaisyAssert(cond) assert(cond)
#endif /* __SPU__ */

#endif /* CELL_DAISY_ASSERT_VERBOSE */
#endif /* CELL_DAISY_NO_ASSERT */

#endif /* __CELL_DAISY_ASSERT_H__ */

/*
 * Local Variables:
 * mode:C++
 * tab-width:4
 * End:
 * vim:ts=4:sw=4:
 */
