/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_TYPES_H__
#define __CELL_SPURS_TYPES_H__ 1

/* The C Standard Library */
#include <stdint.h>
#include <stdbool.h>

/* SPU C/C++ Language Extention */
#ifdef __SPU__
#include <spu_intrinsics.h>
#endif /* __SPU__ */

/*
 * SPU runtime system
 */
/* typical usage:
 * CellSpurs *spurs = (CellSpurs*)memalign(CELL_SPURS_ALIGN, CELL_SPURS_SIZE); */

#define CELL_SPURS_ALIGN			128
#define CELL_SPURS_SIZE				2304

typedef struct CellSpurs {
	unsigned char skip[CELL_SPURS_SIZE];
} CellSpurs __attribute__((aligned(CELL_SPURS_ALIGN)));

/*
 * workload
 */
#define CELL_SPURS_MAX_WORKLOAD		16
#define CELL_SPURS_MAX_PRIORITY		16
typedef unsigned CellSpursWorkloadId;

#endif /* __CELL_SPURS_TYPES_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
