/*
Copyright 2001-2004 by NVIDIA Corporation.  All rights reserved.

All information contained herein is proprietary and confidential to NVIDIA 
Corporation. Any use, reproduction, or disclosure without the advance written
permission of NVIDIA Corporation is prohibited.  

Without limiting any of the foregoing, all information contained herein shall
be deemed NVIDIA "Confidential Information" as defined in the Confidentiality
and Non-Disclosure Agreement among Sony Computer Entertainment Inc. ("SCEI"),
Toshiba Corporation ("Toshiba"), NVIDIA Corporation, and NVIDIA K.K.
(collectively, "NVIDIA"), entered into as of March 5, 2004 ("CNDA").  NVIDIA 
Confidential Information is hereby disclosed and transmitted solely and 
exclusively to SCEI pursuant to the terms and conditions set forth in the CNDA
and pursuant to the Letter of Intent executed between NVIDIA Corporation and
SCEI on or about on December 7, 2004 ("LOI").  Provided, however,
notwithstanding any language to the contrary in the CNDA,  SCEI acknowledges
and agrees that NVIDIA Confidential Information contained herein shall not be
disclosed to Toshiba without first obtaining NVIDIA's advance written approval.
*/



/*
 *
 * Copyright (c) 2002-2004, NVIDIA Corporation.
 * 
 *  
 * 
 * NVIDIA Corporation("NVIDIA") supplies this software to you in consideration 
 * of your agreement to the following terms, and your use, installation, 
 * modification or redistribution of this NVIDIA software constitutes 
 * acceptance of these terms.  If you do not agree with these terms, please do 
 * not use, install, modify or redistribute this NVIDIA software.
 * 
 *  
 * 
 * In consideration of your agreement to abide by the following terms, and 
 * subject to these terms, NVIDIA grants you a personal, non-exclusive license,
 * under NVIDIA痴 copyrights in this original NVIDIA software (the "NVIDIA 
 * Software"), to use, reproduce, modify and redistribute the NVIDIA 
 * Software, with or without modifications, in source and/or binary forms; 
 * provided that if you redistribute the NVIDIA Software, you must retain the 
 * copyright notice of NVIDIA, this notice and the following text and 
 * disclaimers in all such redistributions of the NVIDIA Software. Neither the 
 * name, trademarks, service marks nor logos of NVIDIA Corporation may be used 
 * to endorse or promote products derived from the NVIDIA Software without 
 * specific prior written permission from NVIDIA.  Except as expressly stated 
 * in this notice, no other rights or licenses express or implied, are granted 
 * by NVIDIA herein, including but not limited to any patent rights that may be 
 * infringed by your derivative works or by other works in which the NVIDIA 
 * Software may be incorporated. No hardware is licensed hereunder. 
 * 
 *  
 * 
 * THE NVIDIA SOFTWARE IS BEING PROVIDED ON AN "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING 
 * WITHOUT LIMITATION, WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT, 
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR ITS USE AND OPERATION 
 * EITHER ALONE OR IN COMBINATION WITH OTHER PRODUCTS.
 * 
 *  
 * 
 * IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL, 
 * EXEMPLARY, CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, LOST 
 * PROFITS; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) OR ARISING IN ANY WAY OUT OF THE USE, 
 * REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION OF THE NVIDIA SOFTWARE, 
 * HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING 
 * NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF NVIDIA HAS BEEN ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */ 


#ifndef _cg_h
#define _cg_h


#define CG_VERSION_1_2                1
#define CG_VERSION_NUM                1200


//
// This #define foreces the old API for now.  This will be removed soon, but
// the user will still have the ability to enable it.
//
// #define CG_DEPRECATED_1_1_API 1

// Set up for either Win32 import/export/lib.
#ifndef CGDLL_API
#ifdef WIN32
    #ifdef CGDLL_EXPORTS
    #define CGDLL_API __declspec(dllexport)
    #elif defined (CG_LIB)
    #define CGDLL_API
    #else
    #define CGDLL_API __declspec(dllimport)
    #endif
#else
    #define CGDLL_API
#endif
#endif

/*************************************************************************/
/*** CG Run-Time Library API                                          ***/
/*************************************************************************/

/*************************************************************************/
/*** Data types and enumerants                                         ***/
/*************************************************************************/

typedef int CGbool;

#define CG_FALSE ((CGbool)0)
#define CG_TRUE ((CGbool)1)

typedef struct _CGcontext *CGcontext;
typedef struct _CGprogram *CGprogram;
typedef struct _CGparameter *CGparameter;
typedef struct _CGeffect *CGeffect;
typedef struct _CGtechnique *CGtechnique;
typedef struct _CGpass *CGpass;
typedef struct _CGstate *CGstate;
typedef struct _CGstateassignment *CGstateassignment;
typedef struct _CGannotation *CGannotation;

typedef CGbool (*CGstatecallback)(CGstateassignment);

#define CGFX_CHANGE_ME 0

//!!! PREPROCESS BEGIN

typedef enum
 {
  CG_UNKNOWN_TYPE,
  CG_STRUCT,
  CG_ARRAY,

  CG_TYPE_START_ENUM = 1024,
# define CG_DATATYPE_MACRO(name, compiler_name, enum_name, base_name, ncols, nrows) \
  enum_name ,

#include <Cg/cg_datatypes.h>

 } CGtype;

typedef enum
 {
# define CG_BINDLOCATION_MACRO(name,enum_name,compiler_name,\
                               enum_int,addressable,param_type) \
  enum_name = enum_int,

#include <Cg/cg_bindlocations.h>

  CG_UNDEFINED,

 } CGresource;

typedef enum
 {
  CG_PROFILE_START = 6144,
  CG_PROFILE_UNKNOWN,

# define CG_PROFILE_MACRO(name, compiler_id, compiler_id_caps, compiler_opt,int_id,vertex_profile) \
   CG_PROFILE_##compiler_id_caps = int_id,
  
#include <Cg/cg_profiles.h>

  CG_PROFILE_MAX = 7100,
 } CGprofile;

typedef enum
 {
# define CG_ERROR_MACRO(code, enum_name, message) \
   enum_name = code,
# include <Cg/cg_errors.h>
 } CGerror;

typedef enum
 {
  CG_PARAMETERCLASS_UNKNOWN = 0,
  CG_PARAMETERCLASS_SCALAR,
  CG_PARAMETERCLASS_VECTOR,
  CG_PARAMETERCLASS_MATRIX,
  CG_PARAMETERCLASS_STRUCT,
  CG_PARAMETERCLASS_ARRAY,
  CG_PARAMETERCLASS_OBJECT
 } CGparameterclass;

//!!! PREPROCESS END

typedef enum
 {
# define CG_ENUM_MACRO(enum_name, enum_val) \
   enum_name = enum_val,
# include <Cg/cg_enums.h>
 } CGenum;

#include <stdarg.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void (*CGerrorCallbackFunc)(void);
typedef void (*CGerrorHandlerFunc)(CGcontext ctx, CGerror err, void *data);

/*************************************************************************/
/*** Functions                                                         ***/
/*************************************************************************/

#ifndef CG_EXPLICIT

/*** Context functions ***/

CGDLL_API CGcontext cgCreateContext(void); 
CGDLL_API void cgDestroyContext(CGcontext ctx); 
CGDLL_API CGbool cgIsContext(CGcontext ctx);
CGDLL_API const char *cgGetLastListing(CGcontext ctx);
CGDLL_API void cgSetAutoCompile(CGcontext ctx, CGenum flag);
CGDLL_API CGenum cgGetAutoCompile(CGcontext ctx);

/*** Program functions ***/
CGDLL_API CGprogram cgCreateProgram(CGcontext ctx, 
                                    CGenum program_type,
                                    const char *program,
                                    CGprofile profile,
                                    const char *entry,
                                    const char **args);
CGDLL_API CGprogram cgCreateProgramFromFile(CGcontext ctx, 
                                            CGenum program_type,
                                            const char *program_file,
                                            CGprofile profile,
                                            const char *entry,
                                            const char **args);
CGDLL_API CGprogram cgCopyProgram(CGprogram program); 
CGDLL_API void cgDestroyProgram(CGprogram program); 

CGDLL_API CGprogram cgGetFirstProgram(CGcontext ctx);
CGDLL_API CGprogram cgGetNextProgram(CGprogram current);
CGDLL_API CGcontext cgGetProgramContext(CGprogram prog);
CGDLL_API CGbool cgIsProgram(CGprogram program); 

CGDLL_API void cgCompileProgram(CGprogram program); 
CGDLL_API CGbool cgIsProgramCompiled(CGprogram program); 
CGDLL_API const char *cgGetProgramString(CGprogram prog, CGenum pname); 
CGDLL_API CGprofile cgGetProgramProfile(CGprogram prog); 
CGDLL_API void cgSetProgramProfile(CGprogram prog, CGprofile profile);

CGDLL_API void cgSetPassProgramParameters(CGprogram);

/*** Parameter functions ***/

CGDLL_API CGparameter cgCreateParameter(CGcontext ctx, CGtype type);
CGDLL_API CGparameter cgCreateParameterArray(CGcontext ctx,
                                             CGtype type, 
                                             int length);
CGDLL_API CGparameter cgCreateParameterMultiDimArray(CGcontext ctx,
                                                     CGtype type,
                                                     int dim, 
                                                     const int *lengths);
CGDLL_API void cgDestroyParameter(CGparameter param);
CGDLL_API void cgConnectParameter(CGparameter from, CGparameter to);
CGDLL_API void cgDisconnectParameter(CGparameter param);
CGDLL_API CGparameter cgGetConnectedParameter(CGparameter param);

CGDLL_API int cgGetNumConnectedToParameters(CGparameter param);
CGDLL_API CGparameter cgGetConnectedToParameter(CGparameter param, int index);

CGDLL_API CGparameter cgGetNamedParameter(CGprogram prog, const char *name);
CGDLL_API CGparameter cgGetNamedProgramParameter(CGprogram prog, 
                                                 CGenum name_space, 
                                                 const char *name);

CGDLL_API CGparameter cgGetFirstParameter(CGprogram prog, CGenum name_space);
CGDLL_API CGparameter cgGetNextParameter(CGparameter current);
CGDLL_API CGparameter cgGetFirstLeafParameter(CGprogram prog, CGenum name_space);
CGDLL_API CGparameter cgGetNextLeafParameter(CGparameter current);

CGDLL_API CGparameter cgGetFirstStructParameter(CGparameter param);
CGDLL_API CGparameter cgGetNamedStructParameter(CGparameter param, 
                                                const char *name);

CGDLL_API CGparameter cgGetFirstDependentParameter(CGparameter param);

CGDLL_API CGparameter cgGetArrayParameter(CGparameter aparam, int index);
CGDLL_API int cgGetArrayDimension(CGparameter param);
CGDLL_API CGtype cgGetArrayType(CGparameter param);
CGDLL_API int cgGetArraySize(CGparameter param, int dimension);
CGDLL_API int cgGetArrayTotalSize(CGparameter param);
CGDLL_API void cgSetArraySize(CGparameter param, int size);
CGDLL_API void cgSetMultiDimArraySize(CGparameter param, const int *sizes);

CGDLL_API CGprogram cgGetParameterProgram(CGparameter param);
CGDLL_API CGcontext cgGetParameterContext(CGparameter param);
CGDLL_API CGbool cgIsParameter(CGparameter param);
CGDLL_API const char *cgGetParameterName(CGparameter param);
CGDLL_API CGtype cgGetParameterType(CGparameter param);
CGDLL_API CGtype cgGetParameterBaseType(CGparameter param);
CGDLL_API CGparameterclass cgGetParameterClass(CGparameter param);
CGDLL_API int cgGetParameterRows(CGparameter param);
CGDLL_API int cgGetParameterColumns(CGparameter param);
CGDLL_API CGtype cgGetParameterNamedType(CGparameter param);
CGDLL_API const char *cgGetParameterSemantic(CGparameter param);
CGDLL_API CGresource cgGetParameterResource(CGparameter param);
CGDLL_API CGresource cgGetParameterBaseResource(CGparameter param);
CGDLL_API unsigned long cgGetParameterResourceIndex(CGparameter param);
CGDLL_API CGenum cgGetParameterVariability(CGparameter param);
CGDLL_API CGenum cgGetParameterDirection(CGparameter param);
CGDLL_API CGbool cgIsParameterReferenced(CGparameter param);
CGDLL_API const double *cgGetParameterValues(CGparameter param, 
                                             CGenum value_type,
                                             int *nvalues);
CGDLL_API void cgSetParameterValuedr(CGparameter param, int n, const double *vals);
CGDLL_API void cgSetParameterValuedc(CGparameter param, int n, const double *vals);
CGDLL_API void cgSetParameterValuefr(CGparameter param, int n, const float *vals);
CGDLL_API void cgSetParameterValuefc(CGparameter param, int n, const float *vals);
CGDLL_API void cgSetParameterValueir(CGparameter param, int n, const int *vals);
CGDLL_API void cgSetParameterValueic(CGparameter param, int n, const int *vals);
CGDLL_API int cgGetParameterValuedr(CGparameter param, int n, double *vals);
CGDLL_API int cgGetParameterValuedc(CGparameter param, int n, double *vals);
CGDLL_API int cgGetParameterValuefr(CGparameter param, int n, float *vals);
CGDLL_API int cgGetParameterValuefc(CGparameter param, int n, float *vals);
CGDLL_API int cgGetParameterValueir(CGparameter param, int n, int *vals);
CGDLL_API int cgGetParameterValueic(CGparameter param, int n, int *vals);
CGDLL_API const char *cgGetStringParameterValue(CGparameter param);
CGDLL_API void cgSetStringParameterValue(CGparameter param, const char *str);

CGDLL_API int cgGetParameterOrdinalNumber(CGparameter param);
CGDLL_API CGbool cgIsParameterGlobal(CGparameter param);
CGDLL_API int cgGetParameterIndex(CGparameter param);

CGDLL_API void cgSetParameterVariability(CGparameter param, CGenum vary);
CGDLL_API void cgSetParameterSemantic(CGparameter param, const char *semantic);

CGDLL_API void cgSetParameter1f(CGparameter param, float x);
CGDLL_API void cgSetParameter2f(CGparameter param, float x, float y);
CGDLL_API void cgSetParameter3f(CGparameter param, float x, float y, float z);
CGDLL_API void cgSetParameter4f(CGparameter param, 
                                float x, 
                                float y, 
                                float z,
                                float w);
CGDLL_API void cgSetParameter1d(CGparameter param, double x);
CGDLL_API void cgSetParameter2d(CGparameter param, double x, double y);
CGDLL_API void cgSetParameter3d(CGparameter param, 
                                double x, 
                                double y, 
                                double z);
CGDLL_API void cgSetParameter4d(CGparameter param, 
                                double x, 
                                double y, 
                                double z,
                                double w);
CGDLL_API void cgSetParameter1i(CGparameter param, int x);
CGDLL_API void cgSetParameter2i(CGparameter param, int x, int y);
CGDLL_API void cgSetParameter3i(CGparameter param, int x, int y, int z);
CGDLL_API void cgSetParameter4i(CGparameter param, 
                                int x, 
                                int y, 
                                int z,
                                int w);


CGDLL_API void cgSetParameter1iv(CGparameter param, const int *v);
CGDLL_API void cgSetParameter2iv(CGparameter param, const int *v);
CGDLL_API void cgSetParameter3iv(CGparameter param, const int *v);
CGDLL_API void cgSetParameter4iv(CGparameter param, const int *v);
CGDLL_API void cgSetParameter1fv(CGparameter param, const float *v);
CGDLL_API void cgSetParameter2fv(CGparameter param, const float *v);
CGDLL_API void cgSetParameter3fv(CGparameter param, const float *v);
CGDLL_API void cgSetParameter4fv(CGparameter param, const float *v);
CGDLL_API void cgSetParameter1dv(CGparameter param, const double *v);
CGDLL_API void cgSetParameter2dv(CGparameter param, const double *v);
CGDLL_API void cgSetParameter3dv(CGparameter param, const double *v);
CGDLL_API void cgSetParameter4dv(CGparameter param, const double *v);

CGDLL_API void cgSetMatrixParameterir(CGparameter param, const int *matrix);
CGDLL_API void cgSetMatrixParameterdr(CGparameter param, const double *matrix);
CGDLL_API void cgSetMatrixParameterfr(CGparameter param, const float *matrix);
CGDLL_API void cgSetMatrixParameteric(CGparameter param, const int *matrix);
CGDLL_API void cgSetMatrixParameterdc(CGparameter param, const double *matrix);
CGDLL_API void cgSetMatrixParameterfc(CGparameter param, const float *matrix);

CGDLL_API void cgGetMatrixParameterir(CGparameter param, int *matrix);
CGDLL_API void cgGetMatrixParameterdr(CGparameter param, double *matrix);
CGDLL_API void cgGetMatrixParameterfr(CGparameter param, float *matrix);
CGDLL_API void cgGetMatrixParameteric(CGparameter param, int *matrix);
CGDLL_API void cgGetMatrixParameterdc(CGparameter param, double *matrix);
CGDLL_API void cgGetMatrixParameterfc(CGparameter param, float *matrix);

/*** Type Functions ***/

CGDLL_API const char *cgGetTypeString(CGtype type);
CGDLL_API CGtype cgGetType(const char *type_string);

CGDLL_API CGtype cgGetNamedUserType(CGprogram program, const char *name);

CGDLL_API int cgGetNumUserTypes(CGprogram program);
CGDLL_API CGtype cgGetUserType(CGprogram program, int index);

CGDLL_API int cgGetNumParentTypes(CGtype type);
CGDLL_API CGtype cgGetParentType(CGtype type, int index);

CGDLL_API CGbool cgIsParentType(CGtype parent, CGtype child);
CGDLL_API CGbool cgIsInterfaceType(CGtype type);

/*** Resource Functions ***/

CGDLL_API const char *cgGetResourceString(CGresource resource);
CGDLL_API CGresource cgGetResource(const char *resource_string);

/*** Enum Functions ***/

CGDLL_API const char *cgGetEnumString(CGenum en);
CGDLL_API CGenum cgGetEnum(const char *enum_string);

/*** Profile Functions ***/

CGDLL_API const char *cgGetProfileString(CGprofile profile);
CGDLL_API CGprofile cgGetProfile(const char *profile_string);

/*** Error Functions ***/

CGDLL_API CGerror cgGetError(void);
CGDLL_API CGerror cgGetFirstError(void);
CGDLL_API const char *cgGetErrorString(CGerror error);
CGDLL_API const char *cgGetLastErrorString(CGerror *error);
CGDLL_API void cgSetErrorCallback(CGerrorCallbackFunc func);
CGDLL_API CGerrorCallbackFunc cgGetErrorCallback(void);
CGDLL_API void cgSetErrorHandler(CGerrorHandlerFunc func, void *data);
CGDLL_API CGerrorHandlerFunc cgGetErrorHandler(void **data);

/*** Misc Functions ***/

CGDLL_API const char *cgGetString(CGenum sname);


/*** CgFX Functions ***/

PSGLFX_EXPORT CGeffect cgCreateEffect(CGcontext, const char *code, const char **args);
PSGLFX_EXPORT CGeffect cgCreateEffectFromFile(CGcontext, const char *filename,
                                          const char **args);
PSGLFX_EXPORT void cgDestroyEffect(CGeffect);
PSGLFX_EXPORT CGcontext cgGetEffectContext(CGeffect);
PSGLFX_EXPORT CGbool cgIsEffect(CGeffect effect);

PSGLFX_EXPORT CGeffect cgGetFirstEffect(CGcontext);
PSGLFX_EXPORT CGeffect cgGetNextEffect(CGeffect);

PSGLFX_EXPORT CGprogram cgCreateProgramFromEffect(CGeffect effect,
                                              CGprofile profile,
                                              const char *entry,
                                              const char **args);

PSGLFX_EXPORT CGtechnique cgGetFirstTechnique(CGeffect);
PSGLFX_EXPORT CGtechnique cgGetNextTechnique(CGtechnique);
PSGLFX_EXPORT CGtechnique cgGetNamedTechnique(CGeffect, const char *name);
PSGLFX_EXPORT const char *cgGetTechniqueName(CGtechnique);
PSGLFX_EXPORT CGbool cgIsTechnique(CGtechnique);
PSGLFX_EXPORT CGbool cgValidateTechnique(CGtechnique);
PSGLFX_EXPORT CGbool cgIsTechniqueValidated(CGtechnique);
PSGLFX_EXPORT CGeffect cgGetTechniqueEffect(CGtechnique);

PSGLFX_EXPORT CGpass cgGetFirstPass(CGtechnique);
PSGLFX_EXPORT CGpass cgGetNamedPass(CGtechnique, const char *name);
PSGLFX_EXPORT CGpass cgGetNextPass(CGpass);
PSGLFX_EXPORT CGbool cgIsPass(CGpass);
PSGLFX_EXPORT const char *cgGetPassName(CGpass); 
PSGLFX_EXPORT CGtechnique cgGetPassTechnique(CGpass);

PSGLFX_EXPORT void cgSetPassState(CGpass);
PSGLFX_EXPORT void cgResetPassState(CGpass);

PSGLFX_EXPORT CGstateassignment cgGetFirstStateAssignment(CGpass);
PSGLFX_EXPORT CGstateassignment cgGetNamedStateAssignment(CGpass, const char *name);
PSGLFX_EXPORT CGstateassignment cgGetNextStateAssignment(CGstateassignment);
PSGLFX_EXPORT CGbool cgIsStateAssignment(CGstateassignment);
PSGLFX_EXPORT CGbool cgCallStateSetCallback(CGstateassignment);
PSGLFX_EXPORT CGbool cgCallStateValidateCallback(CGstateassignment);
PSGLFX_EXPORT CGbool cgCallStateResetCallback(CGstateassignment);
PSGLFX_EXPORT CGpass cgGetStateAssignmentPass(CGstateassignment);
PSGLFX_EXPORT CGparameter cgGetSamplerStateAssignmentParameter(CGstateassignment);

PSGLFX_EXPORT const float *cgGetFloatStateAssignmentValues(CGstateassignment, int *nVals);
PSGLFX_EXPORT const int *cgGetIntStateAssignmentValues(CGstateassignment, int *nVals);
PSGLFX_EXPORT const CGbool *cgGetBoolStateAssignmentValues(CGstateassignment, int *nVals);
PSGLFX_EXPORT const char *cgGetStringStateAssignmentValue(CGstateassignment);
PSGLFX_EXPORT CGprogram cgGetProgramStateAssignmentValue(CGstateassignment);
PSGLFX_EXPORT CGparameter cgGetTextureStateAssignmentValue(CGstateassignment);
PSGLFX_EXPORT CGparameter cgGetSamplerStateAssignmentValue(CGstateassignment);
PSGLFX_EXPORT int cgGetStateAssignmentIndex(CGstateassignment);

PSGLFX_EXPORT int cgGetNumDependentStateAssignmentParameters(CGstateassignment);
PSGLFX_EXPORT CGparameter cgGetDependentStateAssignmentParameter(CGstateassignment, int index);

PSGLFX_EXPORT CGstate cgGetStateAssignmentState(CGstateassignment);
PSGLFX_EXPORT CGstate cgGetSamplerStateAssignmentState(CGstateassignment);

PSGLFX_EXPORT CGstate cgCreateState(CGcontext, const char *name, CGtype);
PSGLFX_EXPORT CGstate cgCreateArrayState(CGcontext, const char *name, CGtype, int nelems);
PSGLFX_EXPORT void cgSetStateCallbacks(CGstate, CGstatecallback set, CGstatecallback reset,
                                   CGstatecallback validate);
PSGLFX_EXPORT CGtype cgGetStateType(CGstate);
PSGLFX_EXPORT const char *cgGetStateName(CGstate);
PSGLFX_EXPORT CGstate cgGetNamedState(CGcontext, const char *name);
PSGLFX_EXPORT CGstate cgGetFirstState(CGcontext);
PSGLFX_EXPORT CGstate cgGetNextState(CGstate);
PSGLFX_EXPORT CGbool cgIsState(CGstate);
PSGLFX_EXPORT void cgAddStateEnumerant(CGstate, const char *name, int value);

PSGLFX_EXPORT CGstate cgCreateSamplerState(CGcontext, const char *name, CGtype);
PSGLFX_EXPORT CGstate cgCreateArraySamplerState(CGcontext, const char *name, CGtype, int nelems);
PSGLFX_EXPORT CGstate cgGetNamedSamplerState(CGcontext, const char *name);
PSGLFX_EXPORT CGstate cgGetFirstSamplerState(CGcontext);

PSGLFX_EXPORT CGstateassignment cgGetFirstSamplerStateAssignment(CGparameter);
PSGLFX_EXPORT CGstateassignment cgGetNamedSamplerStateAssignment(CGparameter, const char *);
PSGLFX_EXPORT void cgSetSamplerState(CGparameter);

PSGLFX_EXPORT CGparameter cgGetNamedEffectParameter(CGeffect, const char *);
PSGLFX_EXPORT CGparameter cgGetFirstLeafEffectParameter(CGeffect);
PSGLFX_EXPORT CGparameter cgGetFirstEffectParameter(CGeffect);
PSGLFX_EXPORT CGparameter cgGetEffectParameterBySemantic(CGeffect, const char *);

PSGLFX_EXPORT CGannotation cgGetFirstTechniqueAnnotation(CGtechnique);
PSGLFX_EXPORT CGannotation cgGetFirstPassAnnotation(CGpass);
PSGLFX_EXPORT CGannotation cgGetFirstParameterAnnotation(CGparameter);
PSGLFX_EXPORT CGannotation cgGetFirstProgramAnnotation(CGprogram);
PSGLFX_EXPORT CGannotation cgGetNextAnnotation(CGannotation);

PSGLFX_EXPORT CGannotation cgGetNamedTechniqueAnnotation(CGtechnique, const char *);
PSGLFX_EXPORT CGannotation cgGetNamedPassAnnotation(CGpass, const char *);
PSGLFX_EXPORT CGannotation cgGetNamedParameterAnnotation(CGparameter, const char *);
PSGLFX_EXPORT CGannotation cgGetNamedProgramAnnotation(CGprogram, const char *);

PSGLFX_EXPORT CGbool cgIsAnnotation(CGannotation);

PSGLFX_EXPORT const char *cgGetAnnotationName(CGannotation);
PSGLFX_EXPORT CGtype cgGetAnnotationType(CGannotation);
PSGLFX_EXPORT int cgGetAnnotationArrayDimension(CGannotation);
PSGLFX_EXPORT int cgGetAnnotationArraySize(CGannotation, int dimension);

PSGLFX_EXPORT const float *cgGetFloatAnnotationValues(CGannotation, int *nvalues);
PSGLFX_EXPORT const int *cgGetIntAnnotationValues(CGannotation, int *nvalues);
PSGLFX_EXPORT const char *cgGetStringAnnotationValue(CGannotation);
PSGLFX_EXPORT const int *cgGetBooleanAnnotationValues(CGannotation, int *nvalues);

PSGLFX_EXPORT int cgGetNumDependentAnnotationParameters(CGannotation);
PSGLFX_EXPORT CGparameter cgGetDependentAnnotationParameter(CGannotation, int index);

PSGLFX_EXPORT void cgEvaluateProgram(CGprogram, float *, int ncomps, int nx, int ny, int nz);

#endif

#ifdef __cplusplus
}
#endif

#endif
