/* SCE CONFIDENTIAL
 * PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 *                Copyright (C) 2006 Sony Computer Entertainment Inc.
 *                                               All Rights Reserved.
 */

#ifndef	__PSGLPM_H__
#define	__PSGLPM_H__

#include "PSGL/platform.h"

#ifdef	__cplusplus	  
extern "C" 
{
#endif


typedef	enum
{
	PSGLPM_OK	= 0,
	PSGLPM_ERROR_BAD_ENUMERATOR,
	PSGLPM_ERROR_COUNTER_NOT_ENABLED,
	PSGLPM_ERROR_DRIVER_MISMATCH,	// never returned
	PSGLPM_ERROR_EXPERIMENT_INCOMPLETE,
	PSGLPM_ERROR_EXPERIMENT_NOT_RUN,
	PSGLPM_ERROR_EXPERIMENT_RUNNING,
	PSGLPM_ERROR_INVALID_COUNTER,
	PSGLPM_ERROR_INVALID_PASS,
	PSGLPM_ERROR_NOT_IN_EXPERIMENT,
	PSGLPM_ERROR_NOT_IN_PASS,
	PSGLPM_ERROR_NOT_INITIALIZED,
	PSGLPM_ERROR_PASS_SKIPPED,
	PSGLPM_ERROR_STRING_TOO_SMALL,
	PSGLPM_ERROR_UNKNOWN_OBJECT,
	PSGLPM_OUT_OF_MEMORY,
	PSGLPM_WARNING_DRAW_COUNT_CHANGED,
	PSGLPM_WARNING_ENDED_EARLY,
	PSGLPM_WARNING_EXPERIMENT_NOT_ENDED,
	PSGLPM_WARNING_NO_COUNTERS,
	PSGLPM_WARNING_PASS_INCOMPLETE,
	PSGLPM_WARNING_PASS_NOT_ENDED,
	PSGLPM_WARNING_OBJECT_NOT_ENDED,
	PSGLPM_WARNING_FEATURE_NOT_IMPLEMENTED
}	PSGLPMRESULT;

#define	PSGLPM_MAX_OBJECTS	1024	// too high, base this on NVGLE limits TO DO


// setup
PSGLPMRESULT	PSGLPMInit();

// shutdown
PSGLPMRESULT	PSGLPMShutdown();

// enumerate available counters
typedef PSGLPMRESULT	(*PSGLPMEnumFunc)(unsigned int unCounterIndex, char * pcCounterName);

// retrieve the number of counters available
PSGLPMRESULT	PSGLPMEnumCounters(PSGLPMEnumFunc pEnumFunction);

// get various counter information
PSGLPMRESULT	PSGLPMGetNumCounters(unsigned int *punCount);
PSGLPMRESULT	PSGLPMGetCounterName(unsigned int unCounterIndex, char * pcString, unsigned int * punLen);
PSGLPMRESULT	PSGLPMGetCounterDescription(unsigned int unCounterIndex, char * pcString, unsigned int * punLen);
PSGLPMRESULT	PSGLPMGetCounterAttribute(unsigned int unCounterIndex, unsigned int unAttribute, unsigned int * punValue);

// enable a counter for sampling
PSGLPMRESULT	PSGLPMAddCounterByName(char * pcName);
PSGLPMRESULT	PSGLPMAddCounter(unsigned int unIndex);
PSGLPMRESULT	PSGLPMAddCounters(unsigned int unCount, unsigned int * punIndices);

// disable a counter
PSGLPMRESULT	PSGLPMRemoveCounterByName(char * pcName);
PSGLPMRESULT	PSGLPMRemoveCounter(unsigned int unIndex);
PSGLPMRESULT	PSGLPMRemoveCounters(unsigned int unCount, unsigned int * punIndices);
PSGLPMRESULT	PSGLPMRemoveAllCounters();

// sample each frame
PSGLPMRESULT	PSGLPMSample(void * dummy, int * nCount);

// experiment interface
PSGLPMRESULT	PSGLPMBeginExperiment(int * pnNumPasses);
PSGLPMRESULT	PSGLPMEndExperiment();

// pass interface
PSGLPMRESULT	PSGLPMBeginPass(int nPass);
PSGLPMRESULT	PSGLPMEndPass(int nPass);

// object interface
PSGLPMRESULT	PSGLPMAllocObjects(int nObjects);
PSGLPMRESULT	PSGLPMBeginObject(int nObjectID);
PSGLPMRESULT	PSGLPMEndObject(int nObjectID);

// retrieving results
PSGLPMRESULT	PSGLPMGetCounterValueByName(char * pcName, int nObjectID, PSGLuint64 * pulValue, PSGLuint64 * pulCycles);
PSGLPMRESULT	PSGLPMGetCounterValue(unsigned int unIndex, int nObjectID, PSGLuint64 * pulValue, PSGLuint64 * pulCycles);
PSGLPMRESULT	PSGLPMGetGPUBottleneckName(unsigned int ulValue, char * pcName);

// misc functions
unsigned int	PSGLPMGetExtendedError();

#ifdef	__cplusplus	  
}
#endif



#endif

