/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2004 Sony Computer Entertainment Inc. 
* All Rights Reserved.
*/
// divf4 - for each of four float slots, divide numer by denom.

_FUNC_DEF(
   vec_float4, 
   divf4,
   ( vec_float4 numer, vec_float4 denom ))
{  
   // Reciprocal estimate and 1 Newton-Raphson iteration.

   vec_float4 y0, y0numer;

   y0 = vec_re( denom );
   y0numer = vec_madd( numer, y0, (vec_float4)(0.0f) );
   return vec_madd( vec_nmsub( denom, y0, (vec_float4)(1.0f) ), y0numer, y0numer );
}

