/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2004 Sony Computer Entertainment Inc. 
* All Rights Reserved.
*/
// rsqrtf4 - for each of four float slots, compute reciprocal square root.
// Undefined if input < 0.
      
_FUNC_DEF(
   vec_float4,
   rsqrtf4,
   ( vec_float4 x ))
{ 
   // Reciprocal square root estimate and 1 Newton-Raphson iteration.
 
   vec_float4 zero = (vec_float4)(0.0f);
   vec_float4 half = (vec_float4)(0.5f);
   vec_float4 one = (vec_float4)(1.0f);
   vec_float4 y0, y0x, y0half;

   y0 = vec_rsqrte( x );
   y0x = vec_madd( y0, x, zero );
   y0half = vec_madd( y0, half, zero );
   return vec_madd( vec_nmsub( y0, y0x, one ), y0half, y0 );
}

