/* SCE CONFIDENTIAL
 PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc. 
 * All Rights Reserved.
 */  

#ifndef __CELL_DMUX_H__
#define __CELL_DMUX_H__

#include <types.h>
#include <stdbool.h>
#include <stdint.h>
#include <cell/error.h>

#ifdef __cplusplus
extern "C" {
#endif

/** error code **/

/*
	CELL_ERROR_FACILITY_CODEC				0x061
		libdmux		: 0x8061_0201 - 0x8061_02ff
*/

#define CELL_DMUX_ERROR_ARG       CELL_ERROR_CAST(0x80610201)
#define CELL_DMUX_ERROR_SEQ       CELL_ERROR_CAST(0x80610202)
#define CELL_DMUX_ERROR_BUSY      CELL_ERROR_CAST(0x80610203)
#define CELL_DMUX_ERROR_EMPTY     CELL_ERROR_CAST(0x80610204)
#define CELL_DMUX_ERROR_FATAL     CELL_ERROR_CAST(0x80610205)


/** enums **/

/**
 *
 */
typedef enum {
    CELL_DMUX_STREAM_TYPE_UNDEF = 0,
    CELL_DMUX_STREAM_TYPE_PAMF,
    CELL_DMUX_STREAM_TYPE_TERMINATOR,
} CellDmuxStreamType;


/**
 *
 */
typedef enum {
    CELL_DMUX_MSG_TYPE_DEMUX_DONE = 0,
    CELL_DMUX_MSG_TYPE_FATAL_ERR,
} CellDmuxMsgType;

typedef enum {
    CELL_DMUX_ES_MSG_TYPE_AU_FOUND = 0,
	CELL_DMUX_ES_MSG_TYPE_FLUSH_DONE,
} CellDmuxEsMsgType;


/**
 * opaque handle to Demuxer
 */
typedef void *CellDmuxHandle;

/**
 * opaque handle to ES
 */
typedef void *CellDmuxEsHandle;


/* callback message structs and function types */

/**
 * CellDmuxMsg
 * msgType
 *  - CELL_DMUX_MSG_TYPE_DEMUX_DONE
 *  - CELL_DMUX_MSG_TYPE_FATAL_ERR
 */
typedef struct {
    uint32_t msgType;
    uint64_t supplementalInfo;
} CellDmuxMsg;

/**
 * CellDmuxEsMsg
 * msgType
 * - CELL_DMUX_ES_MSG_TYPE_AU_FOUND
 */
typedef struct {
    uint32_t msgType;
    uint64_t supplementalInfo;
} CellDmuxEsMsg;

/**
 *
 */
typedef uint32_t (*CellDmuxCbMsg)(CellDmuxHandle     demuxerHandle,
                                  const CellDmuxMsg *demuxerMsg,
                                  void              *cbArg);

/**
 *
 */
typedef uint32_t (*CellDmuxCbEsMsg)(CellDmuxHandle       demuxerHandle,
                                    CellDmuxEsHandle     esHandle,
                                    const CellDmuxEsMsg *esMsg,
                                    void                *cbArg);


/** structs **/

/**
 *
 */
typedef struct {
    CellDmuxStreamType streamType; /**< demuxed stream type */
    int32_t            reserved1;  /**< reserved for future use. must be 0 */
    int32_t            reserved2;  /**< reserved for future use. must be 0 */
} CellDmuxType;

/**
 *
 */
typedef struct {
    void    *memAddr;
    size_t   memSize;
    uint32_t ppuThreadPriority;
    size_t   ppuThreadStackSize;
    uint32_t spuThreadPriority;
    uint32_t numOfSpus;
} CellDmuxResource;

/**
 *
 */
typedef struct {
    CellDmuxCbMsg  cbFunc;
    void          *cbArg;
} CellDmuxCb;

/**
 *
 */
typedef struct {
    CellDmuxCbEsMsg  cbFunc;
    void            *cbArg;
} CellDmuxEsCb;

/**
 *
 */
typedef struct {
    size_t   memSize;
    uint32_t demuxerVerUpper;
	uint32_t demuxerVerLower;
} CellDmuxAttr;

/**
 *
 */
typedef struct {
    size_t memSize;
} CellDmuxEsAttr;

/**
 * case PAM
 * - filterIdMajor     : stream_id:
 * - filterIdMinor     : private_stream_id
 */
typedef struct {
    uint32_t filterIdMajor;
    uint32_t filterIdMinor;
    uint32_t supplementalInfo1;
    uint32_t supplementalInfo2;
} CellDmuxEsFilterId;

/**
 * memory resource for each ES
 */
typedef struct {
    void  *memAddr;
    size_t memSize;
} CellDmuxEsResource;

/**
 * AU(access unit) information
 */
typedef struct {
    void    *auAddr;
    size_t   auSize;
    size_t   auMaxSize;
    uint64_t userData;
    uint32_t ptsUpper; /**< 0xffffffff if unused */
    uint32_t ptsLower; /**< 0xffffffff if unused */
    uint32_t dtsUpper; /**< 0xffffffff if unused */
    uint32_t dtsLower; /**< 0xffffffff if unused */
} CellDmuxAuInfo;


/** functions **/

/**
 *
 */
int32_t
cellDmuxQueryAttr(const CellDmuxType *demuxerType, 
                  CellDmuxAttr       *demuxerAttr);

/**
 *
 */
int32_t
cellDmuxOpen(const CellDmuxType     *demuxerType,
             const CellDmuxResource *demuxerResource,
             const CellDmuxCb       *demuxerCb,
             CellDmuxHandle         *demuxerHandle);

/**
 *
 */
int32_t
cellDmuxClose(CellDmuxHandle demuxerHandle);

/**
 *
 */
int32_t
cellDmuxSetStream(CellDmuxHandle demuxerHandle,
                  const void    *streamAddress,
                  size_t         streamSize,
                  bool           discontinuity,
                  uint64_t       userData);

/**
 *
 */
int32_t
cellDmuxResetStream(CellDmuxHandle demuxerHandle);


/**
 *
 */
int32_t
cellDmuxQueryEsAttr(const CellDmuxType       *demuxerType,
                    const CellDmuxEsFilterId *esFilterId,
                    const void               *esSpecificInfo,
                    CellDmuxEsAttr           *esAttr);

/**
 *
 */
int32_t
cellDmuxEnableEs(CellDmuxHandle            demuxerHandle,
                 const CellDmuxEsFilterId *esFilterId,
                 const CellDmuxEsResource *esResource,
                 const CellDmuxEsCb       *esCb,
                 const void               *esSpecificInfo,
                 CellDmuxEsHandle         *esHandle);

/**
 *
 */
int32_t
cellDmuxDisableEs(CellDmuxEsHandle esHandle);

/**
 *
 */
int32_t
cellDmuxGetAu(CellDmuxEsHandle       esHandle,
              const CellDmuxAuInfo **auInfo,
              void                 **auSpecificInfo);

/**
 *
 */
int32_t
cellDmuxReleaseAu(CellDmuxEsHandle esHandle);

/**
 *
 */
int32_t
cellDmuxFlushEs(CellDmuxEsHandle esHandle);

/**
 *
 */
int32_t
cellDmuxResetEs(CellDmuxEsHandle esHandle);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /*__CELL_DMUX_H__*/
/*[eof]*/
