/* SCE CONFIDENTIAL
 PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2005 Sony Computer Entertainment Inc. 
 * All Rights Reserved.
 */  

#ifndef	 __CELL_VDEC_H__
#define	 __CELL_VDEC_H__

#include <types.h>
#include <stdbool.h>
#include <cell/error.h>

#ifdef __cplusplus
extern "C" {
#endif


/**
 * error code defines
 */

/* wrong or invalid parameter */
#define CELL_VDEC_ERROR_ARG   CELL_ERROR_CAST(0x80610101)

/* wrong or invalid calling sequence */
#define CELL_VDEC_ERROR_SEQ   CELL_ERROR_CAST(0x80610102)

/* there is no space for input data */
#define CELL_VDEC_ERROR_BUSY  CELL_ERROR_CAST(0x80610103)

/* there is no data for output */
#define CELL_VDEC_ERROR_EMPTY CELL_ERROR_CAST(0x80610104)

/* the access unit was disregarded due to error */
#define CELL_VDEC_ERROR_AU    CELL_ERROR_CAST(0x80610105)

/* the picture is incomplete condition */
#define CELL_VDEC_ERROR_PIC   CELL_ERROR_CAST(0x80610106)

/* fatal error! you must close the library immediately */
#define CELL_VDEC_ERROR_FATAL CELL_ERROR_CAST(0x80610180)


/**
 * other defines
 */

/* PTS value indicate invalid */
#define CELL_VDEC_PTS_INVALID 0xffffffff

/* DTS value indicate invalid */
#define CELL_VDEC_DTS_INVALID 0xffffffff


/**
 * available CODEC types for using library.
 */
typedef enum {

	CELL_VDEC_CODEC_TYPE_MPEG2,

	CELL_VDEC_CODEC_TYPE_AVC,



	CELL_VDEC_CODEC_TYPE_MAX,

} CellVdecCodecType;


/**
 * data type for callback message code
 */
typedef enum {

	CELL_VDEC_MSG_TYPE_AUDONE,                     /**< decode finish callback.
													*/
	CELL_VDEC_MSG_TYPE_PICOUT,                     /**< decoded picture available callback.
													*/
	CELL_VDEC_MSG_TYPE_SEQDONE,                    /**< end sequence done callback
													*/
	CELL_VDEC_MSG_TYPE_ERROR,                      /**< fatal error occured!
													*/
} CellVdecMsgType;


/**
 * data type for decoder operation mode
 */
typedef enum {

	CELL_VDEC_DEC_MODE_NORMAL,                     /**< normal decode mode
													*/
	CELL_VDEC_DEC_MODE_B_SKIP,                     /**< B picture skip mode
													*/
} CellVdecDecodeMode;


/**
 * data type for output picture format type
 */
typedef enum {

	CELL_VDEC_PICFMT_ARGB32_ILV,

	CELL_VDEC_PICFMT_RGBA32_ILV,

	CELL_VDEC_PICFMT_UYVY422_ILV,

	CELL_VDEC_PICFMT_YUV420_PLANAR,

} CellVdecPicFormatType;

/**
 * data type for output color matrix coefficient.
 */
typedef enum {

	CELL_VDEC_COLOR_MATRIX_TYPE_BT601,

	CELL_VDEC_COLOR_MATRIX_TYPE_BT709,

} CellVdecColorMatrixType;

/**
 * data type for output picture format type
 */
typedef enum {

	CELL_VDEC_PICITEM_ATTR_NORMAL,

	CELL_VDEC_PICITEM_ATTR_SKIPPED,

} CellVdecPicAttr;


/**
 * type of libvdec handle.
 */
typedef void* CellVdecHandle;


/**
 * data type for codec type information
 */
typedef struct CellVdecType {

	CellVdecCodecType        codecType;            /**< type of codec
													*/
	uint32_t                 profileLevel;         /**< profile and level
													*/
} CellVdecType;


/**
 * data type for library attributes infomation
 */
typedef struct CellVdecAttr {

	size_t                   memSize;              /**< memory size library required
													*/
	uint8_t                  cmdDepth;             /**< depth of the command queue
													*/
	uint32_t                 decoderVerUpper;      /**< reserved
													*/
	uint32_t                 decoderVerLower;      /**< reserved
													*/
} CellVdecAttr;


/**
 * data type for opening configuration information
 */
typedef struct CellVdecResource {

	void                    *memAddr;

	size_t                   memSize;

	int32_t                  ppuThreadPriority;

	size_t                   ppuThreadStackSize;

	int32_t                  spuThreadPriority;

	uint32_t                 numOfSpus;

} CellVdecResource;


/**
 * data type for presentation or decode time stamp
 */
typedef struct CellVdecTimeStamp {

	uint32_t                 upper;

	uint32_t                 lower;

} CellVdecTimeStamp;


/**
 * data type for access unit information
 */
typedef struct CellVdecAuInfo {

	void                    *startAddr;            /**< start address of an access unit
													*/
	size_t                   size;                 /**< size of an access unit
													*/
	CellVdecTimeStamp        pts;                  /**< PTS value.
													*/
	CellVdecTimeStamp        dts;                  /**< DTS value.
													*/
	uint64_t                 userData;             /**< data for user defined
													*/
	uint64_t                 codecSpecificData;    /**< reserved.
													*/
} CellVdecAuInfo;


/**
 * data type for output picture information
 */
typedef struct CellVdecPicItem {

	CellVdecCodecType        codecType;            /**< codec type of CellVdecPicItem.
													*/
	void                    *startAddr;            /**< start address of decoded picture buffer
													*/
	size_t                   size;                 /**< size of decoded picture buffer
													*/
	uint8_t                  auNum;                /**< number of access units
													*/
	CellVdecTimeStamp        auPts[2];             /**< presentation time stamp (PTS).
													*/
	CellVdecTimeStamp        auDts[2];             /**< decoding time stamp (DTS).
													*/
	uint64_t                 auUserData[2];        /**< UserData from AuInfo struct.
													*/
	int32_t                  status;               /**< picture output status
													*/
	CellVdecPicAttr          attr;                 /**< supplemental info.
													*/
	void                    *picInfo;              /**< extra data of codec specific info
													*/
} CellVdecPicItem;


/**
 * data type for output picture format
 */
typedef struct CellVdecPicFormat {

	CellVdecPicFormatType    formatType;

	CellVdecColorMatrixType  colorMatrixType;

	uint8_t                  alpha;

} CellVdecPicFormat;


/**
 * types of user defined callback function
 */
typedef uint32_t
(*CellVdecCbMsg)(

	CellVdecHandle           handle,

	CellVdecMsgType          msgType,

	int32_t                  msgData,

	void                    *cbArg );


/**
 * data type for callback function information
 */
typedef struct CellVdecCb {

	CellVdecCbMsg            cbFunc;               /**< pointer for callback function
													*/
	void                    *cbArg;                /**< user argument of callback function
													*/
} CellVdecCb;


/**
 * Interfaces of Video Decoder Library
 */
int32_t
cellVdecQueryAttr(
	const CellVdecType      *type,
	CellVdecAttr            *attr );


int32_t
cellVdecOpen(
	const CellVdecType      *type,
	const CellVdecResource  *resource,
	const CellVdecCb        *cb,
	CellVdecHandle          *handle );


int32_t
cellVdecClose(
	CellVdecHandle           handle );


int32_t
cellVdecStartSeq(
	CellVdecHandle           handle );


int32_t
cellVdecEndSeq(
	CellVdecHandle           handle );


int32_t
cellVdecDecodeAu(
	CellVdecHandle           handle,
	CellVdecDecodeMode       mode,
	const CellVdecAuInfo    *auInfo );


int32_t
cellVdecGetPicture(
	CellVdecHandle           handle,
	const CellVdecPicFormat *format,
	void                    *outBuff );


int32_t
cellVdecGetPicItem(
	CellVdecHandle           handle,
	const CellVdecPicItem  **picItem );


#ifdef __cplusplus
}
#endif

#endif /* __CELL_VDEC_H__ */
