/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2005 Sony Computer Entertainment Inc. 
* All Rights Reserved.
*/


/* dbg.h */

#ifndef _CELL_DBG_H
#define _CELL_DBG_H


enum {CELL_DBG_RAW_SPU_INTR_NOT_PROCESSED=0, CELL_DBG_RAW_SPU_INTR_PROCESSED};

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifdef CELL_DBG
int cellDbgRawSpuInitialize(uint16_t number_of_raw_spu);
int cellDbgRawSpuHandleInterrupt(sys_raw_spu_t raw_spu);
void cellDbgRawSpuSetRunControl(sys_raw_spu_t raw_spu, int sw, uint32_t npc);
int cellDbgRawSpuLockExecutionControl(sys_raw_spu_t raw_spu, usecond_t timeout);
int cellDbgRawSpuUnlockExecutionControl(sys_raw_spu_t raw_spu);
#else	// CELL_DBG
#define cellDbgRawSpuInitialize(number_of_raw_spu) (CELL_OK)
#define cellDbgRawSpuHandleInterrupt(raw_spu) (CELL_DBG_RAW_SPU_INTR_NOT_PROCESSED)
#define cellDbgRawSpuSetRunControl(raw_spu, sw, npc) \
	{ uint64_t base = (RAW_SPU_OFFSET * raw_spu + RAW_SPU_BASE_ADDR + RAW_SPU_PROB_OFFSET); \
	  *((volatile uint32_t *) (base + 0x4034)) = npc; \
	  *((volatile uint32_t *) (base + 0x401c)) = (sw != 0); \
	}
#define cellDbgRawSpuLockExecutionControl(raw_spu, timeout) (CELL_OK)
#define cellDbgRawSpuUnlockExecutionControl(raw_spu) (CELL_OK)
#endif	// CELL_DBG

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* _CELL_DBG_H */
///////////////////////////////////////////////////////////////////

/* end of dbg.h */

