/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2006 Sony Computer Entertainment Inc. 
* All Rights Reserved.
*/

#ifndef __CELL_GCM_H__
#define __CELL_GCM_H__

#ifndef __CELL_CELL_ERROR_H__
#include <cell/error.h>	// target/common/include/cell/error.h
#endif

/*
	CELL_ERROR_FACILITY_GFX		0x021
	libgcm			: 0x8021_0001 - 0x8021_00ff
*/
#define CELL_GCM_MAKE_ERROR(status) \
	CELL_ERROR_MAKE_ERROR(CELL_ERROR_FACILITY_GFX, status)

#define CELL_GCM_ERROR_FAILURE		CELL_GCM_MAKE_ERROR(0x00ff)


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef _STDINT
#include <stdint.h>
#endif

#ifndef _STDBOOL
#include <stdbool.h>
#endif

#ifndef _cg_h
#include <Cg/cg.h>
#endif

typedef enum {
	//	Enable
	CELL_GCM_FALSE	= (0),
	CELL_GCM_TRUE	= (1),

	// Location
	CELL_GCM_LOCATION_LOCAL	= (0),
	CELL_GCM_LOCATION_MAIN	= (1),


	// SetSurface
	CELL_GCM_SURFACE_X1R5G5B5_Z1R5G5B5	= (1),
	CELL_GCM_SURFACE_X1R5G5B5_O1R5G5B5	= (2),
	CELL_GCM_SURFACE_R5G6B5				= (3),
	CELL_GCM_SURFACE_X8R8G8B8_Z8R8G8B8	= (4),
	CELL_GCM_SURFACE_X8R8G8B8_O8R8G8B8	= (5),
	CELL_GCM_SURFACE_A8R8G8B8			= (8),
	CELL_GCM_SURFACE_B8					= (9),
	CELL_GCM_SURFACE_G8B8				= (10),
	CELL_GCM_SURFACE_F_W16Z16Y16X16		= (11),
	CELL_GCM_SURFACE_F_W32Z32Y32X32		= (12),
	CELL_GCM_SURFACE_F_X32				= (13),
	CELL_GCM_SURFACE_X8B8G8R8_Z8B8G8R8	= (14),
	CELL_GCM_SURFACE_X8B8G8R8_O8B8G8R8	= (15),
	CELL_GCM_SURFACE_A8B8G8R8			= (16),

	CELL_GCM_SURFACE_Z16	= (1),
	CELL_GCM_SURFACE_Z24S8	= (2),

	CELL_GCM_SURFACE_PITCH		= (1),
	CELL_GCM_SURFACE_SWIZZLE	= (2),

	CELL_GCM_SURFACE_CENTER_1				= (0),
	CELL_GCM_SURFACE_DIAGONAL_CENTERED_2	= (3),
	CELL_GCM_SURFACE_SQUARE_CENTERED_4		= (4),
	CELL_GCM_SURFACE_SQUARE_ROTATED_4		= (5),

	CELL_GCM_SURFACE_TARGET_NONE	= (0),
	CELL_GCM_SURFACE_TARGET_0		= (1),
	CELL_GCM_SURFACE_TARGET_1		= (2),
	CELL_GCM_SURFACE_TARGET_MRT1	= (0x13),
	CELL_GCM_SURFACE_TARGET_MRT2	= (0x17),
	CELL_GCM_SURFACE_TARGET_MRT3	= (0x1f),

	// SetClearSurface
	CELL_GCM_CLEAR_Z	= (1<<0),
	CELL_GCM_CLEAR_S	= (1<<1),
	CELL_GCM_CLEAR_R	= (1<<4),
	CELL_GCM_CLEAR_G	= (1<<5),
	CELL_GCM_CLEAR_B	= (1<<6),
	CELL_GCM_CLEAR_A	= (1<<7),
	CELL_GCM_CLEAR_M	= (0xf3),

	// SetVertexDataArray
	CELL_GCM_VERTEX_S1		= (1),
	CELL_GCM_VERTEX_F		= (2),
	CELL_GCM_VERTEX_SF		= (3),
	CELL_GCM_VERTEX_UB		= (4),
	CELL_GCM_VERTEX_S32K	= (5),
	CELL_GCM_VERTEX_CMP		= (6),
	CELL_GCM_VERTEX_UB256	= (7),

	CELL_GCM_VERTEX_S16_NR		            = (1),
	CELL_GCM_VERTEX_F32		                = (2),
	CELL_GCM_VERTEX_F16		                = (3),
	CELL_GCM_VERTEX_U8_NR		            = (4),
	CELL_GCM_VERTEX_S16_UN	                = (5),
	CELL_GCM_VERTEX_S11_11_10_NR		    = (6),
	CELL_GCM_VERTEX_U8_UN	                = (7),

	// SetTexture
	CELL_GCM_TEXTURE_B8						= (0x81),
	CELL_GCM_TEXTURE_A1R5G5B5				= (0x82),
	CELL_GCM_TEXTURE_A4R4G4B4				= (0x83),
	CELL_GCM_TEXTURE_R5G6B5					= (0x84),
	CELL_GCM_TEXTURE_A8R8G8B8				= (0x85),
	CELL_GCM_TEXTURE_COMPRESSED_DXT1		= (0x86),
	CELL_GCM_TEXTURE_COMPRESSED_DXT23		= (0x87),
	CELL_GCM_TEXTURE_COMPRESSED_DXT45		= (0x88),
	CELL_GCM_TEXTURE_G8B8					= (0x8B),
	CELL_GCM_TEXTURE_R6G5B5					= (0x8F),
	CELL_GCM_TEXTURE_DEPTH24_D8				= (0x90),
	CELL_GCM_TEXTURE_DEPTH24_D8_FLOAT		= (0x91),
	CELL_GCM_TEXTURE_DEPTH16				= (0x92),
	CELL_GCM_TEXTURE_DEPTH16_FLOAT			= (0x93),
	CELL_GCM_TEXTURE_X16					= (0x94),
	CELL_GCM_TEXTURE_Y16_X16				= (0x95),
	CELL_GCM_TEXTURE_R5G5B5A1				= (0x97),
	CELL_GCM_TEXTURE_COMPRESSED_HILO8		= (0x98),
	CELL_GCM_TEXTURE_COMPRESSED_HILO_S8		= (0x99),
	CELL_GCM_TEXTURE_W16_Z16_Y16_X16_FLOAT	= (0x9A),
	CELL_GCM_TEXTURE_W32_Z32_Y32_X32_FLOAT	= (0x9B),
	CELL_GCM_TEXTURE_X32_FLOAT				= (0x9C),
	CELL_GCM_TEXTURE_D1R5G5B5				= (0x9D),
	CELL_GCM_TEXTURE_D8R8G8B8				= (0x9E),
	CELL_GCM_TEXTURE_Y16_X16_FLOAT			= (0x9F),

	CELL_GCM_TEXTURE_SZ	= (0x00),
	CELL_GCM_TEXTURE_LN	= (0x20),
	CELL_GCM_TEXTURE_NR	= (0x00),
	CELL_GCM_TEXTURE_UN	= (0x40),

	CELL_GCM_TEXTURE_DIMENSION_1		= (1),
	CELL_GCM_TEXTURE_DIMENSION_2		= (2),
	CELL_GCM_TEXTURE_DIMENSION_3		= (3),

	CELL_GCM_TEXTURE_REMAP_ORDER_XYXY	= (0),
	CELL_GCM_TEXTURE_REMAP_ORDER_XXXY	= (1),
	CELL_GCM_TEXTURE_REMAP_FROM_A		= (0),
	CELL_GCM_TEXTURE_REMAP_FROM_R		= (1),
	CELL_GCM_TEXTURE_REMAP_FROM_G		= (2),
	CELL_GCM_TEXTURE_REMAP_FROM_B		= (3),
	CELL_GCM_TEXTURE_REMAP_ZERO			= (0),
	CELL_GCM_TEXTURE_REMAP_ONE			= (1),
	CELL_GCM_TEXTURE_REMAP_REMAP		= (2),

	// SetTextureFilter
	CELL_GCM_TEXTURE_NEAREST			= (1),
	CELL_GCM_TEXTURE_LINEAR				= (2),
	CELL_GCM_TEXTURE_NEAREST_NEAREST	= (3),
	CELL_GCM_TEXTURE_LINEAR_NEAREST		= (4),
	CELL_GCM_TEXTURE_NEAREST_LINEAR		= (5),
	CELL_GCM_TEXTURE_LINEAR_LINEAR		= (6),
	CELL_GCM_TEXTURE_CONVOLUTION_MIN	= (7),
	CELL_GCM_TEXTURE_CONVOLUTION_MAG	= (4),
	CELL_GCM_TEXTURE_CONVOLUTION_QUINCUNX		= (1),
	CELL_GCM_TEXTURE_CONVOLUTION_GAUSSIAN		= (2),
	CELL_GCM_TEXTURE_CONVOLUTION_QUINCUNX_ALT	= (3),

	// SetTextureAddress
	CELL_GCM_TEXTURE_WRAP						= (1),
	CELL_GCM_TEXTURE_MIRROR						= (2),
	CELL_GCM_TEXTURE_CLAMP_TO_EDGE				= (3),
	CELL_GCM_TEXTURE_BORDER						= (4),
	CELL_GCM_TEXTURE_CLAMP						= (5),
	CELL_GCM_TEXTURE_MIRROR_ONCE_CLAMP_TO_EDGE	= (6),
	CELL_GCM_TEXTURE_MIRROR_ONCE_BORDER			= (7),
	CELL_GCM_TEXTURE_MIRROR_ONCE_CLAMP			= (8),

	CELL_GCM_TEXTURE_UNSIGNED_REMAP_NORMAL	= (0),
	CELL_GCM_TEXTURE_UNSIGNED_REMAP_BIASED	= (1),

	CELL_GCM_TEXTURE_ZFUNC_NEVER	= (0),
	CELL_GCM_TEXTURE_ZFUNC_LESS		= (1),
	CELL_GCM_TEXTURE_ZFUNC_EQUAL	= (2),
	CELL_GCM_TEXTURE_ZFUNC_LEQUAL	= (3),
	CELL_GCM_TEXTURE_ZFUNC_GREATER	= (4),
	CELL_GCM_TEXTURE_ZFUNC_NOTEQUAL	= (5),
	CELL_GCM_TEXTURE_ZFUNC_GEQUAL	= (6),
	CELL_GCM_TEXTURE_ZFUNC_ALWAYS	= (7),

	CELL_GCM_TEXTURE_GAMMA_R	= (1<<0),
	CELL_GCM_TEXTURE_GAMMA_G	= (1<<1),
	CELL_GCM_TEXTURE_GAMMA_B	= (1<<2),
	CELL_GCM_TEXTURE_GAMMA_A	= (1<<3),

	// SetTextureControl
	CELL_GCM_TEXTURE_MAX_ANISO_1	= (0),
	CELL_GCM_TEXTURE_MAX_ANISO_2	= (1),
	CELL_GCM_TEXTURE_MAX_ANISO_4	= (2),
	CELL_GCM_TEXTURE_MAX_ANISO_6	= (3),
	CELL_GCM_TEXTURE_MAX_ANISO_8	= (4),
	CELL_GCM_TEXTURE_MAX_ANISO_10	= (5),
	CELL_GCM_TEXTURE_MAX_ANISO_12	= (6),
	CELL_GCM_TEXTURE_MAX_ANISO_16	= (7),

	// SetDrawArrays, SetDrawIndexArray
	CELL_GCM_PRIMITIVE_POINTS			= (1),
	CELL_GCM_PRIMITIVE_LINES			= (2),
	CELL_GCM_PRIMITIVE_LINE_LOOP		= (3),
	CELL_GCM_PRIMITIVE_LINE_STRIP		= (4),
	CELL_GCM_PRIMITIVE_TRIANGLES		= (5),
	CELL_GCM_PRIMITIVE_TRIANGLE_STRIP	= (6),
	CELL_GCM_PRIMITIVE_TRIANGLE_FAN		= (7),
	CELL_GCM_PRIMITIVE_QUADS			= (8),
	CELL_GCM_PRIMITIVE_QUAD_STRIP		= (9),
	CELL_GCM_PRIMITIVE_POLYGON			= (10),

	// SetColorMask
	CELL_GCM_COLOR_MASK_B	= (1<<0),
	CELL_GCM_COLOR_MASK_G	= (1<<8),
	CELL_GCM_COLOR_MASK_R	= (1<<16),
	CELL_GCM_COLOR_MASK_A	= (1<<24),

	// SetColorMaskMrt
	CELL_GCM_COLOR_MASK_MRT1_A	= (1<<4),
	CELL_GCM_COLOR_MASK_MRT1_R	= (1<<5),
	CELL_GCM_COLOR_MASK_MRT1_G	= (1<<6),
	CELL_GCM_COLOR_MASK_MRT1_B	= (1<<7),
	CELL_GCM_COLOR_MASK_MRT2_A	= (1<<8),
	CELL_GCM_COLOR_MASK_MRT2_R	= (1<<9),
	CELL_GCM_COLOR_MASK_MRT2_G	= (1<<10),
	CELL_GCM_COLOR_MASK_MRT2_B	= (1<<11),
	CELL_GCM_COLOR_MASK_MRT3_A	= (1<<12),
	CELL_GCM_COLOR_MASK_MRT3_R	= (1<<13),
	CELL_GCM_COLOR_MASK_MRT3_G	= (1<<14),
	CELL_GCM_COLOR_MASK_MRT3_B	= (1<<15),

	// SetAlphaFunc, DepthFunc, StencilFunc
	CELL_GCM_NEVER		= (0x0200),
	CELL_GCM_LESS		= (0x0201),
	CELL_GCM_EQUAL		= (0x0202),
	CELL_GCM_LEQUAL		= (0x0203),
	CELL_GCM_GREATER	= (0x0204),
	CELL_GCM_NOTEQUAL	= (0x0205),
	CELL_GCM_GEQUAL		= (0x0206),
	CELL_GCM_ALWAYS		= (0x0207),

	// SetBlendFunc
	CELL_GCM_ZERO						= (0),
	CELL_GCM_ONE						= (1),
	CELL_GCM_SRC_COLOR					= (0x0300),
	CELL_GCM_ONE_MINUS_SRC_COLOR		= (0x0301),
	CELL_GCM_SRC_ALPHA					= (0x0302),
	CELL_GCM_ONE_MINUS_SRC_ALPHA		= (0x0303),
	CELL_GCM_DST_ALPHA					= (0x0304),
	CELL_GCM_ONE_MINUS_DST_ALPHA		= (0x0305),
	CELL_GCM_DST_COLOR					= (0x0306),
	CELL_GCM_ONE_MINUS_DST_COLOR		= (0x0307),
	CELL_GCM_SRC_ALPHA_SATURATE			= (0x0308),
	CELL_GCM_CONSTANT_COLOR				= (0x8001),
	CELL_GCM_ONE_MINUS_CONSTANT_COLOR	= (0x8002),
	CELL_GCM_CONSTANT_ALPHA				= (0x8003),
	CELL_GCM_ONE_MINUS_CONSTANT_ALPHA	= (0x8004),

	// SetBlendEquation
	CELL_GCM_BLEND_COLOR			= (0x8005),
	CELL_GCM_FUNC_ADD				= (0x8006),
	CELL_GCM_MIN					= (0x8007),
	CELL_GCM_MAX					= (0x8008),
	CELL_GCM_BLEND_EQUATION			= (0x8009),
	CELL_GCM_FUNC_SUBTRACT			= (0x800A),
	CELL_GCM_FUNC_REVERSE_SUBTRACT	= (0x800B),

	// SetCullFace
	CELL_GCM_FRONT			= (0x0404),
	CELL_GCM_BACK			= (0x0405),
	CELL_GCM_FRONT_AND_BACK	= (0x0408),

	// SetShadeMode
	CELL_GCM_FLAT	= (0x1D00),
	CELL_GCM_SMOOTH	= (0x1D01),

	// SetFrontFace
	CELL_GCM_CW		= (0x0900),
	CELL_GCM_CCW	= (0x0901),

	// SetLogicOp
	CELL_GCM_CLEAR			= (0x1500),
	CELL_GCM_AND			= (0x1501),
	CELL_GCM_AND_REVERSE	= (0x1502),
	CELL_GCM_COPY			= (0x1503),
	CELL_GCM_AND_INVERTED	= (0x1504),
	CELL_GCM_NOOP			= (0x1505),
	CELL_GCM_XOR			= (0x1506),
	CELL_GCM_OR				= (0x1507),
	CELL_GCM_NOR			= (0x1508),
	CELL_GCM_EQUIV			= (0x1509),
	CELL_GCM_INVERT			= (0x150A),
	CELL_GCM_OR_REVERSE		= (0x150B),
	CELL_GCM_COPY_INVERTED	= (0x150C),
	CELL_GCM_OR_INVERTED	= (0x150D),
	CELL_GCM_NAND			= (0x150E),
	CELL_GCM_SET			= (0x150F),

	// SetStencilOp
	CELL_GCM_KEEP		= (0x1E00),
	CELL_GCM_REPLACE	= (0x1E01),
	CELL_GCM_INCR		= (0x1E02),
	CELL_GCM_DECR		= (0x1E03),
	CELL_GCM_INCR_WRAP	= (0x8507),
	CELL_GCM_DECR_WRAP	= (0x8508),

	// SetDrawIndexArray
	CELL_GCM_DRAW_INDEX_ARRAY_TYPE_32	= (0),
	CELL_GCM_DRAW_INDEX_ARRAY_TYPE_16	= (1),

	// SetTransfer
	CELL_GCM_TRANSFER_LOCAL_TO_LOCAL	= (0),
	CELL_GCM_TRANSFER_MAIN_TO_LOCAL		= (1),
	CELL_GCM_TRANSFER_LOCAL_TO_MAIN		= (2),

	// SetInvalidateTextureCache
	CELL_GCM_INVALIDATE_TEXTURE			= (1),
	CELL_GCM_INVALIDATE_VERTEX_TEXTURE	= (2),

	// SetFrequencyDividerOperation
	CELL_GCM_FREQUENCY_MODULO	= (1), 
	CELL_GCM_FREQUENCY_DIVIDE	= (0),

	// SetTile, SetZCull
	CELL_GCM_COMPMODE_DISABLED					= (0),
	CELL_GCM_COMPMODE_C32_2X1					= (7),
	CELL_GCM_COMPMODE_C32_2X2					= (8),
	CELL_GCM_COMPMODE_Z32_SEPSTENCIL			= (9),
	CELL_GCM_COMPMODE_Z32_SEPSTENCIL_REG		= (10),
	CELL_GCM_COMPMODE_Z32_SEPSTENCIL_REGULAR	= (10),
	CELL_GCM_COMPMODE_Z32_SEPSTENCIL_DIAGONAL	= (11),
	CELL_GCM_COMPMODE_Z32_SEPSTENCIL_ROTATED	= (12),

	// SetZCull
	CELL_GCM_ZCULL_Z16		= (1),
	CELL_GCM_ZCULL_Z24S8	= (2),
	CELL_GCM_ZCULL_MSB		= (0),
	CELL_GCM_ZCULL_LONES	= (1),
	CELL_GCM_ZCULL_LESS		= (0),
	CELL_GCM_ZCULL_GREATER	= (1),

	// flip mode
	CELL_GCM_DISPLAY_HSYNC	= (1),
	CELL_GCM_DISPLAY_VSYNC	= (2),

	// vsync frequency
	CELL_GCM_DISPLAY_FREQUENCY_59_94HZ =(1),
	CELL_GCM_DISPLAY_FREQUENCY_SCANOUT =(2),
	CELL_GCM_DISPLAY_FREQUENCY_DISABLE =(3),

	CELL_GCM_TYPE_B		= (1),
	CELL_GCM_TYPE_C		= (2),
	CELL_GCM_TYPE_RSX	= (3),

	// MRT
	CELL_GCM_MRT_MAXCOUNT	= (4),

	// max display id
	CELL_GCM_DISPLAY_MAXID	= (8),

	// Debug output level
	CELL_GCM_DEBUG_LEVEL0		= (0),
	CELL_GCM_DEBUG_LEVEL1		= (1),
	CELL_GCM_DEBUG_LEVEL2		= (2),

	// SetRenderEnable
	CELL_GCM_CONDITIONAL		= (2),

	// SetClearReport, SetReport, GetReport
	CELL_GCM_ZPASS_PIXEL_CNT	= (1),
	CELL_GCM_ZCULL_STATS		= (2),
	CELL_GCM_ZCULL_STATS1		= (3),
	CELL_GCM_ZCULL_STATS2		= (4),
	CELL_GCM_ZCULL_STATS3		= (5),

	// SetPointSpriteControl
	CELL_GCM_POINT_SPRITE_RMODE_ZERO       = (0),
	CELL_GCM_POINT_SPRITE_RMODE_FROM_R     = (1),
	CELL_GCM_POINT_SPRITE_RMODE_FROM_S     = (2),

	CELL_GCM_POINT_SPRITE_TEX0             = (1<<8),
	CELL_GCM_POINT_SPRITE_TEX1             = (1<<9),
	CELL_GCM_POINT_SPRITE_TEX2             = (1<<10),
	CELL_GCM_POINT_SPRITE_TEX3             = (1<<11),
	CELL_GCM_POINT_SPRITE_TEX4             = (1<<12),
	CELL_GCM_POINT_SPRITE_TEX5             = (1<<13),
	CELL_GCM_POINT_SPRITE_TEX6             = (1<<14),
	CELL_GCM_POINT_SPRITE_TEX7             = (1<<15),
	CELL_GCM_POINT_SPRITE_TEX8             = (1<<16),
	CELL_GCM_POINT_SPRITE_TEX9             = (1<<17),

	// SetUserClipPlaneControl
	CELL_GCM_USER_CLIP_PLANE_DISABLE       = (0),
	CELL_GCM_USER_CLIP_PLANE_ENABLE_LT     = (1),
	CELL_GCM_USER_CLIP_PLANE_ENABLE_GE     = (2),

	// SetFrontPolygonMode, SetBackPolygonMode
	CELL_GCM_POLYGON_MODE_POINT            = (0x1b00),
	CELL_GCM_POLYGON_MODE_LINE             = (0x1b01),
	CELL_GCM_POLYGON_MODE_FILL             = (0x1b02),

}CellGcmEnum;

typedef volatile struct {
	uint32_t	put;
	uint32_t	get;
	uint32_t	ref;
}CellGcmControl;

typedef struct {
	void		*localAddress;
	void		*ioAddress;
	uint32_t	localSize;
	uint32_t	ioSize;
	uint32_t	memoryFrequency;
	uint32_t	coreFrequency;
}CellGcmConfig;

typedef struct {
	uint8_t		type;
	uint8_t		antialias;

	uint8_t		colorFormat;
	uint8_t		colorTarget;
	uint8_t		colorLocation[CELL_GCM_MRT_MAXCOUNT];
	uint32_t	colorOffset[CELL_GCM_MRT_MAXCOUNT];
	uint32_t	colorPitch[CELL_GCM_MRT_MAXCOUNT];

	uint8_t		depthFormat;
	uint8_t		depthLocation;
	uint8_t		_padding[2];
	uint32_t	depthOffset;
	uint32_t	depthPitch;

	uint16_t	width;
	uint16_t	height;
	uint16_t	x;
	uint16_t	y;
}CellGcmSurface;

typedef struct {
	uint8_t		format;
	uint8_t		mipmap;
	uint8_t		dimension;
	uint8_t		cubemap;

	uint32_t	remap;

	uint16_t	width;
	uint16_t	height;
	uint16_t	depth;
	uint8_t		location;
	uint8_t		_padding;

	uint32_t	pitch;
	uint32_t	offset;
}CellGcmTexture;

/*	macros		*/
#define CELL_GCM_REMAP_MODE(order, inputA, inputR, inputG, inputB, outputA, outputR, outputG, outputB) \
((order<<16)|(inputA)|(inputR<<2)|(inputG<<4)|(inputB<<6)|(outputA<<8)|(outputR<<10)|(outputG<<12)|(outputB<<14))

/*	system functions	*/
int32_t cellGcmInit(const uint32_t cmdSize, const uint32_t ioSize, const void *ioAddress);
int32_t cellGcmAddressToOffset(const void *address, uint32_t *offset);
int32_t cellGcmMapMainMemory(const void *address, const uint32_t size, uint32_t *offset);
void cellGcmGetConfiguration(CellGcmConfig *config);
CellGcmControl *cellGcmGetControlRegister(void);
uint32_t cellGcmGetTiledPitchSize(const uint32_t size);

void cellGcmSetVBlankHandler(void (*handler)(const uint32_t head));
void cellGcmSetSecondVHandler(void (*handler)(const uint32_t head));
void cellGcmSetGraphicsHandler(void (*handler)(const uint32_t val));
void cellGcmSetFlipHandler(void (*handler)(const uint32_t head));
void cellGcmSetQueueHandler(void (*handler)(const uint32_t head));
void cellGcmSetUserHandler(void (*handler)(const uint32_t cause));
void cellGcmSetDebugOutputLevel(int32_t level);

/*	display functions	*/
int32_t cellGcmSetDisplayBuffer(const uint8_t id, const uint32_t offset, const uint32_t pitch, const uint32_t width, const uint32_t height);
int32_t cellGcmSetFlip(const uint8_t id);
void cellGcmSetWaitFlip(void);
system_time_t cellGcmGetLastFlipTime(void);
void cellGcmSetFlipMode(const uint32_t mode);
int32_t cellGcmSetFlipImmediate(const uint8_t id);
void cellGcmResetFlipStatus(void);
uint32_t cellGcmGetFlipStatus(void);
void cellGcmSetFlipVFrequency(const uint32_t freq);
void cellGcmSetSecondVFrequency(const uint32_t freq);


/* flow control functions */
uint32_t *cellGcmGetCurrentBuffer(void);
void cellGcmSetCurrentBuffer(const uint32_t *addr, const size_t size);
void cellGcmSetDefaultCommandBuffer(void);
void cellGcmSetUserCallback(uint32_t * (*func)(uint32_t space), void (*finish)(void), void (*flush)(void));

void cellGcmSetReferenceCommand(const uint32_t ref);
void cellGcmSetJumpCommand(const uint32_t offset);
void cellGcmSetCallCommand(const uint32_t offset);
void cellGcmSetReturnCommand(void);
void cellGcmSetNopCommand(const uint32_t count);
void cellGcmSetUserCommand(const uint32_t cause);

void cellGcmFinish(void);
void cellGcmFlush(void);


/* cg functions */
void cellGcmCgInitProgram(CGprogram prog);
void cellGcmCgGetUCode(CGprogram prog, void **pUCode, uint32_t *pUCodeSize);
CGparameter cellGcmCgGetNamedParameter(CGprogram prog, const char *name);
CGparameter cellGcmCgGetFirstLeafParameter(CGprogram prog, CGenum name_space);
CGparameter cellGcmCgGetNextLeafParameter(CGprogram prog, CGparameter current);
uint32_t cellGcmCgGetCountParameter(CGprogram prog);
uint32_t cellGcmCgGetInstructions(CGprogram prog);
CGparameter cellGcmCgGetIndexParameter(CGprogram prog, const uint32_t Index);
CGtype cellGcmCgGetParameterType(CGprogram prog, CGparameter param);
CGresource cellGcmCgGetParameterResource(CGprogram prog, CGparameter param);
const char *cellGcmCgGetParameterName(CGprogram prog, CGparameter param);
CGenum cellGcmCgGetParameterVariability(CGprogram prog, CGparameter param);
uint32_t cellGcmCgGetParameterResourceIndex(CGprogram prog, CGparameter param);
const float *cellGcmCgGetParameterValues(CGprogram prog, CGparameter param);
#define cellGcmCgGetParameterIndex cellGcmCgGetParameterOrdinalNumber
int32_t cellGcmCgGetParameterOrdinalNumber(CGprogram prog, CGparameter param);
CGenum cellGcmCgGetParameterDirection(CGprogram prog, CGparameter param);
const char *cellGcmCgGetParameterSemantic(CGprogram prog, CGparameter param);
CGprofile cellGcmCgGetProgramProfile(CGprogram prog);
CGbool cellGcmCgGetParameterReferenced(CGprogram prog, CGparameter param);
uint32_t cellGcmCgGetTotalBinarySize(CGprogram prog);


/*
  render command functions
*/
void cellGcmSetSurface(const CellGcmSurface *surface);
void cellGcmSetAntiAliasingControl(const uint32_t enable, const uint32_t alphaToCoverage, const uint32_t alphaToOne, const uint32_t sampleMask);
void cellGcmSetWaitLabel(const uint8_t index, const uint32_t value);
void cellGcmSetWriteCommandLabel(const uint8_t index, const uint32_t value);
void cellGcmSetWriteBackEndLabel(const uint8_t index, const uint32_t value);
void cellGcmSetWriteTextureLabel(const uint8_t index, const uint32_t value);
uint32_t *cellGcmGetLabelAddress(const uint8_t index);
void cellGcmSetTimeStamp(const uint32_t index);
uint64_t cellGcmGetTimeStamp(const uint32_t index);
void cellGcmSetTile(const uint8_t index, const uint8_t location, const uint32_t offset, const uint32_t size, const uint32_t pitch, const uint8_t comp, const uint16_t base, const uint8_t bank);
void cellGcmSetInvalidateTile(const uint8_t index);
void cellGcmSetZcull(const uint8_t index, const uint32_t offset, const uint32_t width, const uint32_t height, const uint32_t cullStart, const uint32_t zFormat, const uint32_t aaFormat, const uint32_t zCullDir, const uint32_t zCullFormat, const uint32_t sFunc, const uint32_t sRef, const uint32_t sMask);
void cellGcmSetInvalidateZcull(void);

void cellGcmSetAlphaFunc(const uint32_t af, const uint32_t ref);
void cellGcmSetBlendColor(const uint32_t color, const uint32_t color2);
void cellGcmSetBlendEquation(const uint16_t color, const uint16_t alpha);
void cellGcmSetBlendFunc(const uint16_t sfcolor, const uint16_t dfcolor, const uint16_t sfalpha, const uint16_t dfalpha);
void cellGcmSetClearSurface(const uint32_t mask);
void cellGcmSetClearColor(const uint32_t color);
void cellGcmSetClearDepthStencil(const uint32_t value);
void cellGcmSetColorMask(const uint32_t mask);
void cellGcmSetColorMaskMrt(const uint32_t mask);
void cellGcmSetCullFace(const uint32_t cfm);
void cellGcmSetDepthBounds(const float zmin, const float zmax);
void cellGcmSetDepthFunc(const uint32_t zf);
void cellGcmSetDepthMask(const uint32_t enable);
void cellGcmSetFrontFace(const uint32_t dir);
void cellGcmSetLineWidth(const uint32_t width);
void cellGcmSetLineSmoothEnable(const uint32_t enable);
void cellGcmSetLineStippleEnable(const uint32_t enable);
void cellGcmSetLineStipplePattern(const uint16_t* pattern, const uint8_t factor);
void cellGcmSetLogicOp(const uint32_t op);
void cellGcmSetPointSize(const float size);
void cellGcmSetPolygonOffset(const float factor, const float units);
void cellGcmSetPolySmoothEnable(const uint32_t enable);
void cellGcmSetPolygonStippleEnable(const uint32_t enable);
void cellGcmSetPolygonStipplePattern(const uint32_t* pattern);
void cellGcmSetFrontPolygonMode(const uint32_t mode);
void cellGcmSetBackPolygonMode(const uint32_t mode);
void cellGcmSetScissor(const uint16_t x, const uint16_t y, const uint16_t w, const uint16_t h);
void cellGcmSetShadeMode(const uint32_t sm);
void cellGcmSetStencilFunc(const uint32_t func, const int32_t ref, const uint32_t mask);
void cellGcmSetBackStencilFunc(const uint32_t func, const int32_t ref, const uint32_t mask);
void cellGcmSetStencilMask(const uint32_t sm);
void cellGcmSetBackStencilMask(const uint32_t sm);
void cellGcmSetStencilOp(const uint32_t fail, const uint32_t depthFail, const uint32_t depthPass);
void cellGcmSetBackStencilOp(const uint32_t fail, const uint32_t depthFail, const uint32_t depthPass);
void cellGcmSetViewport(const uint16_t x, const uint16_t y, const uint16_t w, const uint16_t h, const float min, const float max, const float scale[4], const float offset[4]);
void cellGcmSetAlphaTestEnable(const uint32_t enable);
void cellGcmSetBlendEnable(const uint32_t enable);
void cellGcmSetBlendEnableMrt(const uint32_t mrt1, const uint32_t mrt2, const uint32_t mrt3);
void cellGcmSetLogicOpEnable(const uint32_t enable);
void cellGcmSetCullFaceEnable(const uint32_t enable);
void cellGcmSetDepthBoundsTestEnable(const uint32_t enable);
void cellGcmSetDepthTestEnable(const uint32_t enable);
void cellGcmSetDitherEnable(const uint32_t enable);
void cellGcmSetStencilTestEnable(const uint32_t enable);
void cellGcmSetTwoSidedStencilTestEnable(const uint32_t enable);
void cellGcmSetPolygonOffsetFillEnable(const uint32_t enable);
void cellGcmSetRestartIndexEnable(const uint32_t enable);
void cellGcmSetPointSpriteEnable(const uint32_t enable);
void cellGcmSetPointSpriteControl(const uint32_t enable, const uint32_t rmode, const uint32_t texcoord);
void cellGcmSetInvalidateTextureCache(const uint32_t value);
void cellGcmSetTextureBorderColor(const uint8_t index, const uint32_t color);
void cellGcmSetTextureFilter(const uint8_t index, const uint16_t bias, const uint8_t min, const uint8_t mag, const uint8_t conv);
void cellGcmSetTextureAddress(const uint8_t index, const uint8_t wraps, const uint8_t wrapt, const uint8_t wrapr, const uint8_t unsignedRemap, const uint8_t zfunc, const uint8_t gamma);
void cellGcmSetTextureControl(const uint8_t index, const uint32_t enable, const uint16_t minlod, const uint16_t maxlod, const uint8_t maxaniso);
void cellGcmSetTexture(const uint8_t index, const CellGcmTexture *texture);

void cellGcmSetDrawArrays(const uint8_t mode, uint32_t first, uint32_t count);
void cellGcmSetDrawIndexArray(const uint8_t mode, uint32_t count, const uint8_t type, const uint8_t location, const uint32_t indicies);
void cellGcmSetInvalidateVertexCache(void);
void cellGcmSetRestartIndex(const uint32_t index);
void cellGcmSetVertexData4f(const uint8_t index, const float v[4]);
void cellGcmSetVertexDataArray(const uint8_t index, const uint16_t frequency, const uint8_t stride, const uint8_t size, const uint8_t type, const uint8_t location, const uint32_t offset);
void cellGcmSetFrequencyDividerOperation(const uint16_t operation);
void cellGcmSetVertexAttribInputMask(const uint16_t mask);

void cellGcmSetVertexProgram(const CGprogram prog, const void *ucode);
void cellGcmSetFragmentProgram(const CGprogram prog, const uint32_t offset);
void cellGcmSetVertexProgramParameter(const CGparameter param, const float *value);
void cellGcmSetVertexProgramParameterBlock(const uint32_t baseConst, uint32_t constCount, const float *value);
void cellGcmSetFragmentProgramParameter(const CGprogram prog, const CGparameter param, const float *value, const uint32_t offset);
void cellGcmSetUpdateFragmentProgramParameter(const uint32_t offset);
void cellGcmSetFragmentProgramGammaEnable(const uint32_t enable);

void cellGcmSetUserClipPlaneControl(const uint32_t plane0, const uint32_t plane1, const uint32_t plane2, const uint32_t plane3, const uint32_t plane4, const uint32_t plane5);

void cellGcmSetVertexProgramConstants(const uint32_t start, const uint32_t count, const float *data);

/*
  data transfer and format conversion functions
*/
void cellGcmInlineTransfer(const uint32_t dstOffset, const void *srcAdr, const uint32_t sizeInWords);
void cellGcmConvertSwizzleFormat(void *swizzledTexture, const void *texture, const uint32_t  dstx0, const uint32_t  dsty0, const uint32_t  dstz0, const uint32_t  dstWidth, const uint32_t  dstHeight, const uint32_t  dstDepth, const uint32_t  srcx0, const uint32_t  srcy0, const uint32_t  srcz0, const uint32_t  srcx1, const uint32_t  srcy1, const uint32_t  srcz1, const uint32_t  srcWidth, const uint32_t  srcHeight, const uint32_t  srcDepth, const uint32_t  dstLog2cdepth, const uint32_t  srcColordepth, const uint32_t  border, const uint32_t  dim, void (*copyTexel)(void *dst, const void *src));
void cellGcmSetConvertSwizzleFormat(const uint32_t dstOffset, const uint32_t dstWidth, const uint32_t dstHeiht, const uint32_t dstX, const uint32_t dstY, const uint32_t srcOffset, const uint32_t srcPitch, const uint32_t srcX, const uint32_t srcY, const uint32_t width, const uint32_t height, const uint32_t bytesPerPixel);
uint32_t cellGcmSetTransferImage(const uint8_t mode, const uint32_t dstOffset, const uint32_t dstPitch, const uint32_t dstX, const uint32_t dstY, const uint32_t srcOffset, const uint32_t srcPitch, const uint32_t srcX, const uint32_t srcY, const uint32_t width, const uint32_t height, const uint32_t bytesPerPixel);
uint32_t cellGcmSetTransferData(const uint8_t mode, const uint32_t dstOffset, const uint32_t dstPitch, const uint32_t srcOffset, const uint32_t srcPitch, const uint32_t bytesPerRow, const uint32_t rowCount);

/*
  conditional rendering functions
*/
void cellGcmSetRenderEnable(const uint8_t mode, const uint32_t index);
void cellGcmSetZpassPixelCountEnable(const uint32_t enable);
void cellGcmSetClearReport(const uint32_t type);
void cellGcmSetReport(const uint32_t type, const uint32_t index);
uint32_t cellGcmGetReport(const uint32_t type, const uint32_t index);
void cellGcmSetZcullStatsEnable(const uint32_t enable);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __CELL_GCM_H__ */
