/*  SCE CONFIDENTIAL                                      */
/*  PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006 */
/*  Copyright (C) 2006 Sony Computer Entertainment Inc.   */
/*  All Rights Reserved.                                  */
#ifndef __CELL_HTTP_ERROR_H__
#define __CELL_HTTP_ERROR_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define CELL_HTTP_NET_ERROR(eHttp, eNet) CELL_ERROR_CAST(eHttp | (eNet & 0xff))

/*
	CELL_ERROR_FACILITY_HTTP			 0x071
		libhttp		: 0x8071_0001 - 0x8071_0fff
		   https    : 0x8071_0a01 - 0x8071_0aff
		libhttp_util: 0x8071_1001 - 0x8071_10ff
 */

#define CELL_HTTP_MAKE_ERROR(status) \
	CELL_ERROR_MAKE_ERROR(CELL_ERROR_FACILITY_HTTP, status)

/*E library has already been initialized */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0001) */
#define CELL_HTTP_ERROR_ALREADY_INITIALIZED         CELL_ERROR_CAST(0x80710001)

/*E the library has not yet been initialized */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0002) */
#define CELL_HTTP_ERROR_NOT_INITIALIZED             CELL_ERROR_CAST(0x80710002)

/*E tried to malloc, but got NULL (no memory) */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0003) */
#define CELL_HTTP_ERROR_NO_MEMORY                   CELL_ERROR_CAST(0x80710003)

/*E no buffer was provided */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0004) */
#define CELL_HTTP_ERROR_NO_BUFFER                   CELL_ERROR_CAST(0x80710004)

/*E invalid string (probably NULL) */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0005) */
#define CELL_HTTP_ERROR_NO_STRING                   CELL_ERROR_CAST(0x80710005)

/*E insufficient buffer */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0006) */
#define CELL_HTTP_ERROR_INSUFFICIENT                CELL_ERROR_CAST(0x80710006)

/* ERR: CELL_HTTP_MAKE_ERROR(0x0007) */
#define CELL_HTTP_ERROR_INVALID_URI                 CELL_ERROR_CAST(0x80710007)

/* ERR: CELL_HTTP_MAKE_ERROR(0x0008) */
#define CELL_HTTP_ERROR_INVALID_HEADER              CELL_ERROR_CAST(0x80710008)

/* ERR: CELL_HTTP_MAKE_ERROR(0x0009) */
#define CELL_HTTP_ERROR_BAD_METHOD                  CELL_ERROR_CAST(0x80710009)

/*E Bad Client ID */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0010) */
#define CELL_HTTP_ERROR_BAD_CLIENT                  CELL_ERROR_CAST(0x80710010)

/*E Bad Transaction ID */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0011) */
#define CELL_HTTP_ERROR_BAD_TRANS                   CELL_ERROR_CAST(0x80710011)

/*E no connection available */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0012) */
#define CELL_HTTP_ERROR_NO_CONNECTION               CELL_ERROR_CAST(0x80710012)

/*E no request has been sent yet */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0013) */
#define CELL_HTTP_ERROR_NO_REQUEST_SENT             CELL_ERROR_CAST(0x80710013)

/*E request has already been built */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0014) */
#define CELL_HTTP_ERROR_ALREADY_BUILT               CELL_ERROR_CAST(0x80710014)

/*E request has already been sent */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0015) */
#define CELL_HTTP_ERROR_ALREADY_SENT                CELL_ERROR_CAST(0x80710015)

/*E that header doesn't exist */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0016) */
#define CELL_HTTP_ERROR_NO_HEADER                   CELL_ERROR_CAST(0x80710016)

/*E no content-length was defined */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0017) */
#define CELL_HTTP_ERROR_NO_CONTENT_LENGTH           CELL_ERROR_CAST(0x80710017)

/*E exceeded max auto-redirects(default:5) */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0018) */
#define CELL_HTTP_ERROR_TOO_MANY_REDIRECTS          CELL_ERROR_CAST(0x80710018)

/*E exceeded max auto-authentication tries(default:5) */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0019) */
#define CELL_HTTP_ERROR_TOO_MANY_AUTHS              CELL_ERROR_CAST(0x80710019)

/*E no connection for the transaction is available, try again later? */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0020) */
#define CELL_HTTP_ERROR_TRANS_NO_CONNECTION         CELL_ERROR_CAST(0x80710020)

/*E tried to callback to the application, but failed */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0021) */
#define CELL_HTTP_ERROR_CB_FAILED                   CELL_ERROR_CAST(0x80710021)

/*E the connection has no transactions in the pipeline --internal error */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0022) */
#define CELL_HTTP_ERROR_NOT_PIPED                   CELL_ERROR_CAST(0x80710022)

/*E there is another request next in the pipeline */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0023) */
#define CELL_HTTP_ERROR_OUT_OF_ORDER_PIPE           CELL_ERROR_CAST(0x80710023)

/*E this transaction has been aborted */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0024) */
#define CELL_HTTP_ERROR_TRANS_ABORTED               CELL_ERROR_CAST(0x80710024)

/*E the pipeline this transaction was using has been aborted,
 *  and thus broke the pipeline
 */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0025) */
#define CELL_HTTP_ERROR_BROKEN_PIPELINE             CELL_ERROR_CAST(0x80710025)

/*E the request made is for an unavailable service */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0026) */
#define CELL_HTTP_ERROR_UNAVAILABLE                 CELL_ERROR_CAST(0x80710026)

/*E an invalid value was found in processing */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0027) */
#define CELL_HTTP_ERROR_INVALID_VALUE               CELL_ERROR_CAST(0x80710027)

/*E the cookie is not valid */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0041) */
#define CELL_HTTP_ERROR_COOKIE_NOT_FOUND            CELL_ERROR_CAST(0x80710041)

/*E the cookie contains an invalid domain */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0042) */
#define CELL_HTTP_ERROR_COOKIE_INVALID_DOMAIN       CELL_ERROR_CAST(0x80710042)


/*** internal errors (0x005#) ***/
/*E catchall for unexpected errors */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0051) */
#define CELL_HTTP_ERROR_UNKNOWN                     CELL_ERROR_CAST(0x80710051)

/*E Internal failure */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0052) */
#define CELL_HTTP_ERROR_INTERNAL                    CELL_ERROR_CAST(0x80710052)

/*E not a removable connection -- not free or non-existant */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0053) */
#define CELL_HTTP_ERROR_NONREMOVABLE                CELL_ERROR_CAST(0x80710053)

/*E Bad Connection */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0054) */
#define CELL_HTTP_ERROR_BAD_CONN                    CELL_ERROR_CAST(0x80710054)

/*E Bad Connection Manager */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0055) */
#define CELL_HTTP_ERROR_BAD_MAN                     CELL_ERROR_CAST(0x80710055)

/*E no connection pool */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0056) */
#define CELL_HTTP_ERROR_NO_POOL                     CELL_ERROR_CAST(0x80710056)

/*E no request (structure), not been created? */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0057) */
#define CELL_HTTP_ERROR_NO_REQUEST                  CELL_ERROR_CAST(0x80710057)

/*E internal failure */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0058) */
#define CELL_HTTP_ERROR_LOCK_FAILED                 CELL_ERROR_CAST(0x80710058)

/* Network Errors (0x009#) */

/*E received EOF from the socket */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0091) */
#define CELL_HTTP_ERROR_NET_FIN                     CELL_ERROR_CAST(0x80710091)

/*E timed out while connecting */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0092) */
#define CELL_HTTP_ERROR_NET_CONNECT_TIMEOUT         CELL_ERROR_CAST(0x80710092)

/*E timed out while polling */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0092) */
#define CELL_HTTP_ERROR_NET_SELECT_TIMEOUT          CELL_ERROR_CAST(0x80710093)

/*E For these Network related errors, the last two digits
 *  will further describe the network error, which comes from the
 *  network socket API's errno or h_errno, in the case of the resolver.
 */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0100) */
#define CELL_HTTP_ERROR_NET_RESOLVER                CELL_ERROR_CAST(0x80710100)

/* ERR: CELL_HTTP_MAKE_ERROR(0x0200) */
#define CELL_HTTP_ERROR_NET_ABORT                   CELL_ERROR_CAST(0x80710200)

/* ERR: CELL_HTTP_MAKE_ERROR(0x0300) */
#define CELL_HTTP_ERROR_NET_OPTION                  CELL_ERROR_CAST(0x80710300)

/* ERR: CELL_HTTP_MAKE_ERROR(0x0400) */
#define CELL_HTTP_ERROR_NET_SOCKET                  CELL_ERROR_CAST(0x80710400)

/* ERR: CELL_HTTP_MAKE_ERROR(0x0500) */
#define CELL_HTTP_ERROR_NET_CONNECT                 CELL_ERROR_CAST(0x80710500)

/* ERR: CELL_HTTP_MAKE_ERROR(0x0600) */
#define CELL_HTTP_ERROR_NET_SEND                    CELL_ERROR_CAST(0x80710600)

/* ERR: CELL_HTTP_MAKE_ERROR(0x0700) */
#define CELL_HTTP_ERROR_NET_RECV                    CELL_ERROR_CAST(0x80710700)

/* ERR: CELL_HTTP_MAKE_ERROR(0x0800) */
#define CELL_HTTP_ERROR_NET_SELECT                  CELL_ERROR_CAST(0x80710800)


/*
 * HTTPS Error codes
 */
/*E cannot load the certificate */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0a01) */
#define CELL_HTTPS_ERROR_CERTIFICATE_LOAD           CELL_ERROR_CAST(0x80710a01)

/*E ssl memory call failed */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0a02) */
#define CELL_HTTPS_ERROR_BAD_MEMORY                 CELL_ERROR_CAST(0x80710a02)

/*E failed to create ssl context */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0a03) */
#define CELL_HTTPS_ERROR_CONTEXT_CREATION           CELL_ERROR_CAST(0x80710a03)

/*E failed to create the ssl connection */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0a04) */
#define CELL_HTTPS_ERROR_CONNECTION_CREATION        CELL_ERROR_CAST(0x80710a04)

/*E failed to associate the socket with ssl connection */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0a05) */
#define CELL_HTTPS_ERROR_SOCKET_ASSOCIATION         CELL_ERROR_CAST(0x80710a05)

/*E SSL Connect Handshake error */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0a06) */
#define CELL_HTTPS_ERROR_HANDSHAKE                  CELL_ERROR_CAST(0x80710a06)

/*E failed to retrieve SSL certificate */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0a07) */
#define CELL_HTTPS_ERROR_LOOKUP_CERTIFICATE         CELL_ERROR_CAST(0x80710a07)

/*E libssl is not available (has not been initialized?) */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0a08) */
#define CELL_HTTPS_ERROR_NO_SSL                     CELL_ERROR_CAST(0x80710a08)

/*E cannot load the private key */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0a09) */
#define CELL_HTTPS_ERROR_KEY_LOAD                   CELL_ERROR_CAST(0x80710a09)

/*E the private key and client certificate do not match */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0a0b) */
#define CELL_HTTPS_ERROR_CERT_KEY_MISMATCH          CELL_ERROR_CAST(0x80710a0a)

/*E the private key needs client certificate */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0a0b) */
#define CELL_HTTPS_ERROR_KEY_NEEDS_CERT             CELL_ERROR_CAST(0x80710a0b)

/*E the client certificate needs private key */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0a0c) */
#define CELL_HTTPS_ERROR_CERT_NEEDS_KEY             CELL_ERROR_CAST(0x80710a0c)


/*E Network failed on SSL Connect
 *  error is reported as the other network errors in libhttp,
 *  using CELL_HTTP_NET_ERROR() macro, refer to error.h
 */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0b00) */
#define CELL_HTTPS_ERROR_NET_SSL_CONNECT            CELL_ERROR_CAST(0x80710b00)

/*E Network failed on SSL Send
 *  error is reported as the other network errors in libhttp,
 *  using CELL_HTTP_NET_ERROR() macro, refer to error.h
 */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0b00) */
#define CELL_HTTPS_ERROR_NET_SSL_SEND               CELL_ERROR_CAST(0x80710c00)

/*E Network failed on SSL Receive
 *  error is reported as the other network errors in libhttp,
 *  using CELL_HTTP_NET_ERROR() macro, refer to error.h
 */
/* ERR: CELL_HTTP_MAKE_ERROR(0x0b00) */
#define CELL_HTTPS_ERROR_NET_SSL_RECV               CELL_ERROR_CAST(0x80710d00)


/*
 * libhttp_util error codes (0x10##)
 */
/* ERR: CELL_HTTP_MAKE_ERROR(0x1001) */
#define CELL_HTTP_UTIL_ERROR_NO_MEMORY              CELL_ERROR_CAST(0x80711001)

/* ERR: CELL_HTTP_MAKE_ERROR(0x1002) */
#define CELL_HTTP_UTIL_ERROR_NO_BUFFER              CELL_ERROR_CAST(0x80711002)

/* ERR: CELL_HTTP_MAKE_ERROR(0x1003) */
#define CELL_HTTP_UTIL_ERROR_NO_STRING              CELL_ERROR_CAST(0x80711003)

/* ERR: CELL_HTTP_MAKE_ERROR(0x1004) */
#define CELL_HTTP_UTIL_ERROR_INSUFFICIENT           CELL_ERROR_CAST(0x80711004)

/* ERR: CELL_HTTP_MAKE_ERROR(0x1005) */
#define CELL_HTTP_UTIL_ERROR_INVALID_URI            CELL_ERROR_CAST(0x80711005)

/* ERR: CELL_HTTP_MAKE_ERROR(0x1006) */
#define CELL_HTTP_UTIL_ERROR_INVALID_HEADER         CELL_ERROR_CAST(0x80711006)

/* ERR: CELL_HTTP_MAKE_ERROR(0x1007) */
#define CELL_HTTP_UTIL_ERROR_INVALID_REQUEST        CELL_ERROR_CAST(0x80711007)

/* ERR: CELL_HTTP_MAKE_ERROR(0x1008) */
#define CELL_HTTP_UTIL_ERROR_INVALID_RESPONSE       CELL_ERROR_CAST(0x80711008)

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _CELL_HTTP_ERROR_H */
