/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006 
* Copyright (C) 2006 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/
/* mstream.h Multistream header */

#ifndef _MS_HEADER_H_
#define _MS_HEADER_H_

//Cell only defines
#ifdef __CELLOS_LV2__
#include <cell/audio.h>
#include <cell/spurs/types.h>
#endif

/**********************************************************************************************************
D E F I N E S
**********************************************************************************************************/

#define CELL_MS_VERSION		(1.00)

#define CELL_MS_MAX_STREAMS (512)
#define CELL_MS_MAX_CHANNEL (7)

#define CELL_MS_EQ_CUBIC		(2)
#define CELL_MS_EQ_CURVE		(1)
#define CELL_MS_EQ_LINE			(0)
#define CELL_MS_EQ_MAX_BANDS	(512)

#define CELL_MS_CALLBACK_MOREDATA		(1)
#define CELL_MS_CALLBACK_CLOSESTREAM	(2)
#define CELL_MS_CALLBACK_FINISHEDDRY	(3)
#define CELL_MS_CALLBACK_FINISHSTREAM	(4)

#define CELL_MS_BUS_FLAG	(0x80000)
#define CELL_MS_MASTER_BUS  ( CELL_MS_BUS_FLAG | 0 )
#define CELL_MS_SUBBUS_1    ( CELL_MS_BUS_FLAG | 1 )
#define CELL_MS_SUBBUS_2    ( CELL_MS_BUS_FLAG | 2 )
#define CELL_MS_SUBBUS_3    ( CELL_MS_BUS_FLAG | 3 )
#define CELL_MS_SUBBUS_4    ( CELL_MS_BUS_FLAG | 4 )
#define CELL_MS_SUBBUS_5    ( CELL_MS_BUS_FLAG | 5 )
#define CELL_MS_SUBBUS_6    ( CELL_MS_BUS_FLAG | 6 )
#define CELL_MS_SUBBUS_7    ( CELL_MS_BUS_FLAG | 7 )
#define CELL_MS_SUBBUS_8    ( CELL_MS_BUS_FLAG | 8 )
#define CELL_MS_SUBBUS_9    ( CELL_MS_BUS_FLAG | 9 )
#define CELL_MS_SUBBUS_10   ( CELL_MS_BUS_FLAG | 10 )
#define CELL_MS_SUBBUS_11   ( CELL_MS_BUS_FLAG | 11 )
#define CELL_MS_SUBBUS_12   ( CELL_MS_BUS_FLAG | 12 )
#define CELL_MS_SUBBUS_13   ( CELL_MS_BUS_FLAG | 13 )
#define CELL_MS_SUBBUS_14   ( CELL_MS_BUS_FLAG | 14 )
#define CELL_MS_SUBBUS_15   ( CELL_MS_BUS_FLAG | 15 )
#define CELL_MS_SUBBUS_16   ( CELL_MS_BUS_FLAG | 16 )
#define CELL_MS_SUBBUS_17   ( CELL_MS_BUS_FLAG | 17 )
#define CELL_MS_SUBBUS_18   ( CELL_MS_BUS_FLAG | 18 )
#define CELL_MS_SUBBUS_19   ( CELL_MS_BUS_FLAG | 19 )
#define CELL_MS_SUBBUS_20   ( CELL_MS_BUS_FLAG | 20 )
#define CELL_MS_SUBBUS_21   ( CELL_MS_BUS_FLAG | 21 )
#define CELL_MS_SUBBUS_22   ( CELL_MS_BUS_FLAG | 22 )
#define CELL_MS_SUBBUS_23   ( CELL_MS_BUS_FLAG | 23 )
#define CELL_MS_SUBBUS_24   ( CELL_MS_BUS_FLAG | 24 )
#define CELL_MS_SUBBUS_25   ( CELL_MS_BUS_FLAG | 25 )
#define CELL_MS_SUBBUS_26   ( CELL_MS_BUS_FLAG | 26 )
#define CELL_MS_SUBBUS_27   ( CELL_MS_BUS_FLAG | 27 )
#define CELL_MS_SUBBUS_28   ( CELL_MS_BUS_FLAG | 28 )
#define CELL_MS_SUBBUS_29   ( CELL_MS_BUS_FLAG | 29 )
#define CELL_MS_SUBBUS_30   ( CELL_MS_BUS_FLAG | 30 )
#define CELL_MS_SUBBUS_31   ( CELL_MS_BUS_FLAG | 31 )

#define CELL_MS_STREAM_NOFLAGS		(0)
#define CELL_MS_STREAM_AUTOCLOSE	(1)

#define CELL_MS_NOFLAGS					(0)
#define CELL_MS_DEBUG_FLAG				(1)
#define CELL_MS_ROUTABLE_STREAMS_FLAG	(2)
#define CELL_MS_EXTERNAL_BUFFERS		(4)

#define CELL_MS_ALLOC_DSPHANDLE	(-1)
#define CELL_MS_DSPOFF			(-1)

#define CELL_MS_16BIT_BIG		(0)
#define CELL_MS_16BIT_LITTLE	(1)
#define CELL_MS_32BIT_FLOAT		(2)
#define CELL_MS_ADPCM			(3)
//#define CELL_MS_ATRAC			(4)

#define CELL_MS_STOP	(0)
#define CELL_MS_KEYOFF	(-1)

#define CELL_MS_STREAM_OFF	(0)
#define CELL_MS_STREAM_ON	(1)

#define CELL_MS_ENVELOPE_NO_LOOP	(255)
#define CELL_MS_ENVELOPE_LIN		(0)
#define CELL_MS_ENVELOPE_EXP		(1)

#define CELL_MS_SURROUND_GLOBAL			(0x80000)
#define CELL_MS_SURROUND_ACTIVE_STREAM	(-1)
#define CELL_MS_SURROUND_ACTIVE_OFF		(-2)

#define CELL_MS_SURROUND_NONE						(0)
#define CELL_MS_SURROUND_FALSE						(0)
#define CELL_MS_SURROUND_TRUE						(1)
#define CELL_MS_SURROUND_SOURCE_RELATIVE			(0x202)
#define CELL_MS_SURROUND_CONE_INNER_ANGLE			(0x1001)
#define CELL_MS_SURROUND_CONE_OUTER_ANGLE			(0X1002)
#define CELL_MS_SURROUND_PITCH						(0X1003)
#define CELL_MS_SURROUND_POSITION					(0X1004)
#define CELL_MS_SURROUND_DIRECTION					(0X1005)
#define CELL_MS_SURROUND_VELOCITY					(0X1006)
#define CELL_MS_SURROUND_GAIN						(0X100A)
#define CELL_MS_SURROUND_MIN_GAIN					(0X100D)
#define CELL_MS_SURROUND_MAX_GAIN					(0X100E)
#define CELL_MS_SURROUND_ORIENTATION				(0X100F)
#define CELL_MS_SURROUND_REFERENCE_DISTANCE			(0X1020)
#define CELL_MS_SURROUND_ROLLOFF_FACTOR				(0X1021)
#define CELL_MS_SURROUND_CONE_OUTER_GAIN			(0X1022)
#define CELL_MS_SURROUND_MAX_DISTANCE				(0X1023)
#define CELL_MS_SURROUND_DOPPLER_FACTOR				(0XC000)
#define CELL_MS_SURROUND_DOPPLER_VELOCITY			(0XC001)
#define CELL_MS_SURROUND_SPEED_OF_SOUND				(0XC003)
#define CELL_MS_SURROUND_DISTANCE_MODEL				(0XD000)
#define CELL_MS_SURROUND_INVERSE_DISTANCE			(0XD001)
#define CELL_MS_SURROUND_INVERSE_DISTANCE_CLAMPED	(0XD002)
#define CELL_MS_SURROUND_LINEAR_DISTANCE			(0XD003)
#define CELL_MS_SURROUND_LINEAR_DISTANCE_CLAMPED	(0XD004)
#define CELL_MS_SURROUND_EXPONENT_DISTANCE			(0XD005)
#define CELL_MS_SURROUND_EXPONENT_DISTANCE_CLAMPED	(0XD006)

#define CELL_MSFX_VOCODER_BYPASS_OFF	(0)
#define CELL_MSFX_VOCODER_BYPASS_ON		(1)
#define CELL_MSFX_VOCODER_BANDS			(64)
#define CELL_MSFX_IR_BUFFER_SIZE		(4096)

#define CELL_MS_DSPALLSLOTS			(-1)

#define CELL_MS_ERROR 8000000
#define CELL_MS_ERROR_SYSPAUSED (CELL_MS_ERROR + 1)
#define CELL_MS_ERROR_INVAL (CELL_MS_ERROR + 2)
#define CELL_MS_ERROR_WRONGSTATE (CELL_MS_ERROR + 3)
#define CELL_MS_ERROR_RESOURCEUNAVAIL (CELL_MS_ERROR + 4)
#define CELL_MS_ERROR_CIRCULARDEPEND (CELL_MS_ERROR + 5)
#define CELL_MS_ERROR_BUSMISMATCH (CELL_MS_ERROR + 6)
#define CELL_MS_ERROR_INVALIDELF (CELL_MS_ERROR + 7)
#define CELL_MS_ERROR_FILEACCESS (CELL_MS_ERROR + 8)
#define CELL_MS_ERROR_INVALIDENV (CELL_MS_ERROR + 9)
#define CELL_MS_ERROR_OUTOFRANGE (CELL_MS_ERROR + 10)
#define CELL_MS_ERROR_BADMODE (CELL_MS_ERROR + 11)
#define CELL_MS_ERROR_NOFREESTREAMS (CELL_MS_ERROR + 12)
#define CELL_MS_ERROR_SURROUNDNOTINIT (CELL_MS_ERROR + 13)
#define CELL_MS_ERROR_INVALID_CHANNEL (CELL_MS_ERROR + 14)
#define CELL_MS_ERROR_INVALID_TYPE (CELL_MS_ERROR + 15)

#define CELL_MS_PRIORITY_OFF -1
#define CELL_MS_PRIORITY_UNLIMITED CELL_MS_MAX_STREAMS
#define CELL_MS_PRIORITY_MAX_THRESHOLD 10000000

/**********************************************************************************************************
E N U M S
**********************************************************************************************************/

typedef enum CELL_MS_DOMAINS {
	CELL_MS_TIMEDOMAIN = 0,
	CELL_MS_FREQDOMAIN = 1
} CELL_MS_DOMAINS;

typedef enum CELL_MS_DSPMASKS {
	CELL_MS_INMASK = 0,
	CELL_MS_OUTMASK = 1
} CELL_MS_DSPMASKS;

typedef enum CELL_MS_DSPSLOTS {
	CELL_MS_DSP_SLOT_0 = 0,
	CELL_MS_DSP_SLOT_1 = 1,
	CELL_MS_DSP_SLOT_2 = 2,
	CELL_MS_DSP_SLOT_3 = 3,
	CELL_MS_DSP_SLOT_4 = 4,
	CELL_MS_DSP_SLOT_5 = 5,
	CELL_MS_DSP_SLOT_6 = 6,
	CELL_MS_DSP_SLOT_7 = 7
} CELL_MS_DSPSLOTS;

typedef enum CELL_MS_ROUTES {
	CELL_MS_ROUTE_OFF = 0,
	CELL_MS_ROUTE_ON = 1,
	CELL_MS_ROUTE_ALL_OFF = 2,
	CELL_MS_ROUTE_VOLUME_ONLY = 3
} CELL_MS_ROUTES;

typedef enum CELL_MS_CHANNELS {
	CELL_MS_WET_STREAM = 0,
	CELL_MS_CHANNEL_0 = 0,
	CELL_MS_CHANNEL_1 = 1,
	CELL_MS_CHANNEL_2 = 2,
	CELL_MS_CHANNEL_3 = 3,
	CELL_MS_CHANNEL_4 = 4,
	CELL_MS_CHANNEL_5 = 5,
	CELL_MS_CHANNEL_6 = 6,
	CELL_MS_CHANNEL_7 = 7
} CELL_MS_CHANNELS;

typedef enum CELL_MS_SPEAKERS {
	CELL_MS_SPEAKER_FL = 0,
	CELL_MS_SPEAKER_FR = 1,
	CELL_MS_SPEAKER_FC = 2,
	CELL_MS_SPEAKER_ML = 3,
	CELL_MS_SPEAKER_MR = 4,
	CELL_MS_SPEAKER_RL = 5,
	CELL_MS_SPEAKER_RR = 6,
	CELL_MS_SPEAKER_LFE = 7
} CELL_MS_SPEAKERS;

typedef enum CELL_MS_EQSTATE {
	CELL_MS_EQDISABLED = 0,
	CELL_MS_EQENABLED = 1
} CELL_MS_EQSTATE;

typedef enum CELL_MS_PAUSE {
	CELL_MS_NOTPAUSED = 0,
	CELL_MS_PAUSED = 1,
} CELL_MS_PAUSE;

typedef enum CELL_MS_PATH {
	CELL_MS_DRY,
	CELL_MS_WET,
	CELL_MS_WET_AND_DRY
} CELL_MS_PATH;

typedef enum CELL_MS_BYPASS {
	CELL_MS_NOTBYPASSED = 0,
	CELL_MS_BYPASSED = 1
} CELL_MS_BYPASS;

typedef enum CELL_MS_ENVSTATE {
	CELL_MS_ENVELOPE_OFF = 0,
	CELL_MS_ENVELOPE_ON = 1
} CELL_MS_ENVSTATE;


typedef enum CELL_MS_PRIORITY_BANKS {
	CELL_MS_PRIORITY_BANK_0 = 0,
	CELL_MS_PRIORITY_BANK_1 = 1,
	CELL_MS_PRIORITY_BANK_2 = 2,
	CELL_MS_PRIORITY_BANK_3 = 3,
	CELL_MS_PRIORITY_BANK_4 = 4,
	CELL_MS_PRIORITY_BANK_5 = 5,
	CELL_MS_PRIORITY_BANK_6 = 6,
	CELL_MS_PRIORITY_BANK_7 = 7,
	CELL_MS_PRIORITY_BANK_8 = 8,
	CELL_MS_PRIORITY_BANK_9 = 9,
	CELL_MS_PRIORITY_BANK_10 = 10,
	CELL_MS_PRIORITY_BANK_11 = 11,
	CELL_MS_PRIORITY_BANK_12 = 12,
	CELL_MS_PRIORITY_BANK_13 = 13,
	CELL_MS_PRIORITY_BANK_14 = 14,
	CELL_MS_PRIORITY_BANK_15 = 15,
	CELL_MS_PRIORITY_BANK_16 = 16,
	CELL_MS_PRIORITY_BANK_17 = 17,
	CELL_MS_PRIORITY_BANK_18 = 18,
	CELL_MS_PRIORITY_BANK_19 = 19,
	CELL_MS_PRIORITY_BANK_20 = 20,
	CELL_MS_PRIORITY_BANK_21 = 21,
	CELL_MS_PRIORITY_BANK_22 = 22,
	CELL_MS_PRIORITY_BANK_23 = 23,
	CELL_MS_PRIORITY_BANK_24 = 24,
	CELL_MS_PRIORITY_BANK_25 = 25,
	CELL_MS_PRIORITY_BANK_26 = 26,
	CELL_MS_PRIORITY_BANK_27 = 27,
	CELL_MS_PRIORITY_BANK_28 = 28,
	CELL_MS_PRIORITY_BANK_29 = 29,
	CELL_MS_PRIORITY_BANK_30 = 30,
	CELL_MS_PRIORITY_BANK_31 = 31
} CELL_MS_PRIORITY_BANKS;

/**********************************************************************************************************
T Y P E S
**********************************************************************************************************/

typedef struct CellMSSystemInformation
{
	int totalCycleCount;				//Total number of SPU cycles used in last pass
	int miscCycleCount;					//Total number of Multistream overhead cycles used in last pass
	int totalNumberOfStreamsProcessed;	//Total number of streams processed in last pass
	int totalMemoryBandwidth;			//Total system bandwidth (in + out, system + DSP) used in last pass
	int MemoryBandwidthIn;				//Total bandwidth (system in only) used in last pass
	int MemoryBandwidthOut;				//Total bandwidth (system out only) used in last pass
	int DSPBandwidthIn;					//Total bandwidth (DSP in only) used in last pass 
	int DSPBandwidthOut;				//Total bandwidth (DSP out only) used in last pass
} CellMSSystemInformation;

typedef struct CellMSDebugInformation
{
	CellMSSystemInformation *systemInfo;		//Pointer to System Information structure
	int	*subStreamCnt;					//Pointer to N (defined by user in cellMSSystemInit as maxSubs) counts, each representing how many streams were playing on the Nth subbus
	int *streamCycleCount;				//Pointer to N (defined by user in cellMSSystemInit as maxStreams) counts, each representing the cycle count of the Nth stream
	int *streamDSPCycleCount;			//Pointer to N (defined by the user in cellMSSystemInit as maxStreams) counts, each representing the cycle count of the DSP processing on the Nth stream
	int *subCycleCount;					//Pointer to N (defined by the user in cellMSSystemInit as maxSubs) counts, each representing the cycle count on the Nth subbus
	int *subDSPCycleCount;				//Pointer to N (defined by the user in cellMSSystemInit as maxSubs) counts, each representing the cycle count of the DSP processing on the Nth subbus
} CellMSDebugInformation;

typedef struct CellComplexNum
{
	float r;
	float i;
} CellComplexNum;

 typedef struct CellMSSection1
{
	unsigned char		Header[4];
	unsigned int		DataSize;
	unsigned char 		ID[8];
	unsigned short		IDValue;
	unsigned char		Version[4];
	unsigned char		Date[6];
	unsigned int		InfoSize;
	unsigned char		SVersion[4];
	unsigned int		InitData[8];
} CellMSSection1;

typedef struct CellMSEnvPoint
{
	unsigned int		X;					// range from 0 - a lot (in 1000'ths of a second)
	float				Y;					// range from 0 - 1
} CellMSEnvPoint;

typedef struct CellMSEnvelope
{
	CellMSEnvPoint		Point[33];			// 33 points required (32 for user envelope. first point for 0,0 initialisation)
	unsigned int		ReleaseRate;		// In msecs. Will fade current envelope to 0 over time if KeyOFF is triggered.
	unsigned int		NumPoints;			// Number of points in envelope
	unsigned int		LoopStart;			// Point number to loop to when reached end of list. MS_ENVELOPE_NO_LOOP = Once off.
	unsigned int		Type;				// MS_ENVELOPE_LIN (linear) or MS_ENVELOPE_EXP (exponential)
} CellMSEnvelope;

typedef struct CellEQMorphSection
{
	float startVals[512];
	float endVals[512];
} CellEQMorphSection;

typedef struct CellEQPoint
{
	unsigned char Tag[8];
	float x;
	float y;
} CellEQPoint;

typedef struct CellEQSection
{
	unsigned int curveSwitch;
	unsigned int nPoints;
	CellEQPoint* xy;
} CellEQSection;

typedef struct CellMSDSP
{
	int memoryUsed;
	int memoryAvail;
	int handle;
} CellMSDSP;

typedef struct CellMSInfo
{
	unsigned char		SubBusGroup;	  	// Master volume bus (0-31)
	void				*FirstBuffer;		// Address of PCM data
	unsigned int		FirstBufferSize;	// Size of buffer allocated
	void				*SecondBuffer;		// Address of callback routine
	unsigned int		SecondBufferSize;	// Address of callback data
	int					Pitch;				// Pitch of the stream
	int					numChannels;		// Number of channels contained within
	int					initialOffset;		// Offset for play stream, so you can have sample accurate playing
	int					inputType;			// Type of input data (16 bit, 32 bit, ADPCM etc)
	int					flags;				// Special flags (Such as CELL_MS_STREAM_AUTOCLOSE)
} CellMSInfo;


typedef struct CellMSFXVocoderInfo		//CELL_MSFX_VOCODER_INFO
{
	float	FFTBuffer[512*2];		// Carrier signal
	float	Band[CELL_MSFX_VOCODER_BANDS];
	long long Bypass;
	float	CarrierMix;
} CellMSFXVocoderInfo;					//CELL_MSFX_VOCODER_INFO;

typedef struct CellMSFXCompressorInfo		//CELL_MSFX_COMPRESSOR_INFO
{
	float	AnalysisPower;	// This is the value which the compressor outputs
	int	    firstBand;
	int	    lastBand;
	float	ratio;
	float	threshold;
	float	attack;
	float	release;
	float	makeupGain;
	float   CompressorCur; // Used by the compressor algorithm
	float	multBy;
	int		pad[2];
} CellMSFXCompressorInfo;				//CELL_MSFX_COMPRESSOR_INFO;

typedef enum CELL_MSFX_FILTERMODE
{
	CELL_MSFX_FILTERMODE_OFF = 0,
	CELL_MSFX_FILTERMODE_LOWPASS_RESONANT,             // 2-pole low pass resonant filter, at Q = 0.7 no resonant peak, at Q = 1.0 cutoff frequency = 0 dB (start of cutoff)
	CELL_MSFX_FILTERMODE_HIGHPASS_RESONANT,            // as above but allows high frequencies to pass
	CELL_MSFX_FILTERMODE_BANDPASS_PEAK,                // band pass with peaking centre frequency, gain controls dB gain at top of peak
	CELL_MSFX_FILTERMODE_BANDPASS_ZERO,                // band pass with peak always at zero dB, Q controls bandwidth
	CELL_MSFX_FILTERMODE_NOTCH,                        // removes frequencies around cutoff, Q controls the bandwidth
	CELL_MSFX_FILTERMODE_PEAK,                         // a parametric EQ, gain controls +/- dB at cutoff frequency, Q controls bandwidth
	CELL_MSFX_FILTERMODE_HIGHSHELF,                    // high shelving cut/boost. Gain controls dB gain at and above cutoff
	CELL_MSFX_FILTERMODE_LOWSHELF,                     // low shelving cut/boost. Gain controls dB gain at and below cutoff
	CELL_MSFX_FILTERMODE_LOWPASS_ONEPOLE,              // 1-pole low pass.  -3dB at cutoff and -6dB per octave above cutoff
	CELL_MSFX_FILTERMODE_HIGHPASS_ONEPOLE,             // 1-pole high pass. -3dB at cutoff and -6dB per octave below cutoff
	CELL_MSFX_FILTERMODE_ALLPASS,                      // -90/+90 degree phase shift, cutoff frequency passes at 0 phase shift
	CELL_MSFX_FILTERMODE_LOWPASS_RESONANT_NORMALIZED,  // a 2-pole resonant filter mode, the gain below the cutoff reduces at higher resonant Q values
} CELL_MSFX_FILTERMODE;

typedef struct CellMSFXFilter // Used in file save
{
    CELL_MSFX_FILTERMODE FilterMode;
    float                fFrequency;
    float                fResonance;
    float                fGain;
} CellMSFXFilter;

typedef struct CellMSFXDistortion	//CELL_MSFX_DISTORTION
{
	float	fA;
	float	fB;
	float	fLimit;
	float	fGate;
	float	fWetGain;
	float	fDryGain;
} CellMSFXDistortion;				//CELL_MSFX_DISTORTION;

typedef struct CellMSFXReverbParams
{
	float fWetVolume;   // linear volume scaling for wet output ( i.e. 1 == original volume, 0.5 == half volume )
	float fDryVolume;   // linear volume scaling for dry output

	float fPreDelayMs;  // millisecond pre-delay (0->148 milliseconds)

	float fLowPassHz;   // low pass cutoff frequency in Hz (-6dB)
	float fHighPassHz;  // high pass cutoff frequency in Hz (-6dB)

	float fRoomSize;    // 0->1, 0 == tiny, 1 == massive ( affects the maximum decay time )
	float fDamping;     // 0->1, 0 == highly reflective, 1 == highly absorptive room ( higher reduces relative decay times of high freqencies )
	float fDiffusion;   // 0->1, 0 == no late absorbsion/defraction of sound, 1 == greater absorbtion of higher frequencies over time

	float fEarlyLate;   // 0->1, 0 == closer to listener (early reflections only), 1 == further away (late reflections only)

	float fLeftRight;   // 0->1 applies stereo dispersion to early and late reflections 0 == fully left, 1 == fully right
	float fFrontBack;   // 0->1 applies changes to early reflections to model distance from source to listener

} CellMSFXReverbParams;

typedef void (*CELL_MS_CALLBACK_FUNC)(int streamNumber, void *userData, int callbackType, void *readBuffer, int readSize);

/**********************************************************************************************************
P R O T O T Y P E S
**********************************************************************************************************/

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" {
#endif
/**********************************************************************************************************
S Y S T E M
**********************************************************************************************************/
int cellMSSystemGetNeededMemorySize(const int maxStreams, const int maxSubs, const int flag);
int cellMSSystemInitSPUThread(const void *systemMemory, const int maxChannels, const int maxSubs, const char *multistreamSPULoc, const int priority, const int flags);
void cellMSSystemSetGlobalCallbackFunc(const CELL_MS_CALLBACK_FUNC func);
void cellMSSystemSetGlobalCallbackData(void *data);
void cellMSSystemSetPause (const CELL_MS_PAUSE pause);
CELL_MS_PAUSE cellMSSystemGetPause(void);
void *cellMSSystemClose(void);
float *	cellMSSystemSignalSPU(void); 
char *cellMSSystemGetCallbacksNeeded(void);
void cellMSSystemFreeCallbacksNeeded(void);
void cellMSSystemGenerateCallbacks(void);
int cellMSSystemGetDebugPointer(CellMSDebugInformation *dbgInfo);
void cellMSSystemGetInfo(int *freeStreams, int *usedStreams);
int cellMSSystemGetLastError(void);

#ifdef __CELLOS_LV2__
int cellMSSystemConfigureLibAudio(CellAudioPortParam *audioParam, CellAudioPortConfig *portConfig);
int cellMSSystemInitSPURS(const void *systemMemory, const int maxChannels, const int maxSubs, const void *multistream_SPUR_ELF_Data, const CellSpurs *spurs, const int flags);
#endif

/**********************************************************************************************************
S T R E A M
**********************************************************************************************************/
void cellMSStreamSetFirstRead(const int streamNo, const void *Addr, const int size);
void cellMSStreamSetSecondRead(const int streamNo, const void *Addr, const int size); 
void cellMSStreamSetCallbackData(const int streamNo, const void *Data);
void cellMSStreamSetCallbackFunc(const int streamNo, const CELL_MS_CALLBACK_FUNC Func);
int cellMSStreamSetSub(const int streamNo, const int busNo);
void cellMSStreamSetPitch(const int streamNo, const int pitch);
void cellMSStreamSetEnvBypass(const int streamNo, const CELL_MS_BYPASS Switch);
int cellMSStreamSetRouting(const int streamNo, const int busNo, float subGain);
void *cellMSStreamGetCallbackData(const int streamNo); 
void *cellMSStreamGetCallbackFunc(const int streamNo);
int cellMSStreamGetStatus(const int streamNo);
float cellMSStreamGetRouting(const int streamNo, const int busNo);
int cellMSStreamGetRoutingMask(const int streamNo);
void cellMSStreamClose(const int streamNo);
int cellMSStreamOpen(void);
void cellMSStreamPlay(const int streamNo);
int cellMSStreamSetInfo(const int StreamNo, const CellMSInfo *data);
int cellMSStreamGetInfo(const int streamNo, CellMSInfo* data);
CELL_MS_BYPASS cellMSStreamGetEnvBypass(const int streamNo);
void cellMSStreamGetCurrentPlayPos(const int streamNo, int *currentOffset, int *bufferAddr);
float cellMSStreamGetCurrentEnv(const int streamNo);
int cellMSStreamSetPriorityLevel(int ch, float priorityLevel);
int cellMSStreamSetPriorityBank(int ch, const CELL_MS_PRIORITY_BANKS);
int cellMSStreamSetPriorityBankThreshold(const CELL_MS_PRIORITY_BANKS priorityBank, float threshold);
int cellMSStreamSetPriorityBankMaxLimit(const CELL_MS_PRIORITY_BANKS priorityBank, int limit);
int cellMSStreamGetPriorityBank(int ch);
float cellMSStreamGetPriorityLevel(int ch);
float cellMSStreamGetPriorityBankThreshold(const CELL_MS_PRIORITY_BANKS priorityBank);
int cellMSStreamGetPriorityBankMaxLimit(const CELL_MS_PRIORITY_BANKS priorityBank);

/**********************************************************************************************************
C O R E
**********************************************************************************************************/
void cellMSCoreSetWetInGain(int chNo, const float inGain);
int cellMSCoreSetVolume1(int chNo,  const CELL_MS_PATH type, const CELL_MS_SPEAKERS speakerNo, const CELL_MS_CHANNELS channelNo, const float volume);
int cellMSCoreSetVolume64(int chNo,  const CELL_MS_PATH type, const float *volumes);
int cellMSCoreSetVolume8(int chNo,  const CELL_MS_PATH type, const CELL_MS_CHANNELS channelNo, const float *volumes);
int cellMSCoreSetEQ(int chNo, const float *eqData);
void cellMSCoreSetEQEnable(int chNo, const CELL_MS_PATH type, const CELL_MS_EQSTATE eqSwitch);
void cellMSCoreSetBypass(int chNo, const CELL_MS_PATH type, const CELL_MS_BYPASS bypass);
void cellMSCoreSetPause(int chNo, const CELL_MS_PAUSE pause);
void cellMSCoreSetDSP(int chNo, const CELL_MS_DSPSLOTS slot, const int dspHandle);
void cellMSCoreBypassDSP(int chNo, const CELL_MS_DSPSLOTS slot, const CELL_MS_BYPASS bypass);
int cellMSCoreInit(int chNo);
void cellMSCoreRoutingInit(int typeBitMask);
int cellMSCoreSetRouting(int busNo,int destBus, const CELL_MS_PATH type, const CELL_MS_ROUTES onOff, const float dryVolume, float wetVolume);
void cellMSCoreSetMask(int chNo, const CELL_MS_DSPMASKS dspMask, const CELL_MS_DSPSLOTS dspSlot, const int maskSlot, const char bitMask);
void cellMSCoreSetMasks(int chNo, const CELL_MS_DSPMASKS dspMask, const CELL_MS_DSPSLOTS dspSlot, const char *bitMasks);
int cellMSCoreGetMask(int chNo, const CELL_MS_DSPMASKS dspMask, const CELL_MS_DSPSLOTS dspSlot, const int maskSlot);
char *cellMSCoreGetMasks(int chNo, const CELL_MS_DSPMASKS dspMask, const CELL_MS_DSPSLOTS dspSlot);
float cellMSCoreGetWetInGain(int chNo);
float cellMSCoreGetVolume1(int chNo, const CELL_MS_PATH type,const CELL_MS_SPEAKERS speakerNo, const CELL_MS_CHANNELS channelNo);
float *cellMSCoreGetVolume8(int chNo, const CELL_MS_PATH type, const CELL_MS_CHANNELS channelNo);
float *cellMSCoreGetVolume64(int chNo, const CELL_MS_PATH type);
float *cellMSCoreGetEQ(int chNo);
CELL_MS_EQSTATE cellMSCoreGetEQEnable(int chNo, const CELL_MS_PATH type);
CELL_MS_BYPASS cellMSCoreGetBypass(int chNo, const CELL_MS_PATH type);
CELL_MS_PAUSE cellMSCoreGetPause(int chNo);
int cellMSCoreGetDSPHandle(int chNo, const CELL_MS_DSPSLOTS slot);
void *cellMSCoreGetDSPParamAddr(int chNo, const CELL_MS_DSPSLOTS slot);
void cellMSCoreStop(int chNo,const int flag);

/**********************************************************************************************************
E Q
**********************************************************************************************************/
int cellMSEQGetFFTBand(float hz);
int cellMSEQSetPoint(CellEQSection *section, int index, float x, float y);
int cellMSEQOffsetPoint(CellEQSection *section, int index, float offX, float offY);
CellEQPoint *cellMSEQGetPoint(CellEQSection *section, int index);
int cellMSEQGetNumberOfPoints(CellEQSection *section);
int cellMSEQGet512Points(CellEQSection *section, float *values);
int cellMSEQInitMorphEQ(CellEQMorphSection *mSection, CellEQSection *start, CellEQSection *end);
int cellMSEQGet512PointsMorphed(CellEQMorphSection *mSection, float pos, float *values);
int cellMSEQSetTag(CellEQSection* section, unsigned char* tag, float x, float y);
int cellMSEQOffsetTag(CellEQSection* section, unsigned char* tag, float offX, float offY);

/**********************************************************************************************************
E N V E L O P E
**********************************************************************************************************/
int cellMSEnvSetup(const int streamNo, CellMSEnvelope *env);

/**********************************************************************************************************
D S P  H A N D L I N G
**********************************************************************************************************/
void cellMSDSPReset(void);
int cellMSDSPLoadDSPFromMemory(const void *DSPEffect, CellMSDSP *user, const int handle);
int cellMSDSPLoadDSPFromFile(const char *DSPName, const void *WS, CellMSDSP *user, const int handle);
int cellMSDSPCalcMemoryNeededForChunks(const int sizeOfFileInBytes);
int cellMSDSPCreateFFTChunks(short *sampleData, const int fileSize, CellComplexNum* chunks,int flag);

/**********************************************************************************************************
S U R R O U N D
**********************************************************************************************************/
int cellMSSurroundInit(void *memoryHeap, int sourceMax, int listenerMax);
int cellMSSurroundClose(void);
int cellMSSurroundGetInfoSize(int sourceMax, int listenerMax);
int cellMSSurroundInitSource(unsigned int ch);
int cellMSSurroundInitListener(unsigned int listener);
int cellMSSurroundSetListener(unsigned int ch, unsigned int listener);
int cellMSSurroundActive(unsigned int ch, int flag, unsigned int listener, CELL_MS_PATH type);
int cellMSSurroundSourcef(unsigned int ch, int eParam, float flValue);
int cellMSSurroundSource3f(unsigned int ch, int eParam, float flValue1,float flValue2,float flValue3);
int cellMSSurroundSourcefv(unsigned int ch, int eParam, float *pflValues);
int cellMSSurroundListenerf(unsigned int listener, int eParam, float flValue);
int cellMSSurroundListener3f(unsigned int listener, int eParam, float flValue1, float flValue2, float flValue3);
int cellMSSurroundListenerfv(unsigned int listener, int eParam, float *pflValues);
int cellMSSurroundDopplerFactor(float value);
int cellMSSurroundDopplerVelocity(float value);
int cellMSSurroundSpeedOfSound(float flSpeedOfSound);
int cellMSSurroundDistanceModel(unsigned int value);

/**********************************************************************************************************
A T R A C 
**********************************************************************************************************/
//int cellMSATRACGetNeededMemorySize(int channels);
//int cellMSATRACInit(int channels, void *ATRACMemory);
//void cellMSATRACClose(void);

/**********************************************************************************************************
E Q  D S P
**********************************************************************************************************/
int cellMSFXEQInit(void *addr, float *buffer);
int cellMSFXEQSet(void *addr, float *buffer, int slot);
float *cellMSFXEQGet(void *addr, int slot);

/**********************************************************************************************************
R I N G M O D  D S P
**********************************************************************************************************/
int cellMSFXRingModSetFrequency(void *addr, float hz, int slot);
int cellMSFXRingModSetAmplitude(void *addr, float amplitude, int slot);
int cellMSFXRingModInit(void *addr, float hz, float amplitude);
int cellMSFXRingModGetFrequency(void *addr, float *hz, int slot);
int cellMSFXRingModGetAmplitude(void *addr, float *amplitude, int slot);

/**********************************************************************************************************
F I L T E R   D S P
**********************************************************************************************************/
int cellMSFXFilterInit(void* paramList, void* pFilterMemBlock, const float fFrequency, const float fQ, const CELL_MSFX_FILTERMODE eFiltMode, const float fGainDecibel);
int cellMSFXFilterSet(void* paramList, const float fFrequency, const float fQ, const CELL_MSFX_FILTERMODE eFiltMode, const float fGainDecibel, int slot);
int cellMSFXFilterGet(void * addr, float *fFrequency, float *fQ, CELL_MSFX_FILTERMODE *eFiltMode, float *fGainDecibel, int slot);
int cellMSFXFilterGetNeededMemorySize(const int maxChannel);

/**********************************************************************************************************
P I T C H S H I F T   D S P
**********************************************************************************************************/
int cellMSFXPitchShiftInit(void *paramList, void * pitchMemBlock, float pitch, int numActivePitches);
int cellMSFXPitchShiftSet(void *paramList, float cents, int slot);
int cellMSFXPitchShiftGet(void *paramList, float *cents, int slot);
int cellMSFXPitchShiftGetNeededMemorySize(int numActivePitches);

/**********************************************************************************************************
D I S T O R T I O N  D S P
**********************************************************************************************************/
int cellMSFXDistortionInit(void *addr, CellMSFXDistortion *data);
int cellMSFXDistortionSet(void *addr, CellMSFXDistortion *data);
int cellMSFXDistortionGet(void *addr, CellMSFXDistortion *data);

/**********************************************************************************************************
C O M P R E S S O R   D S P
**********************************************************************************************************/
int cellMSFXCompressorInitCalc(void *addr,	CellMSFXCompressorInfo *buffer);
int cellMSFXCompressorInitApply(void *addr, CellMSFXCompressorInfo *buffer);

/**********************************************************************************************************
I R E V E R B   D S P
**********************************************************************************************************/
int cellMSFXIRDSPInfoGetNeededMemorySize(int num_impulses, void** impulses);
int cellMSFXIRDSPImpulseGetNeededMemorySize(int fileSize);
int cellMSFXIRDSPCreateImpulse(void* impulse_mem, int fileSize, char* fileData, int endian);
int cellMSFXIRDSPInitInfo(void* reverb_dsp_info, int num_impulses, void** array_impulses);
int cellMSFXIRDSPInit(void* paramList, void* info);
int cellMSFXIRDSPClearAccumBuffers(void *reverb_dsp_info);

/**********************************************************************************************************
V O C O D E R   D S P
**********************************************************************************************************/
int cellMSFXVocoderSetAllBandsBypass(void *addr, long long switches);
int cellMSFXVocoderInitCarrier(void *addr, CellMSFXVocoderInfo *buffer);
int cellMSFXVocoderInitModulator(void *addr, CellMSFXVocoderInfo *buffer);
int cellMSFXVocoderSetEQBand(void *addr, unsigned int band, float value);
int cellMSFXVocoderSetAllEQBands(void *addr, float *values);
int cellMSFXVocoderSetBandBypass(void *addr, unsigned int band, unsigned char vSwitch);
int cellMSFXVocoderSetCarrierVolume(void *addr, float volume);

/**********************************************************************************************************
T I M E   D O M A I N   R E V E R B   D S P
**********************************************************************************************************/
int cellMSFXReverbInit(void *addr, void* pReverbMemBlock, const CellMSFXReverbParams* pParams, int numActiveReverbChannels);
int cellMSFXReverbSetParams(void* pReverbMemBlock, const CellMSFXReverbParams* pParams, int slot);
int cellMSFXReverbGetNeededMemorySize(int numReverbs);

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
}
#endif

#endif
