/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_CONTROL_H__
#define __CELL_SPURS_CONTROL_H__ 1

/* The C Standard Library */
#include <stdint.h>
#include <stdbool.h>


#ifndef __linux__
/* Lv2 */
#include <sys/spu_thread.h>				/* sys_spu_thread_t */
#endif

/* SPURS */
#include <cell/spurs/types.h>			/* CellSpurs */
#include <cell/spurs/error.h>

#ifdef __cplusplus
extern "C" {
#endif

int cellSpursInitialize(CellSpurs*, unsigned nSpus, int spuPriority, int ppuPriority, bool isExit);
int cellSpursFinalize(CellSpurs*);
int cellSpursWakeUp(CellSpurs*);
#ifdef __linux__
/* FIXME: Is Linux version of cellSpursGetSpuThreadId() needed ? */
#else /* !__linux__ */
int cellSpursGetSpuThreadId(CellSpurs*, sys_spu_thread_t*, unsigned *nThreads);
#endif /* !__linux__ */
int cellSpursGetNumSpuThread(CellSpurs*, unsigned *nThreads);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __CELL_SPURS_CONTROL_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
