/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2006 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef __CELL_SPURS_LV2_EVENT_QUEUE_CONFIG_H__
#define __CELL_SPURS_LV2_EVENT_QUEUE_CONFIG_H__ 1

#define	CELL_SPURS_PORT_RANGE_END			63

#define	CELL_SPURS_STATIC_PORT_NUM			16
#define	CELL_SPURS_STATIC_PORT_RANGE_BOTTOM	(CELL_SPURS_STATIC_PORT_NUM - 1)

#define	CELL_SPURS_DYNAMIC_PORT_RANGE_TOP	(CELL_SPURS_STATIC_PORT_NUM)
#define	CELL_SPURS_DYNAMIC_PORT_RANGE_BOTTOM	CELL_SPURS_PORT_RANGE_END
#define	CELL_SPURS_DYNAMIC_PORT_NUM			(CELL_SPURS_DYNAMIC_PORT_RANGE_BOTTOM - CELL_SPURS_STATIC_PORT_BOTTOM)

/* The C Standard Library */
#include <stdint.h>

#ifndef __linux__
/* Lv2 */
#include <sys/event.h>
#endif /* !__linux__ */

/* SPURS */
#include <cell/spurs/types.h>			/* CellSpurs */
#include <cell/spurs/error.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __linux__
int cellSpursAttachLv2EventQueue(CellSpurs* spurs, sys_event_queue_t queue, uint8_t* port, int isDynamic);
#endif /* !__linux__ */
int cellSpursDetachLv2EventQueue(CellSpurs* spurs, uint8_t port);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __CELL_SPURS_LV2_EVENT_QUEUE_CONFIG_H__ */

/*
 * Local Variables:
 * mode: C
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
