/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2005 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/


#ifndef __CELL_SYNC_QUEUE_H__
#define __CELL_SYNC_QUEUE_H__

#include <cell/sync/error.h>
#include <stdint.h>

/**
 *  @addtogroup SYNC SYNC
 */
/**
 *  @addtogroup PU PU
 *  @ingroup SYNC
 */
/**
 *  @addtogroup CellSyncQueue
 *  @ingroup PU
 */
/*@{*/




#define CELL_SYNC_QUEUE_MINIMUM_BUFFER_SIZE 128

typedef	union _CellSyncQueueHead {
#ifdef __GNUC__
	__extension__
#endif
	struct _CellSyncQueueHeadStr {
		uint64_t rlock        :  8;  
		uint64_t index        : 24;
		uint64_t wlock        :  8;  
		uint64_t size         : 24;  
	} asStr;
	uint64_t asUint;
} _CellSyncQueueHead;
	

typedef struct  _CellSyncQueue {
	_CellSyncQueueHead head;
	uint32_t           buffer_size;
	uint32_t           depth;
	uint64_t           addr_buffer;
	uint64_t           _padding;
} CellSyncQueue;


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

int
cellSyncQueueInitialize(CellSyncQueue *obj, 
						void* ptr_buffer, 
						uint32_t buffer_size, 
						uint32_t depth);


int
cellSyncQueuePush(CellSyncQueue *obj, 
				  const void *buf);


int  
cellSyncQueueTryPush(CellSyncQueue *obj, 
					 const void *buf);


int
cellSyncQueuePop(CellSyncQueue *obj, 
				 void *buf);

int  
cellSyncQueueTryPop(CellSyncQueue *obj, 
					void *buf);


unsigned int 
cellSyncQueueSize(CellSyncQueue *obj);

int
cellSyncQueueClear(CellSyncQueue *obj);


int 
cellSyncQueuePeek(CellSyncQueue *obj, void *buf);

int 
cellSyncQueueTryPeek(CellSyncQueue *obj, void *buf);

#ifdef __cplusplus
}
#endif /* __cplusplus */


/*@}*/

#endif /* __CELL_SYNC_QUEUE_H__ */



/*
 * Local Variables:
 * mode: C
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */





