/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2005 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/


#ifndef __CELL_SYNC_RWM_H__
#define __CELL_SYNC_RWM_H__

#include <cell/sync/error.h>
#include <stdint.h>
/**
 *  @addtogroup SYNC SYNC
 */
/**
 *  @addtogroup PU PU
 *  @ingroup SYNC
 */
/**
 *  @addtogroup CellSyncRwm
 *  @ingroup PU
 */
/*@{*/


typedef struct CellSyncRwm{
	union CellSyncRwm_lock{
		struct CellSyncRwm_rwlock{
			uint16_t rlock;
			uint16_t wlock;
		} rwlock;
		uint32_t uint_val;
	} lock;
	uint32_t buffer_size;
	uint64_t buffer;
} CellSyncRwm;


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



int
cellSyncRwmInitialize(CellSyncRwm *obj, 
					  void* buffer,  
					  uint32_t buffer_size);

int
cellSyncRwmRead(CellSyncRwm * obj, void* buffer);

int
cellSyncRwmTryRead(CellSyncRwm * obj, void* buffer);

int
cellSyncRwmWrite(CellSyncRwm * obj, void* buffer);


int
cellSyncRwmTryWrite(CellSyncRwm * obj, void* buffer);

#ifdef __cplusplus
}
#endif /* __cplusplus */


/*@}*/

#endif /* __CELL_SYNC_RWM_H__ */
