/*   SCE CONFIDENTIAL                                       */
/*   PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006 */
/*   Copyright (C) 2006 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */

#ifndef __CELL_USBD_ERROR_H__
#define __CELL_USBD_ERROR_H__

#include <cell/error.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*
  CELL_ERROR_FACILITY_USB       0x011
  libusbd       : 0x8011_0001 - 0x8011_00ff
*/

#define CELL_USBD_MAKE_ERROR(status) \
	CELL_ERROR_MAKE_ERROR(CELL_ERROR_FACILITY_USB, status)

/* ERR: CELL_USBD_MAKE_ERROR(0x0001) */
#define CELL_USBD_ERROR_NOT_INITIALIZED         CELL_ERROR_CAST(0x80110001)

/* ERR: CELL_USBD_MAKE_ERROR(0x0002) */
#define CELL_USBD_ERROR_ALREADY_INITIALIZED     CELL_ERROR_CAST(0x80110002)

/* ERR: CELL_USBD_MAKE_ERROR(0x0003) */
#define CELL_USBD_ERROR_NO_MEMORY               CELL_ERROR_CAST(0x80110003)

/* ERR: CELL_USBD_MAKE_ERROR(0x0004) */
#define CELL_USBD_ERROR_INVALID_PARAM           CELL_ERROR_CAST(0x80110004)

/* ERR: CELL_USBD_MAKE_ERROR(0x0005) */
#define CELL_USBD_ERROR_INVALID_TRANSFER_TYPE   CELL_ERROR_CAST(0x80110005)

/* ERR: CELL_USBD_MAKE_ERROR(0x0006) */
#define CELL_USBD_ERROR_LDD_ALREADY_REGISTERED  CELL_ERROR_CAST(0x80110006)

/* ERR: CELL_USBD_MAKE_ERROR(0x0007) */
#define CELL_USBD_ERROR_LDD_NOT_ALLOCATED       CELL_ERROR_CAST(0x80110007)

/* ERR: CELL_USBD_MAKE_ERROR(0x0008) */
#define CELL_USBD_ERROR_LDD_NOT_RELEASED        CELL_ERROR_CAST(0x80110008)

/* ERR: CELL_USBD_MAKE_ERROR(0x0009) */
#define CELL_USBD_ERROR_LDD_NOT_FOUND           CELL_ERROR_CAST(0x80110009)

/* ERR: CELL_USBD_MAKE_ERROR(0x000a) */
#define CELL_USBD_ERROR_DEVICE_NOT_FOUND        CELL_ERROR_CAST(0x8011000a)

/* ERR: CELL_USBD_MAKE_ERROR(0x000b) */
#define CELL_USBD_ERROR_PIPE_NOT_ALLOCATED      CELL_ERROR_CAST(0x8011000b)

/* ERR: CELL_USBD_MAKE_ERROR(0x000c) */
#define CELL_USBD_ERROR_PIPE_NOT_RELEASED       CELL_ERROR_CAST(0x8011000c)

/* ERR: CELL_USBD_MAKE_ERROR(0x000d) */
#define CELL_USBD_ERROR_PIPE_NOT_FOUND          CELL_ERROR_CAST(0x8011000d)

/* ERR: CELL_USBD_MAKE_ERROR(0x000e) */
#define CELL_USBD_ERROR_IOREQ_NOT_ALLOCATED     CELL_ERROR_CAST(0x8011000e)

/* ERR: CELL_USBD_MAKE_ERROR(0x000f) */
#define CELL_USBD_ERROR_IOREQ_NOT_RELEASED      CELL_ERROR_CAST(0x8011000f)

/* ERR: CELL_USBD_MAKE_ERROR(0x00ff) */
#define CELL_USBD_ERROR_FATAL                   CELL_ERROR_CAST(0x801100ff)


#if defined(__cplusplus)
}
#endif

#endif	/* __CELL_USBD_ERROR_H__ */

