/*   SCE CONFIDENTIAL                                       */
/*   PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006 */
/*   Copyright (C) 2006 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */

/**
 * \ingroup all_syscall
 * \defgroup adhoc Adhoc System Calls
 * \brief adhoc system calls defined in sys/adhoc.h
 *
 * Interfaces defined in sys/adhoc.h
 *
 * These system calls are provided for special and temporary purposes.
 * These interfaces will be disappearred in the future releases.
 *
 */
/*@{*/

#ifndef	__SYS_SYS_ADHOC_H__
#define	__SYS_SYS_ADHOC_H__

#include <sys/cdefs.h>
#include <sys/syscall.h>

#include <sys/types.h>
#include <sys/integertypes.h>
#include <sys/return_code.h>



#define MEM_OBJ                     (0x08)
#define MUTEX_OBJ                   (0x05 | SYNC_OBJ)
#define COND_OBJ                    (0x06 | SYNC_OBJ)
#define SYNCP_OBJ                   (0x07 | SYNC_OBJ)
#define RWLOCK_OBJ                  (0x08 | SYNC_OBJ)
#define INTR_TAG_OBJ                (0x0A)
#define INTR_SERVICE_HANDLE_OBJ     (0x0B)
#define ADHOC_CONSOLE_OBJ           (0x0C)
#define EVENT_QUEUE_OBJ             (0x0D | SYNC_OBJ)
#define EVENT_PORT_OBJ              (0x0E)
#define PROGRAM_SEGMENT_OBJ         (0x0F)
#define EXTERNAL_EVENT_PORT_OBJ     (0x10 | SYNC_OBJ)
#define SHM_OBJ                     (0x20)
#define TRACE_OBJ                   (0x21)
#define SPUIMAGE_OBJ                (0x22)
#define PRX_OBJ                     (0x23)	/* MSB should be 0 */
#define IOS_USBD_OBJ                (0x30)
#define SLEEP_QUEUE_OBJ             (0x15 | SYNC_OBJ)
#define TIMER_OBJ                   (0x11)

/* Only synchronization primitives can use this bit. */
#define SYNC_OBJ                    0x80


#ifdef	__cplusplus
extern "C" {
#endif							/* __cplusplus */

	typedef __CSTD uint32_t console_t;


	/* syscall to create logical console */
	static inline int logical_console_open(console_t * console_id,
										   __CSTD uint64_t lcid) {
		system_call(2, LOGICAL_CONSOLE_OPEN, (uint32_t) console_id, lcid);

#ifdef REG_PASS_LOGICAL_CONSOLE_OPEN
		REG_PASS_LOGICAL_CONSOLE_OPEN;
#endif
		return_to_user_prog(int);
	}
	/* syscall to destroy logical console */
		static inline int logical_console_close(console_t console_id) {
		system_call(1, LOGICAL_CONSOLE_CLOSE, console_id);

#ifdef REG_PASS_LOGICAL_CONSOLE_CLOSE
		REG_PASS_LOGICAL_CONSOLE_CLOSE;
#endif
		return_to_user_prog(int);
	}


	/* syscall to get a charcter */
	static inline int logical_console_getc(console_t console_id) {
		system_call(1, LOGICAL_CONSOLE_GETC, console_id);

#ifdef REG_PASS_LOGICAL_CONSOLE_GETC
		REG_PASS_LOGICAL_CONSOLE_GETC;
#endif
		return_to_user_prog(int);
	}


	/* syscall to get a charcter */
	static inline int logical_console_try_getc(console_t console_id) {
		system_call(1, LOGICAL_CONSOLE_TRY_GETC, console_id);

#ifdef REG_PASS_LOGICAL_CONSOLE_TRY_GETC
		REG_PASS_LOGICAL_CONSOLE_TRY_GETC;
#endif
		return_to_user_prog(int);
	}


	/* syscall to put a charcter */
	static inline int logical_console_putc(console_t console_id, int c) {
		system_call(2, LOGICAL_CONSOLE_PUTC, console_id, c);

#ifdef REG_PASS_LOGICAL_CONSOLE_PUTC
		REG_PASS_LOGICAL_CONSOLE_PUTC;
#endif
		return_to_user_prog(int);
	}


	/* syscall to flush send buffer */
	static inline int logical_console_flush(console_t console_id) {
		system_call(1, LOGICAL_CONSOLE_FLUSH, console_id);

#ifdef REG_PASS_LOGICAL_CONSOLE_FLUSH
		REG_PASS_LOGICAL_CONSOLE_FLUSH;
#endif
		return_to_user_prog(int);
	}


	/* syscall to set VMX rounding mode */
	static inline int sys_hw_set_vmx_rounding_mode(uint64_t mode) {
		system_call(1, SYS_HW_SET_VMX_ROUNDING_MODE, mode);

#ifdef REG_PASS_SYS_HW_SET_VMX_ROUNDING_MODE
		REG_PASS_SYS_HW_SET_VMX_ROUNDING_MODE;
#endif
		return_to_user_prog(int);
	}

#define SYS_HW_VMX_ROUNDING_GRAPHIC		0x00000001
#define SYS_HW_VMX_ROUNDING_NORMAL		0x00000000












#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __SYS_SYS_ADHOC_H__ */

/*@}*/
