/*   SCE CONFIDENTIAL                                       */
/*   PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006 */
/*   Copyright (C) 2005 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */

/**
 * \ingroup all_syscall
 * \defgroup console_syscall Console I/O
 * \brief console system calls defined in sys/console.h
 *
 * Interfaces defined in sys/console.h 
 *
 * These system calls are provided for special and temporary purposes.
 * These interfaces will be disappearred in the future releases.
 */
/*@{*/

#ifndef	__LV2_KERNEL_INFRA_SYSCALL_CONSOLE_H__
#define	__LV2_KERNEL_INFRA_SYSCALL_CONSOLE_H__

#include <sys/cdefs.h>
#include <sys/syscall.h>

CDECL_BEGIN

static inline void console_putc(int c)
{
	system_call(1, CONSOLE_PUTC, c);

#ifdef REG_PASS_CONSOLE_PUTC
	REG_PASS_CONSOLE_PUTC;
#endif
	return_to_user_prog(void);
}


static inline int console_write(char *data, unsigned long len)
{
	system_call(2, CONSOLE_WRITE, (uint32_t) data, len);

#ifdef REG_PASS_CONSOLE_WRITE
	REG_PASS_CONSOLE_WRITE;
#endif
	return_to_user_prog(int);
}


static inline int console_getc(void)
{
	system_call(0, CONSOLE_GETC);

#ifdef REG_PASS_CONSOLE_GETC
	REG_PASS_CONSOLE_GETC;
#endif
	return_to_user_prog(int);
}


CDECL_END

#endif /* __LV2_KERNEL_INFRA_SYSCALL_CONSOLE_H__ */

/*@}*/
