/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2006 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _CELL_SYSUTIL_COMMON_H_
#define _CELL_SYSUTIL_COMMON_H_

#include <sys/types.h>

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" {
#endif	/* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */


#define CELL_SYSUTIL_ERROR_BASE_INTERNAL		(0x8002b000)
#define CELL_SYSUTIL_ERROR_BASE_COMMON 			(0x8002b100)
#define CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM		(0x8002b200)
#define CELL_SYSUTIL_ERROR_BASE_MSGDIALOG		(0x8002b300)
#define CELL_SYSUTIL_ERROR_BASE_SAVEDATA		(0x8002b400)
#define CELL_SYSUTIL_ERROR_BASE_OSKDIALOG		(0x8002b500)

#define CELL_SYSUTIL_ERROR_TYPE					( CELL_SYSUTIL_ERROR_BASE_COMMON | 0x01 )  /* 0x8002b101 */
#define CELL_SYSUTIL_ERROR_VALUE				( CELL_SYSUTIL_ERROR_BASE_COMMON | 0x02 )  /* 0x8002b102 */
#define CELL_SYSUTIL_ERROR_SIZE					( CELL_SYSUTIL_ERROR_BASE_COMMON | 0x03 )  /* 0x8002b103 */
#define CELL_SYSUTIL_ERROR_NUM					( CELL_SYSUTIL_ERROR_BASE_COMMON | 0x04 )  /* 0x8002b104 */
#define CELL_SYSUTIL_ERROR_BUSY					( CELL_SYSUTIL_ERROR_BASE_COMMON | 0x05 )  /* 0x8002b105 */
#define CELL_SYSUTIL_ERROR_STATUS				( CELL_SYSUTIL_ERROR_BASE_COMMON | 0x06 )  /* 0x8002b106 */

#define CELL_SYSUTIL_REQUEST_EXITGAME			(0x0011)	/*J ゲーム終了通知 */

typedef void (*CellSysutilCallback)( uint64_t status, uint64_t param, void * userdata );

int cellSysutilInit(void);
int cellSysutilShutdown(void);
int cellSysutilCheckCallback(void);
int cellSysutilRegisterCallback( int slot, CellSysutilCallback func, void * userdata );
int cellSysutilUnregisterCallback( int slot );


#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
}
#endif	/* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */

#endif /*_CELL_SYSUTIL_COMMON_H_*/
