/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2006 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _CELL_SYSUTIL_MSGDIALOG_H_
#define _CELL_SYSUTIL_MSGDIALOG_H_

#include "sysutil_common.h"

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" {
#endif	/* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */


#define CELL_MSGDIALOG_STRING_SIZE	(512)		/*J メッセージストリングのサイズ */

/*J ダイアログのタイプ */
typedef enum
{
	CELL_MSGDIALOG_DIALOG_TYPE_ERROR	= 0x00000000,	/*J エラーダイアログ */
	CELL_MSGDIALOG_DIALOG_TYPE_NORMAL	= 0x00000001,	/*J 通常ダイアログ */

	CELL_MSGDIALOG_BUTTON_TYPE_NONE		= 0x00000000,	/*J [Yes/No]ボタン無し */
	CELL_MSGDIALOG_BUTTON_TYPE_YESNO	= 0x00000010,	/*J [Yes/No]ボタン有 */

	CELL_MSGDIALOG_DEFAULT_CURSOR_YES	= 0x00000000,	/*J デフォルトカーソル[Yes] */
	CELL_MSGDIALOG_DEFAULT_CURSOR_NO	= 0x00000100	/*J デフォルトカーソル[No] */
} CellMsgDialogType;

/*J [Yes/No]選択ダイアログの際の押されたボタンの結果 */
typedef enum
{
	CELL_MSGDIALOG_BUTTON_INVALID = 0,
	CELL_MSGDIALOG_BUTTON_YES     = 1,    /*J [Yes]を決定ボタンで選択した */
	CELL_MSGDIALOG_BUTTON_NO      = 2,    /*J [No]を決定ボタンで選択した */
	CELL_MSGDIALOG_BUTTON_ESCAPE  = 3     /*J 戻るボタンが押された */
} CellMsgDialogButtonType;

/*J エラーコード */
#define CELL_MSGDIALOG_ERROR_PARAM					( CELL_SYSUTIL_ERROR_BASE_MSGDIALOG | 0x01 )	/*J 0x8002b301 パラメータが不正 */

/*J メッセージダイアログ結果通知コールバック関数 */
typedef void (*CellMsgDialogCallback)( int button_type, void *userdata );

int cellMsgDialogOpen( unsigned int type,			/*J 起動タイプ CellMsgDialogTypeの値をビットOR演算子で組み合わせて設定します。 */
					   const char *msgString,		/*J 表示する文字列 (UTF-8で指定。NULL文字を含む) */
					   CellMsgDialogCallback func,	/*J メッセージダイアログ結果通知コールバック関数指定 */
					   void *userdata,				/*J コールバック関数で受け取るユーザデータ */
					   void *extparam				/*J 拡張用パラメータ */
);

int cellMsgDialogAbort( void );

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
}
#endif	/* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */

#endif /*_CELL_SYSUTIL_MSGDIALOG_H_*/
