/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2006 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _CELL_SYSUTIL_OSKDIALOG_H_
#define _CELL_SYSUTIL_OSKDIALOG_H_

#include "sysutil_common.h"

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" {
#endif	/* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */

/*J OSK の状態 */
#define CELL_SYSUTIL_OSKDIALOG_LOADED			(0x0501)
#define CELL_SYSUTIL_OSKDIALOG_FINISHED			(0x0502)
#define CELL_SYSUTIL_OSKDIALOG_UNLOADED			(0x0503)

/* constant definitions------------------------------------------------------ */
/*J OSK のエラー */
#define CELL_OSKDIALOG_ERROR_UNKNOWN 	( CELL_SYSUTIL_ERROR_BASE_OSKDIALOG | 0x03 )	/*J 0x8002b503 未知のエラーが発生した */
#define CELL_OSKDIALOG_ERROR_PARAM	 	( CELL_SYSUTIL_ERROR_BASE_OSKDIALOG | 0x04 )	/*J 0x8002b504 パラメータが不正 */

/*J OSK ユーティリティの状態 */
typedef enum {
	CELL_OSKDIALOG_LOCAL_STATUS_NONE		 =(0),		/*J 未初期化 */
	CELL_OSKDIALOG_LOCAL_STATUS_INITIALIZING =(1),		/*J 初期化中 */
	CELL_OSKDIALOG_LOCAL_STATUS_INITIALIZED	 =(2),		/*J 初期化済み */
	CELL_OSKDIALOG_LOCAL_STATUS_OPENED		 =(3),		/*J サービス開始 */
	CELL_OSKDIALOG_LOCAL_STATUS_CLOSING		 =(4),		/*J サービスを終了中 */
	CELL_OSKDIALOG_LOCAL_STATUS_CLOSED		 =(5)		/*J サービスを終了 */
} CellOskDialogLocalStatus;

/*J 入力モード */
#define CELL_OSKDIALOG_PANELMODE_DEFAULT				0x00000000  /*J デフォルトパネル */
#define CELL_OSKDIALOG_PANELMODE_ALPHABET				0x00000010  /*J 全角英数 */
#define CELL_OSKDIALOG_PANELMODE_ALPHABET_HALF			0x00000020  /*J 半角英数 */
#define CELL_OSKDIALOG_PANELMODE_NUMERAL				0x00800000  /*J 全角数字 */
#define CELL_OSKDIALOG_PANELMODE_NUMERAL_HALF			0x01000000  /*J 半角数字 */
#define CELL_OSKDIALOG_PANELMODE_JAPANESE				0x00000001  /*J 日本語入力 */
#define CELL_OSKDIALOG_PANELMODE_JAPANESE_HIRA			0x00000002  /*J ひらがな入力 */
#define CELL_OSKDIALOG_PANELMODE_JAPANESE_KANA			0x00000004  /*J カタカナ入力 */
#define CELL_OSKDIALOG_PANELMODE_ENGLISH				0x00000040  /*J 英語+数字入力 */

/*J 禁止動作設定フラグ */
#define CELL_OSKDIALOG_NO_SPACE			0x00000001	/*J スペース禁止フラグ。スペース入力 */
#define CELL_OSKDIALOG_NO_RETURN		0x00000002	/*J 改行禁止フラグ。自動的にシングルライン固定の入力になる */
#define CELL_OSKDIALOG_NO_PREDICT		0x00000004	/*J  補完禁止フラグ。日本語以外のエンジンを使用する入力では
														自動的にマルチタップ入力になる。日本語の場合変換モード
														動作Onlyになる
													*/
#define CELL_OSKDIALOG_NO_INPUT_ANALOG	0x00000008	/*J アナログ移動禁止 */

/*J OSKダイアログストリングのサイズ */
#define CELL_OSKDIALOG_STRING_SIZE	(512)


/*J 各入力フィールド個別の戻り値 */
typedef enum {
	CELL_OSKDIALOG_INPUT_FIELD_RESULT_OK       = (0),	/*J 処理は正常に終了 */
	CELL_OSKDIALOG_INPUT_FIELD_RESULT_CANCELED = (1),	/*J ユーザの操作によってキャンセルされた */
} CellOskDialogInputFieldResult;

/* simple variable type definitions------------------------------------------ */
/* nothing */
/* structure definitions----------------------------------------------------- */
/*J 入力フィールド情報の構造体 */
typedef struct {
	uint16_t* message;		/*J OSKアプリの左上にガイドとして
												表示される文字列 */
	uint16_t* init_text;	/*J 初期入力文字列 */
	int limit_length;		/*J 入力文字の制限値
								(単位は「文字」(バイトではありません))*/
} CellOskDialogInputFieldInfo;

/*J コールバック用構造体 */
typedef struct {
	int result;
	int resultStringBufferSize;
	uint16_t *pResultString;
} CellOskDialogCallbackReturnParam;

/*J 入力コントロールの位置、サイズ情報構造体 */
typedef struct{
	float x;
	float y;
} CellOskDialogPoint;

/*J OSK ユーティリティ起動パラメータ */
typedef struct {
	/*J OSKの基本定義 */
	unsigned int allowOskPanelFlg;		/*J 使用するパネルをフラグで選択
												(英数入力、ひらがな入力など) */
	unsigned int firstViewPanel;		/*J 最初に表示するパネルを選択 */
	CellOskDialogPoint controlPoint;	/*J 入力コントロールの位置、
											サイズ情報(OSKの表示位置指定のため) */
    int prohibitFlgs;					/*J 禁止条項フラグ */
} CellOskDialogParam;

/*J OSKダイアログ結果通知コールバック関数 */
typedef void (*CellOskDialogCallback)( int button_type, void *userdata );

int cellOskDialogRegisterCallback( int slot, CellOskDialogCallback func, void * userdata );
int cellOskDialogUnregisterCallback( int slot );

int cellOskDialogLoadAsync( CellOskDialogParam* dialogParam, CellOskDialogInputFieldInfo* inputFieldInfo );
int cellOskDialogUnloadAsync(CellOskDialogCallbackReturnParam* OutputInfo);

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
}
#endif	/* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */

#endif /*_CELL_SYSUTIL_OSKDIALOG_H_*/
