/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2006 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _CELL_SYSUTIL_SAVEDATA_H_
#define _CELL_SYSUTIL_SAVEDATA_H_

#include "sysutil_common.h"

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" {
#endif	/* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */

/*J 正常終了コード */
#define CELL_SAVEDATA_RET_OK				(0)
#define CELL_SAVEDATA_RET_CANCEL			(1)

/*J エラーコード */
#define CELL_SAVEDATA_ERROR_CBRESULT		( CELL_SYSUTIL_ERROR_BASE_SAVEDATA | 0x01 )	/*J 0x8002b401 コールバック関数にエラーを返された */
#define CELL_SAVEDATA_ERROR_ACCESS_ERROR	( CELL_SYSUTIL_ERROR_BASE_SAVEDATA | 0x02 )	/*J 0x8002b402 HDD アクセスエラー */
#define CELL_SAVEDATA_ERROR_INTERNAL		( CELL_SYSUTIL_ERROR_BASE_SAVEDATA | 0x03 )	/*J 0x8002b403 内部エラー */

/*J エラー終了コード−アプリケーション開発時までに対処する必要のあるもの */
#define CELL_SAVEDATA_ERROR_PARAM			( CELL_SYSUTIL_ERROR_BASE_SAVEDATA | 0x04 )	/*J 0x8002b404 パラメータが不正 */
#define CELL_SAVEDATA_ERROR_NOSPACE			( CELL_SYSUTIL_ERROR_BASE_SAVEDATA | 0x05 )	/*J 0x8002b405 HDD 空き不足 */
#define CELL_SAVEDATA_ERROR_BROKEN			( CELL_SYSUTIL_ERROR_BASE_SAVEDATA | 0x06 )	/*J 0x8002b406 セーブデータを破損判定した */

typedef enum {									/*J セーブデータの形式バージョン */
	CELL_SAVEDATA_VERSION_CURRENT = 0,			/*J 最新の形式 */
} CellSaveDataVersion;

typedef enum {									/*J 各種サイズ */
	CELL_SAVEDATA_DIRNAME_SIZE			= 32,	/*J ディレクトリ名最大サイズ */
	CELL_SAVEDATA_FILENAME_SIZE			= 32,	/*J ファイル名最大サイズ */
	CELL_SAVEDATA_SECUREFILEID_SIZE		= 16,	/*J 保護ありデータファイルの暗号IDサイズ */

	CELL_SAVEDATA_LISTITEM_MAX			= 1024,	/*J リスト選択型のリスト表示項目最大数 */
	CELL_SAVEDATA_SECUREFILE_MAX		= 99,	/*J 保護ありデータファイルの最大数 */
	CELL_SAVEDATA_DIRLIST_MAX			= 2048,	/*J ディレクトリリスト取得時のリスト項目最大数 */
	CELL_SAVEDATA_INVALIDMSG_MAX		= 256	/*J CELL_SAVEDATA_CBRESULT_ERR_INVALD時のメッセージ最大サイズ */
} CellSaveDataParamSize;

typedef enum {									/*J PARAM.SFOのパラメータ */
	CELL_SAVEDATA_SYSP_TITLE_SIZE 		= 128,	/*J タイトル名最大サイズ */
	CELL_SAVEDATA_SYSP_SUBTITLE_SIZE	= 128,	/*J サブタイトル名最大サイズ */
	CELL_SAVEDATA_SYSP_DETAIL_SIZE		= 1024	/*J 詳細情報最大サイズ */
} CellSaveDataSystemParamSize;

typedef enum {									/*J ソート種別 */
	CELL_SAVEDATA_SORTTYPE_MODIFIEDTIME = 0,	/*J 更新日付順 */
	CELL_SAVEDATA_SORTTYPE_TITLE				/*J タイトル名順 */
} CellSaveDataSortType;

typedef enum {									/*J ソート順 */
	CELL_SAVEDATA_SORTORDER_DESCENT = 0,		/*J 降順(新しいものが上) */
	CELL_SAVEDATA_SORTORDER_ASCENT				/*J 昇順 */
} CellSaveDataSortOrder;

typedef enum {									/*J アイコンの位置 */
	CELL_SAVEDATA_ICONPOS_HEAD = 0,				/*J 先頭 */
	CELL_SAVEDATA_ICONPOS_TAIL					/*J 末尾 */
} CellSaveDataIconPosition;

typedef enum {									/*J リスト選択型の初期フォーカス位置 */
	CELL_SAVEDATA_FOCUSPOS_DIRNAME = 0,			/*J ディレクトリ名指定 */
	CELL_SAVEDATA_FOCUSPOS_LISTHEAD,			/*J リスト先頭のアイコン */
	CELL_SAVEDATA_FOCUSPOS_LISTTAIL,			/*J リスト末尾のアイコン */
	CELL_SAVEDATA_FOCUSPOS_LATEST,				/*J 更新日時が最新データのアイコン */
	CELL_SAVEDATA_FOCUSPOS_OLDEST,				/*J 更新日時が最古データのアイコン */
	CELL_SAVEDATA_FOCUSPOS_NEWDATA				/*J 新規セーブデータのアイコン */
} CellSaveDataFocusPosition;

typedef enum {									/*J 新規セーブデータか既存のデータかを示すフラグ用 */
	CELL_SAVEDATA_ISNEWDATA_NO = 0,				/*J 既存のデータ */
	CELL_SAVEDATA_ISNEWDATA_YES					/*J 新規セーブデータ(ディレクトリが存在しない) */
} CellSaveDataIsNewData;

typedef enum {									/*J オートタイプのエラーダイアログ出力設定 */
	CELL_SAVEDATA_ERRDIALOG_NONE = 0,			/*J 一切出力しない */
	CELL_SAVEDATA_ERRDIALOG_ALWAYS,				/*J 常に出力する */
	CELL_SAVEDATA_ERRDIALOG_NOREPEAT			/*J 同じエラーは連続出力しない */
} CellSaveDataErrDialog;

												/*J 操作条件 */
#define CELL_SAVEDATA_ATTR_NORMAL		(0)		/*J なし */
#define CELL_SAVEDATA_ATTR_NODUPLICATE	(1<<0)	/*J コピー禁止 */

													/*J バインド情報 */
#define CELL_SAVEDATA_BINDSTAT_OK			(0)		/*J 全てOK */
#define CELL_SAVEDATA_BINDSTAT_ERR_CONSOLE	(1<<0)	/*J 本体バインドエラー */
#define CELL_SAVEDATA_BINDSTAT_ERR_DISC		(1<<1)	/*J ディスクバインドエラー */
#define CELL_SAVEDATA_BINDSTAT_ERR_PROGRAM	(1<<2)	/*J プログラムバインドエラー */
#define CELL_SAVEDATA_BINDSTAT_ERR_NOUSER	(1<<3)	/*J ユーザ情報なしセーブデータ */
#define CELL_SAVEDATA_BINDSTAT_ERR_OTHERS	(1<<4)	/*J 他のユーザのセーブデータ */

typedef enum {									/*J セーブデータをいったん削除するか指定用 */
	CELL_SAVEDATA_RECREATE_NO = 0,				/*J そのまま使用 */
	CELL_SAVEDATA_RECREATE_YES					/*J いったん削除 */
} CellSaveDataReCreateMode;

typedef enum {									/*J ファイル種別 */
	CELL_SAVEDATA_FILETYPE_SECUREFILE = 0,		/*J 保護ありデータファイル */
	CELL_SAVEDATA_FILETYPE_NORMALFILE,			/*J 保護なしデータファイル */
	CELL_SAVEDATA_FILETYPE_CONTENT_ICON0,		/*J コンテンツ情報：ICON0.PNG */
	CELL_SAVEDATA_FILETYPE_CONTENT_ICON1,		/*J コンテンツ情報：ICON1.PAM */
	CELL_SAVEDATA_FILETYPE_CONTENT_PIC1,		/*J コンテンツ情報：PIC1.PNG */
	CELL_SAVEDATA_FILETYPE_CONTENT_SND0			/*J コンテンツ情報：SND0.AT3 */
} CellSaveDataFileType;

typedef enum {									/*J ファイル操作 */
	CELL_SAVEDATA_FILEOP_READ = 0,				/*J 読み込み */
	CELL_SAVEDATA_FILEOP_WRITE,					/*J 書き込み */
	CELL_SAVEDATA_FILEOP_DELETE					/*J 削除 */
} CellSaveDataFileOperation;

/*J 構造体：引数向け -------------------------------------------------------------------------------- */
typedef struct {								/*J セーブデータリスト指定用 */
	unsigned int sortType;						/*J ソート種別 */
	unsigned int sortOrder;						/*J ソート順 */
	char *dirNamePrefix;						/*J ディレクトリ名prefix指定 */
	void *reserved;
} CellSaveDataSetList;

typedef struct {								/*J バッファ指定用 */
	unsigned int dirListMax;					/*J ディレクトリリスト最大取得数(CELL_SAVEDATA_DIRLIST_MAX以下) */
	unsigned int fileListMax;					/*J ファイルリスト最大取得数(特に制限なし) */
	unsigned int reserved[6];

	unsigned int bufSize;						/*J 汎用バッファサイズ */
	void *buf;									/*J 汎用バッファ */
} CellSaveDataSetBuf;

/*J 構造体：コールバック関数向け[実体はユーティリティ側で用意] -------------------------------------- */
typedef struct {								/*J 新規セーブデータ指定 */
	unsigned int iconPosition;					/*J アイコン位置指定 */
	char *dirName;								/*J 作成される場合のディレクトリ名 */

	char *title;								/*J タイトル名 */
	unsigned int iconBufSize;					/*J 静止画アイコンサイズ */
	void *iconBuf;								/*J 静止画アイコンバッファ */

	void *reserved;
} CellSavedataNewData;

typedef struct {								/*J データリストコールバック取得用 */
	unsigned int dirNum;						/*J 検索条件を満たすディレクトリの総数 */
	unsigned int dirListNum;					/*J リストに取得した項目数 */
	char (*dirList)[CELL_SAVEDATA_DIRNAME_SIZE];/*J ディレクトリリスト(CellSaveDataSetBuf *bufを使用) */
	char reserved[64];
} CellSaveDataListGet;

typedef struct {								/*J データリストコールバック設定用 */
	unsigned int focusPosition;					/*J フォーカス位置指定 */
	char *focusDirName;							/*J フォーカス位置指定がディレクトリ名指定の場合に使用 */
	unsigned int fixedListNum;					/*J 画面表示するリスト項目数 */
	char (*fixedList)[CELL_SAVEDATA_DIRNAME_SIZE];
												/*J 画面表示するリスト指定 */
	CellSavedataNewData *newData;				/*J 新規セーブデータ指定。NULLで指定なし */
	void *reserved;
} CellSaveDataListSet;

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
typedef struct {								/*J PARAM.SFO パラメータ取得設定用 */
	char title[CELL_SAVEDATA_SYSP_TITLE_SIZE];
	char subTitle[CELL_SAVEDATA_SYSP_SUBTITLE_SIZE];
	char detail[CELL_SAVEDATA_SYSP_DETAIL_SIZE];
	unsigned int attribute;						/*J 操作条件 */
	unsigned int parentalLevel;
	char reserved[256];
} CellSaveDataSystemFileParam;

typedef struct {								/*J ディレクトリステータス */
	time_t st_atime;							/*J アクセス日時 */
	time_t st_mtime;							/*J 更新日時 */
	time_t st_ctime;							/*J 作成日時 */
	char dirName[CELL_SAVEDATA_DIRNAME_SIZE];	/*J ディレクトリ名 */
} CellSaveDataDirStat;

typedef struct {								/*J ファイルステータス */
	unsigned int fileType;						/*J ファイル種別 */
	uint64_t st_size;							/*J ファイルサイズ */
	uint64_t secureFileDataSize;				/*J 保護ありデータファイルの場合のデータ部サイズ */
	time_t st_atime;							/*J アクセス日時 */
	time_t st_mtime;							/*J 更新日時 */
	time_t st_ctime;							/*J 作成日時 */
	char fileName[CELL_SAVEDATA_FILENAME_SIZE];	/*J ファイル名 */
} CellSaveDataFileStat;

typedef struct {								/*J データステータスコールバック取得用 */
	int hddFreeSizeKB;							/*J HDD空き容量(キロバイト単位) */

	unsigned int isNewData;						/*J 新規セーブデータか既存のデータかを示すフラグ */
	CellSaveDataDirStat dir;					/*J ユーザに選択されたデータ(新規セーブデータの場合はディレクトリ名のみ有効) */
	CellSaveDataSystemFileParam getParam;		/*J PARAM.SFO情報(新規セーブデータの場合は構造体すべてが0クリアされている) */
	unsigned int bind;							/*J バインド情報 */

	int sizeKB;									/*J セーブデータの現在のサイズ(新規セーブデータの場合は0) */
	int sysSizeKB;								/*J システムファイルのサイズ */

	unsigned int fileNum;						/*J すべてのファイル数(システムファイル除く) */
	unsigned int fileListNum;					/*J リストに取得した項目数(システムファイル除く) */
	CellSaveDataFileStat *fileList;				/*J ファイルリスト(CellSaveDataSetBuf *bufを使用) */
	char reserved[64];
} CellSaveDataStatGet;

typedef struct {								/*J データステータスコールバック設定用 */
	CellSaveDataSystemFileParam *setParam;		/*J PARAM.SFO情報設定。&getParamを代入可能。NULLの場合は更新しない */
	unsigned int reCreateMode;					/*J セーブデータをいったん削除するかどうか */
	void *reserved;
} CellSaveDataStatSet;

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

typedef struct {								/*J ファイル操作コールバック取得用 */
	unsigned int excSize;						/*J 直前のファイル操作コールバックでバッファに読み書きしたサイズ */
	char reserved[64];
} CellSaveDataFileGet;

typedef struct {								/*J ファイル操作コールバック設定用 */
	unsigned int fileOperation;					/*J ファイル操作を指定 */
	void *reserved;

	unsigned int fileType;						/*J ファイル種別指定 */
	unsigned char secureFileId[CELL_SAVEDATA_SECUREFILEID_SIZE];
												/*J 暗号ID。保護ありデータファイルの場合のみ */
	char *fileName;								/*J ファイル名。保護あり/保護なしデータファイルの場合のみ */

	unsigned int fileOffset;					/*J ファイルを読み書きする先頭からのoffset */
	unsigned int fileSize;						/*J ファイルを読み書きするサイズ */
	unsigned int fileBufSize;					/*J ファイルバッファサイズ */
	void *fileBuf;								/*J ファイルバッファポインタ */
} CellSaveDataFileSet;


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*J コールバック関数終了コード */
#define CELL_SAVEDATA_CBRESULT_OK_LAST		(1)		/*J 正常終了：次のコールバック呼び出しは不要。ユーティリティ終了処理 */
#define CELL_SAVEDATA_CBRESULT_OK_NEXT		(0)		/*J 正常終了：次のコールバック呼び出しを要求 */
#define CELL_SAVEDATA_CBRESULT_ERR_NOSPACE	(-1)	/*J 空き容量不足 */
#define CELL_SAVEDATA_CBRESULT_ERR_FAILURE	(-2)	/*J セーブ/ロード処理失敗 */
#define CELL_SAVEDATA_CBRESULT_ERR_BROKEN	(-3)	/*J セーブデータ破損判定 */
#define CELL_SAVEDATA_CBRESULT_ERR_NODATA	(-4)	/*J データがない */
#define CELL_SAVEDATA_CBRESULT_ERR_INVALID	(-5)	/*J 汎用エラー(バインドNGなど) */

typedef struct {								/*J コールバック関数の結果指定 */
	unsigned int result;						/*J コールバック関数終了コード指定 */

	unsigned int progressBarInc;				/*J プログレスバー用増分パラメータ */

	int errNeedSizeKB;							/*J 空き容量不足エラーの場合の不足サイズ。キロバイト単位 */
	char *invalidMsg;							/*J 汎用エラーの場合のメッセージ */
	void *reserved;
} CellSaveDataCBResult;

/*J コールバック関数 -------------------------------------------------------------------------------- */
/*J データリストコールバック関数 */
typedef void (*CellSaveDataListCallback)( CellSaveDataCBResult *cbResult,
										  CellSaveDataListGet *get,
										  CellSaveDataListSet *set );

/*J データステータスコールバック関数 */
typedef void (*CellSaveDataStatCallback)( CellSaveDataCBResult *cbResult,
										  CellSaveDataStatGet *get,
										  CellSaveDataStatSet *set );

/*J ファイル操作コールバック関数 */
typedef void (*CellSaveDataFileCallback)( CellSaveDataCBResult *cbResult,
										  CellSaveDataFileGet *get,
										  CellSaveDataFileSet *set );

/*J ユーティリティ関数 ------------------------------------------------------------------------------ */
/*J リスト選択型セーブ */
int cellSaveDataListSave( unsigned int version,
						  CellSaveDataSetList *setList,
						  CellSaveDataSetBuf *setBuf,
						  CellSaveDataListCallback funcList,
						  CellSaveDataStatCallback funcStat,
						  CellSaveDataFileCallback funcFile );

/*J リスト選択型ロード */
int cellSaveDataListLoad( unsigned int version,
						  CellSaveDataSetList *setList,
						  CellSaveDataSetBuf *setBuf,
						  CellSaveDataListCallback funcList,
						  CellSaveDataStatCallback funcStat,
						  CellSaveDataFileCallback funcFile );

/*J 固定型セーブ */
int cellSaveDataFixedSave( unsigned int version,
						  const char *dirName,
						  CellSaveDataSetBuf *setBuf,
						  CellSaveDataStatCallback funcStat,
						  CellSaveDataFileCallback funcFile );

/*J 固定型ロード */
int cellSaveDataFixedLoad( unsigned int version,
						  const char *dirName,
						  CellSaveDataSetBuf *setBuf,
						  CellSaveDataStatCallback funcStat,
						  CellSaveDataFileCallback funcFile );

/*J オートセーブ */
int cellSaveDataAutoSave( unsigned int version,
						  const char *dirName,
						  unsigned int errDialog,
						  CellSaveDataSetBuf *setBuf,
						  CellSaveDataStatCallback funcStat,
						  CellSaveDataFileCallback funcFile );

/*J オートロード */
int cellSaveDataAutoLoad( unsigned int version,
						  const char *dirName,
						  unsigned int errDialog,
						  CellSaveDataSetBuf *setBuf,
						  CellSaveDataStatCallback funcStat,
						  CellSaveDataFileCallback funcFile );

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
}
#endif	/* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */

#endif /*_CELL_SYSUTIL_SAVEDATA_H_*/
