/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef _CELL_SYSUTIL_SYSPARAM_H_
#define _CELL_SYSUTIL_SYSPARAM_H_

#include "sysutil_common.h"

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
extern "C" {
#endif  /* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */

#define CELL_SYSUTIL_SYSTEMPARAM_ID_KEYBOARD_TYPE	(0x0101)

#define CELL_SYSUTIL_SYSTEMPARAM_KEYBOARD_TYPE_101	(0)
#define CELL_SYSUTIL_SYSTEMPARAM_KEYBOARD_TYPE_106	(1)

/* --------------------------- Error Code ----------------------------- */
enum {
	/* #define CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM		(0x8002b200) */
	/* video */
	CELL_VIDEO_SUCCEEDED						= 0,
	CELL_VIDEO_ERROR_NOT_IMPLEMENTED			= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x20),
	CELL_VIDEO_ERROR_ILLEGAL_CONFIGURATION		= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x21),
	CELL_VIDEO_ERROR_ILLEGAL_PARAMETER			= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x22),
	CELL_VIDEO_ERROR_PARAMETER_OUT_OF_RANGE		= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x23),
	CELL_VIDEO_ERROR_DEVICE_NOT_FOUND			= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x24),
	CELL_VIDEO_ERROR_UNSUPPORTED_VIDEO_OUT		= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x25),
	CELL_VIDEO_ERROR_UNSUPPORTED_DISPLAY_MODE	= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x26),

	/* audio */
	CELL_AUDIO_SUCCEEDED						= 0,
	CELL_AUDIO_ERROR_NOT_IMPLEMENTED			= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x40),
	CELL_AUDIO_ERROR_ILLEGAL_CONFIGURATION		= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x41),
	CELL_AUDIO_ERROR_ILLEGAL_PARAMETER			= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x42),
	CELL_AUDIO_ERROR_PARAMETER_OUT_OF_RANGE		= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x43),
	CELL_AUDIO_ERROR_DEVICE_NOT_FOUND			= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x44),
	CELL_AUDIO_ERROR_UNSUPPORTED_AUDIO_OUT		= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x45),
	CELL_AUDIO_ERROR_UNSUPPORTED_SOUND_MODE		= (CELL_SYSUTIL_ERROR_BASE_SYSTEMPARAM | 0x46)
};

/* ----------------------------- Video -------------------------------- */

typedef enum CellVideoOut {
	CELL_VIDEO_OUT_PRIMARY,
	CELL_VIDEO_OUT_SECONDARY
} CellVideoOut;

typedef enum CellVideoResolutionId {
	CELL_VIDEO_RESOLUTION_UNDEFINED  = 0,
	CELL_VIDEO_RESOLUTION_1080       = 1,
	CELL_VIDEO_RESOLUTION_720        = 2,
	CELL_VIDEO_RESOLUTION_480        = 4,
	CELL_VIDEO_RESOLUTION_576        = 5
} CellVideoResolutionId;

typedef enum CellVideoOutScanMode {
	CELL_VIDEO_SCAN_MODE_INTERLACE,
	CELL_VIDEO_SCAN_MODE_PROGRESSIVE
} CellVideoOutScanMode;

typedef enum CellVideoRefreshRate {
	CELL_VIDEO_REFRESH_RATE_59_94HZ = 0x0001,
	CELL_VIDEO_REFRESH_RATE_50HZ    = 0x0002,
	CELL_VIDEO_REFRESH_RATE_60HZ    = 0x0004,
	CELL_VIDEO_REFRESH_RATE_30HZ    = 0x0008
} CellVideoRefreshRate;

typedef enum CellVideoOutPortType {
	CELL_VIDEO_OUT_PORT_NONE        = 0x00,
	CELL_VIDEO_OUT_PORT_HDMI        = 0x01,
	CELL_VIDEO_OUT_PORT_COMPSITE_S  = 0x81,
	CELL_VIDEO_OUT_PORT_D           = 0x82,
	CELL_VIDEO_OUT_PORT_COMPONENT   = 0x83,
	CELL_VIDEO_OUT_PORT_RGB         = 0x84,
	CELL_VIDEO_OUT_PORT_SCART       = 0x85,
	CELL_VIDEO_OUT_PORT_DSUB        = 0x86
} CellVideoOutPortType;

typedef enum CellVideoDisplayAspect {
	CELL_VIDEO_ASPECT_4_3,
	CELL_VIDEO_ASPECT_16_9
} CellVideoDisplayAspect;

typedef enum CellVideoBufferColorFormat {
	CELL_VIDEO_BUFFER_COLOR_FORMAT_X8R8G8B8,
	CELL_VIDEO_BUFFER_COLOR_FORMAT_X8B8G8R8,
	CELL_VIDEO_BUFFER_COLOR_FORMAT_R16G16B16X16_FLOAT
} CellVideoBufferColorFormat;

typedef enum CellVideoOutputState {
	CELL_VIDEO_OUTPUT_STATE_ENABLED,
	CELL_VIDEO_OUTPUT_STATE_DISABLED
} CellVideoOutputState;

typedef enum CellVideoColorSpace {
	CELL_VIDEO_COLOR_SPACE_RGB,
	CELL_VIDEO_COLOR_SPACE_YUV,
	CELL_VIDEO_COLOR_SPACE_XVYCC
} CellVideoColorSpace;

typedef enum CellVideoOutDebugMonitorType {
	CELL_VIDEO_OUT_DEBUG_MONITOR_TYPE_UNDEFINED     = 0,
	CELL_VIDEO_OUT_DEBUG_MONITOR_TYPE_480I_59_94HZ  = 1,
	CELL_VIDEO_OUT_DEBUG_MONITOR_TYPE_576I_50HZ     = 2,
	CELL_VIDEO_OUT_DEBUG_MONITOR_TYPE_480P_59_94HZ  = 3,
	CELL_VIDEO_OUT_DEBUG_MONITOR_TYPE_576P_50HZ     = 4,
	CELL_VIDEO_OUT_DEBUG_MONITOR_TYPE_1080I_59_94HZ = 5,
	CELL_VIDEO_OUT_DEBUG_MONITOR_TYPE_720P_59_94HZ  = 7,
	CELL_VIDEO_OUT_DEBUG_MONITOR_TYPE_1080P_59_94HZ = 9,
	CELL_VIDEO_OUT_DEBUG_MONITOR_TYPE_WXGA_60HZ     = 11,
	CELL_VIDEO_OUT_DEBUG_MONITOR_TYPE_SXGA_60HZ     = 12,
	CELL_VIDEO_OUT_DEBUG_MONITOR_TYPE_WUXGA_60HZ    = 13
} CellVideoOutDebugMonitorType;

typedef struct CellVideoColorInfo {
	uint16_t                      redX;
	uint16_t                      redY;
	uint16_t                      greenX;
	uint16_t                      greenY;
	uint16_t                      blueX;
	uint16_t                      blueY;
	uint16_t                      whiteX;
	uint16_t                      whiteY;
	uint32_t                      gamma;
} CellVideoColorInfo;

typedef struct CellVideoOutKSVList {
	uint8_t                       ksv[32*5];
	uint8_t                       reserved[4];
	uint32_t                      count;
} CellVideoOutKSVList;

typedef enum CellVideoDisplayConversion {
	CELL_VIDEO_DISPLAY_CONVERSION_NONE			= 0,
	CELL_VIDEO_DISPLAY_CONVERSION_720_TO_WXGA	= 1,
	CELL_VIDEO_DISPLAY_CONVERSION_720_TO_SXGA	= 2,
	CELL_VIDEO_DISPLAY_CONVERSION_1080_TO_WUXGA	= 3,
	CELL_VIDEO_DISPLAY_CONVERSION_720_TO_1080I	= 5
} CellVideoDisplayConversion;

typedef struct CellVideoDisplayMode {
	uint8_t                       resolutionId;
	uint8_t                       scanMode;
	uint8_t                       conversion;
	uint8_t                       reserved[3];
	uint16_t                      refreshRates;
} CellVideoDisplayMode;

typedef struct CellVideoResolution {
	uint16_t                      width;
	uint16_t                      height;
} CellVideoResolution;

typedef struct CellVideoOutDeviceInfo {
	uint8_t                       portType;
	uint8_t                       aspect;
	uint16_t                      latency;
	uint8_t                       colorSpace;
	uint8_t                       availableModeCount;
	uint8_t                       reserved[6];
	CellVideoColorInfo            colorInfo;
	CellVideoDisplayMode          availableModes[32];
	CellVideoOutKSVList           ksvList;
} CellVideoOutDeviceInfo;

typedef struct CellVideoOutState {
	uint8_t                       state;
	uint8_t                       reserved[7];
	CellVideoDisplayMode          displayMode;
} CellVideoOutState;

typedef struct CellVideoOutConfiguration {
	uint8_t                       resolutionId;
	uint8_t                       format;
	uint8_t                       reserved[10];
	uint32_t                      pitch;
} CellVideoOutConfiguration;

typedef enum CellVideoOutEvent {
	CELL_VIDEO_OUT_EVENT_DEVICE_CHANGED,
	CELL_VIDEO_OUT_EVENT_OUTPUT_DISABLED,
	CELL_VIDEO_OUT_EVENT_DEVICE_AUTHENTICATED,
	CELL_VIDEO_OUT_EVENT_OUTPUT_ENABLED
} CellVideoOutEvent;

typedef struct CellVideoOutOption {
	uint32_t                      reserved;
} CellVideoOutOption;

typedef int (*CellVideoOutCallback)(
	uint32_t slot, uint32_t videoOut, uint32_t deviceIndex,
	uint32_t event, CellVideoOutDeviceInfo* info, void* userData
);

int cellVideoOutRegisterCallback(
	uint32_t slot, CellVideoOutCallback function, void* userData
);

int cellVideoOutUnregisterCallback(uint32_t slot);

int cellVideoOutGetNumberOfDevice(uint32_t videoOut);

int cellVideoOutGetState(
	uint32_t videoOut, uint32_t deviceIndex, CellVideoOutState* state
);

int cellVideoOutGetDeviceInfo(
	uint32_t videoOut, uint32_t deviceIndex, CellVideoOutDeviceInfo* info
);

int cellVideoOutConfigure(
	uint32_t videoOut, CellVideoOutConfiguration* config,
	CellVideoOutOption* option, uint32_t waitForEvent
);

int cellVideoOutGetResolution(
	uint32_t resolutionId, CellVideoResolution* resolution
);

int cellVideoOutDebugSetMonitorType(
	uint32_t videoOut, uint32_t monitorType
);

/* ----------------------------- Audio -------------------------------- */

typedef enum CellAudioOut {
	CELL_AUDIO_OUT_PRIMARY,
	CELL_AUDIO_OUT_SECONDARY
} CellAudioOut;

typedef enum CellAudioOutPortType {
	CELL_AUDIO_OUT_PORT_HDMI,
	CELL_AUDIO_OUT_PORT_SPDIF,
	CELL_AUDIO_OUT_PORT_ANALOG
} CellAudioOutPortType;

typedef enum CellAudioOutputState {
	CELL_AUDIO_OUTPUT_STATE_ENABLED,
	CELL_AUDIO_OUTPUT_STATE_DISABLED
} CellAudioOutputState;

typedef enum CellAudioCodingType {
	CELL_AUDIO_CODING_TYPE_STREAM = 0,
	CELL_AUDIO_CODING_TYPE_LPCM,
	CELL_AUDIO_CODING_TYPE_AC3,
	CELL_AUDIO_CODING_TYPE_MPEG1,
	CELL_AUDIO_CODING_TYPE_MP3,
	CELL_AUDIO_CODING_TYPE_MPEG2,
	CELL_AUDIO_CODING_TYPE_AAC,
	CELL_AUDIO_CODING_TYPE_DTS,
	CELL_AUDIO_CODING_TYPE_ATRAC,
	CELL_AUDIO_CODING_TYPE_BITSTREAM = 0xff
} CellAudioCodingType;

typedef enum CellAudioFs {
	CELL_AUDIO_FS_32KHZ                         = 0x01,
	CELL_AUDIO_FS_44KHZ                         = 0x02,
	CELL_AUDIO_FS_48KHZ                         = 0x04,
	CELL_AUDIO_FS_88KHZ                         = 0x08,
	CELL_AUDIO_FS_96KHZ                         = 0x10,
	CELL_AUDIO_FS_176KHZ                        = 0x20,
	CELL_AUDIO_FS_192KHZ                        = 0x40
} CellAudioFs;

typedef enum CellAudioOutChnum {
	CELL_AUDIO_OUT_CHNUM_2                      = 2,
	CELL_AUDIO_OUT_CHNUM_4                      = 4,
	CELL_AUDIO_OUT_CHNUM_6                      = 6,
	CELL_AUDIO_OUT_CHNUM_8                      = 8
} CellAudioOutChnum;

typedef enum CellAudioSbitOrBitrate {
	CELL_AUDIO_SBIT_NONE                        = 0x00,
	CELL_AUDIO_SBIT_16BIT                       = 0x01,
	CELL_AUDIO_SBIT_20BIT                       = 0x02,
	CELL_AUDIO_SBIT_24BIT                       = 0x04
} CellAudioSbitOrBitrate;

typedef enum CellAudioOutSpeakerLayout {
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_DEFAULT      = 0x00000000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_2CH          = 0x00000001,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_3CH_LRE      = 0x00000002,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_3CH_LRC      = 0x00000004,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_3CH_LRc      = 0x00000008,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_4CH_LREC     = 0x00000010,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_4CH_LREc     = 0x00000020,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_4CH_LRCc     = 0x00000040,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_4CH_LRlr     = 0x00000080,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_4CH_LRXY     = 0x00000100,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_5CH_LRECc    = 0x00000200,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_5CH_LRElr    = 0x00000400,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_5CH_LRClr    = 0x00000800,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_5CH_LRlrc    = 0x00001000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_5CH_LREXY    = 0x00002000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_5CH_LRCXY    = 0x00004000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_5CH_LRcXY    = 0x00008000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_6CH_LREClr   = 0x00010000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_6CH_LRElrc   = 0x00020000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_6CH_LRClrc   = 0x00040000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_6CH_LRlrxy   = 0x00080000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_6CH_LRECXY   = 0x00100000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_6CH_LREcXY   = 0x00200000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_6CH_LRCcXY   = 0x00400000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_6CH_LRlrXY   = 0x00800000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_7CH_LREClrc  = 0x01000000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_7CH_LRElrxy  = 0x02000000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_7CH_LRClrxy  = 0x04000000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_7CH_LRECcXY  = 0x08000000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_7CH_LRElrXY  = 0x10000000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_7CH_LRClrXY  = 0x20000000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_8CH_LREClrxy = 0x40000000,
	CELL_AUDIO_OUT_SPEAKER_LAYOUT_8CH_LREClrXY = 0x80000000
} CellAudioOutSpeakerLayout;

typedef struct CellAudioOutSoundMode {
	uint8_t                       type;
	uint8_t                       channel;
	uint8_t                       fs;
	uint8_t                       sbitOrBitrate;
	uint32_t                      layout;
} CellAudioOutSoundMode;

typedef struct CellAudioOutState {
	uint8_t                       state;
	uint8_t                       reserved[7];
	CellAudioOutSoundMode         soundMode;
} CellAudioOutState;

typedef struct CellAudioOutDeviceInfo {
	uint8_t                       portType;
	uint8_t                       availableModeCount;
	uint8_t                       reserved[4];
	uint16_t                      latency;
	CellAudioOutSoundMode         availableModes[16];
} CellAudioOutDeviceInfo;

typedef enum CellAudioOutDownMixer {
	CELL_AUDIO_DOWNMIXER_NONE,
	CELL_AUDIO_DOWNMIXER_TYPE_A
} CellAudioOutDownMixer;

typedef struct CellAudioOutConfiguration {
	uint8_t                       channel;
	uint8_t                       reserved[11];
	uint32_t                      downMixer;
} CellAudioOutConfiguration;

typedef struct CellAudioOutOption {
	uint32_t                      reserved;
} CellAudioOutOption;

typedef enum CellAudioOutEvent {
	CELL_AUDIO_OUT_EVENT_DEVICE_CHANGED,
	CELL_AUDIO_OUT_EVENT_OUTPUT_ENABLED
} CellAudioOutEvent;

typedef int (*CellAudioOutCallback)(
	uint32_t slot, uint32_t audioOut, uint32_t deviceIndex,
	uint32_t event, CellAudioOutDeviceInfo* info, void* userData
);

typedef uint32_t CellAudioOutLatency;

int cellAudioOutRegisterCallback(
	uint32_t slot, CellAudioOutCallback function, void* userData
);

int cellAudioOutUnregisterCallback(uint32_t slot);

int cellAudioOutGetNumberOfDevice(uint32_t audioOut);

int cellAudioOutGetDeviceInfo(
	uint32_t audioOut, uint32_t deviceIndex, CellAudioOutDeviceInfo* info
);

int cellAudioOutGetState(
	uint32_t audioOut, uint32_t deviceIndex, CellAudioOutState* state
);

int cellAudioOutConfigure(
	uint32_t audioOut, CellAudioOutConfiguration* config,
	CellAudioOutOption* option, uint32_t waitForEvent
);

#if defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus)
}
#endif /* defined(_LANGUAGE_C_PLUS_PLUS)||defined(__cplusplus)||defined(c_plusplus) */

#endif /*_CELL_SYSUTIL_SYSPARAM_H_*/
