/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_POLICY_MODULE_H__
#define __CELL_SPURS_POLICY_MODULE_H__

/* The C Standard Library */
#include <stdint.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif

void cellSpursModuleEntry(uintptr_t context, uint64_t ea) __attribute__((naked,noreturn));
void cellSpursModuleMain(uintptr_t context, uint64_t ea) __attribute__((noreturn));
bool cellSpursModulePoll(uintptr_t context);
void cellSpursModuleExit(uintptr_t context) __attribute__((__noreturn__));

/// @return the current spu ID
unsigned cellSpursModuleGetSpuId(uintptr_t context);

/// @return the current workload ID
unsigned cellSpursModuleGetWorkloadId(uintptr_t context);

void cellSpursModuleTrace(uintptr_t context, unsigned tag, uint64_t data);

/* ready count operation for policy module */
unsigned cellSpursModuleReadyCountSwap(uintptr_t context, unsigned value);
unsigned cellSpursModuleReadyCountCompareAndSwap(uintptr_t context, unsigned compare, unsigned swap);
unsigned cellSpursModuleReadyCountAdd(uintptr_t context, int value);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __CELL_SPURS_POLICY_MODULE_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
