/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 084.006
* Copyright (C) 2005 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/


#ifndef __CELL_SYNC_RWM_H__
#define __CELL_SYNC_RWM_H__

#include <cell/sync/error.h>
#include <cell/atomic.h>

typedef struct CellSyncRwm {
	union CellSyncRwm_lock {
		struct CellSyncRwm_rwlock {
			uint16_t rlock;
			uint16_t wlock;
		} rwlock;
		uint32_t uint_val;
	} lock;
	uint32_t buffer_size;
	uint64_t buffer;
} CellSyncRwm;

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


int
cellSyncRwmInitialize(uint64_t ea, 
					  uint64_t ptr_buffer,  
					  uint32_t buffer_size,
					  unsigned int tag);

int
cellSyncRwmReadBegin(uint64_t ea, void* buffer, unsigned int tag);

int
cellSyncRwmTryReadBegin(uint64_t ea, void* buffer, unsigned int tag);

int
cellSyncRwmReadEnd(uint64_t ea, unsigned int tag);

int
cellSyncRwmWrite(uint64_t ea, void* buffer, unsigned int tag);
int
cellSyncRwmTryWrite(uint64_t ea, void* buffer, unsigned int tag);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __CELL_SYNC_RWM_H__ */
