/***************************************************************************
 *
 *	CRI Middleware SDK
 *
 *	Copyright (c) 2005 CRI-MW
 *
 *	Library	: ADX Library
 *	Module	: Environmentally-dependent header for PS3 PPU
 *	File	: adx_ps3ppu.h
 *	Create	: 2005-08-05
 *	Version	: Refer "ADXPS3PPU_VER_NUM"
 *
 ***************************************************************************/

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef _ADXPS3PPU_H_INCLUDED
#define _ADXPS3PPU_H_INCLUDED

/***************************************************************************
 *       o[W
 *       Version
 ***************************************************************************/
#define ADXPS3PPU_VER_NAME		"ADXPS3PPU"
#define ADXPS3PPU_VER_NUM		"0.81"
#define ADXPS3PPU_VER_OPTION	

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include <stdio.h>
#include <cell/mixer.h>
#include "cri_xpt.h"

/***************************************************************************
 *      萔
 *      Constants
 ***************************************************************************/
/* t[[NʁiPS3 PPUj */
/* Framework type for PS3 PPU */
typedef enum {
	ADXM_FRAMEWORK_DEFAULT				= 0,	/* ftHg				*/
												/* Default					*/
	ADXM_FRAMEWORK_PS3PPU_SINGLE_THREAD	= 1,	/* VOXbh			*/
												/* Single thread			*/
	ADXM_FRAMEWORK_PS3PPU_MULTI_THREAD	= 2,	/* }`Xbh			*/
												/* Multi thread				*/
} AdxmFramework;
/* t[[NʁiPS3 PPUjɂĂ̕⑫ */
/* (a) ADXM_FRAMEWORK_DEFAULT̓vbgtH[ʂ̒`łÃv		*/
/* @@bgtH[ł߂̃t[[NI܂B				*/
/* @@PS3 PPUł̓}`XbhiADXM_FRAMEWORK_PS3PPU_MULTI_THREADj	*/
/* @@I܂B														*/

/* ftHgvCIeB */
/* Default priority */
#define ADXM_PS3PPU_PRIO_VV			(100)		/* zVsync				*/
												/* Virtual Vsync			*/
#define ADXM_PS3PPU_PRIO_VSYNC		(500)		/* VsyncXbh			*/
												/* Vsync thread				*/
#define ADXM_PS3PPU_PRIO_FS			(600)		/* t@CXbh		*/
												/* File processing thread	*/
#define ADXM_PS3PPU_PRIO_MAIN		(1001)		/* CXbh			*/
												/* Main thread				*/
#define ADXM_PS3PPU_PRIO_IDLE		(1500)		/* AChXbh			*/
												/* Idle thread				*/

/* ftHgX^bNTCY */
/* Default stack size */
#define ADXM_PS3PPU_STACK_SIZE		(8192)		/* 8k byte */

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/* XbhZbgAbvp[^iPS3 PPUj */
/* Thread setup parameter for PS3 PPU */
typedef struct {
	/* vCIeB */
	Sint32	priority_vv;		/* zVsync				*/
								/* Virtual Vsync			*/
	Sint32	priority_vsync;		/* VsyncXbh			*/
								/* Vsync thread				*/
	Sint32	priority_fs;		/* t@CXbh		*/
								/* File processing thread	*/
	Sint32	priority_main;		/* CXbh			*/
								/* Main thread				*/
	Sint32	priority_idle;		/* AChXbh			*/
								/* Idle thread				*/
} AdxmThreadSprm_PS3PPU;
/* Xbh̃ZbgAbvsۂ̒ӓ_									*/
/* (a) ZbgAbvp[^́AADXM_SetupFramework֐ɈprmƂ		*/
/* @@n܂BNULLw肷ƃftHgݒ肪gp܂B				*/
/* (b) ZbgAbvp[^́At[[NƂ						*/
/* @@ADXM_FRAMEWORK_PS3PPU_MULTI_THREADI񂾏ꍇ̂ݗLłB			*/
/* (c) vCIeB͐lႢقǗDxłB						*/


/* TEhVXe̐ݒ\		*/
/* Configuration of sound system	*/
typedef struct {
	CellAANHandle	mixer_handle;			/* TEh~LT̃nh	*/
											/* Handle of Surround Mixer		*/
	Sint32			num_output_channels;	/* o̓`l				*/
											/* Number of output channels	*/
	Sint32			num_max_voices;			/* ő{CX					*/
											/* Maximum number of voices		*/
	Uint8			*work;					/* [N̈					*/
											/* Working area					*/
	Sint32			work_size;				/* [N̈TCY				*/
											/* Size of working area			*/
} Adxps3SoundConfig;
/* TEhVXe̐ݒ\̂ɂĂ̕⑫								*/
/* (a) [N̈TCYADXPS3_CalcSoundWorkSize֐ɂvZĂ		*/
/* @@B܂AvZ[N̈TCỸmۂA[N		*/
/* @@ƂĐݒ肵ĂB											*/
/*	yz																	*/
/*		Adxps3SoundConfig config;											*/
/*		memset(&config, 0, sizeof(config));									*/
/*		config.mixer_handle			= sur_mixer_handle;						*/
/*		config.num_output_channels	= NUM_OUTPUT_CHANNELS;					*/
/*		config.num_voices			= NUM_MAX_VOICES;						*/
/*		config.work_size			= ADXPS3_CalcSoundWorkSize(&config);	*/
/*		config.work					= malloc(config.work_size);				*/
/* (b) mixer_handleNULLݒ肷邱ƂŁAo͂ȂiTEh		*/
/* @@~LT쐬ȂjɂΉł܂B							*/


/*	PS3t@CVXẽZbgAbvp[^\	*/
/*	Parameter structure for setup of PS3 file system	*/
typedef struct {
	const Char8 *rtdir;				/* [gfBNg	*/
									/* Root directory		*/
} Adxps3SprmPs3Fs;

/***************************************************************************
 *      ϐ錾
 *      Variable Declarations
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Function Prototypes
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/***
*			t[[Nݒ֐
*			Framework setting functions
***/
/* CRI~hEFÃt[[NZbgAbv */
/* Setup the framework of CRI Middleware */
Bool CRIAPI ADXM_SetupFramework(AdxmFramework framework, void *prm);
/* CRI~hEFÃt[[N̏I */
/* Shutdown the framework of CRI Middleware */
Bool CRIAPI ADXM_ShutdownFramework(void);

/***
*			TEhVXe֐
*			Sound system functions
***/
/* TEhVXeɕKvȃ[NTCY̌vZ */
/* Calculate working area size for sound system */
Sint32 CRIAPI ADXPS3_CalcSoundWorkSize(const Adxps3SoundConfig *config);

/* TEhVXẽZbgAbv */
/* Setup sound system */
Bool CRIAPI ADXPS3_SetupSound(const Adxps3SoundConfig *config);
/* TEhVXẽVbg_E */
/* Shutdown sound system */
void CRIAPI ADXPS3_ShutdownSound(void);

/* TEh~LTɃI[fBIf[^͂邽߂̒ʒmR[obN֐ */
/* Callback function for notification of audio data input from surround mixer */
Sint32 CRIAPI ADXPS3_SoundNotifyCallback(void *arg, Uint32 counter, Uint32 num_samples);

/***
*			t@CVXeݒ֐
*			File system setting functions
***/
/* PS3t@CVXẽZbgAbv */
/* Setup file system for PS3 */
void CRIAPI ADXPS3_SetupPs3Fs(const Adxps3SprmPs3Fs *sprm);
/* PS3t@CVXẽVbg_E */
/* Shutdown file system for PS3 */
void CRIAPI ADXPS3_ShutdownPs3Fs(void);


#ifdef __cplusplus
}
#endif

#endif	/* #ifndef _ADXPS3_H_INCLUDED */

/* end of file */
