/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2001-2005 CRI-MW
 *
 * Library  : MWSFD Library (CRI Sofdec)
 * Module   : Library User's Header (PS3-Specific)
 * File     : crimwsfd_ps3.h
 * Date     : 2005-10-19
 * Version  : (see MWD_SFD_VER)
 *
 ****************************************************************************/
#ifndef	CRIMWSFD_PS3_H_INCLUDED		/* Re-definition prevention */
#define	CRIMWSFD_PS3_H_INCLUDED

/***************************************************************************
 *      Include file
 ***************************************************************************/
#include <crimwsfd.h>

/***************************************************************************
 *      MACRO CONSTANT
 ***************************************************************************/

/***************************************************************************
 *      Process MACRO
 ***************************************************************************/

/***************************************************************************
 *      Enum definition
 ***************************************************************************/

/***************************************************************************
 *      Data type definition
 ***************************************************************************/

/* gp\vZbT */
typedef struct {
	Uint8		ppu_flag;			/* PPUgp\tO */
	Uint8		thr_spu_num;		/* gp\SPUXbh */
	Uint8		raw_spu_num;		/* gp\ȐSPU */
} MwsfdProcessor_PS3;


/***************************************************************************
 *      Function Declaration
 ***************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* YUVA8t[ϊ */
/* YUVA8 frame conversion */
void CRIAPI mwPlyFxCnvFrmYuva8_PS3(MWPLY mwply, MwsfdFrmObj *mwfrm, Uint8 *out);
void CRIAPI mwPlyFxCnvFrmClipYuva8_PS3(MWPLY mwply, MwsfdFrmObj *mwfrm, Uint8 *out, 
								Sint32 lux, Sint32 luy, Sint32 w, Sint32 h);

/* gp\vZbT̐ݒ (A) */
/* Set usable processor (currently not implemented) */
void CRIAPI mwPlySetUsableProcessor_PS3(MWPLY mwply, MwsfdProcessor_PS3 *processor);

#ifdef __cplusplus
}
#endif

#endif	/* CRIMWSFD_PS3_H_INCLUDED */
