#ifndef _SJ_H_INCLUDED
#define _SJ_H_INCLUDED
/****************************************************************************/
/*																			*/
/*					Xg[WCgCuwb_					*/
/*						 SJ (Stream Joint) Library							*/
/*																			*/
/*				 1998.4.14			written by M.Oshimi						*/
/*																			*/
/****************************************************************************/

/***************************************************************************
 *		CN[ht@C
 *		Include file
 ***************************************************************************/
#include "cri_xpt.h"

/***************************************************************************
 *		萔}N
 *		Constant Macro
 ***************************************************************************/
/* o[Wԍ */
/* Version number */
#define	SJ_VER				"6.37"

/* SJRBFp[N̈TCY */
/* Work area size of SJRBF */
#define SJRBF_WORK_SIZE		(128)

/***********************************************************************
 *		}N
 *		Process MACRO
 ***********************************************************************/
/* AhX̃|C^^ւ̕ϊ */
/* Conversion from address to pointer */
#define SJ_VOID_PTR(adr)	((void *)(adr))

/* nrbg[ɂ
 * @1,2,8,16rbg̏ꍇASH́AړĨWX^gp2߂ŏ
 * ł̂ŁAVtgɂB
 * @3`7rbg̏ꍇASH́A-128܂ł͖߃R[hɃC~fBGCgf[^
 * i[ł̂ŁA}XNɂB1߂܂2߁B
 * @̑̏ꍇA󋵂ɉčœKƂ͌ȂAVtgɂĂB
 */
/* Clears lower bits */
#define SJ_OFF_LSB(val, n)	((((Uint32)(val)) >> (n)) << (n))
#define SJ_OFF_LSB1(val)	((((Uint32)(val)) >> (1)) << (1))
#define SJ_OFF_LSB2(val)	((((Uint32)(val)) >> (2)) << (2))
#define SJ_OFF_LSB3(val)	(((Uint32)(val)) & (0xfffffff8))
#define SJ_OFF_LSB4(val)	(((Uint32)(val)) & (0xfffffff0))
#define SJ_OFF_LSB5(val)	(((Uint32)(val)) & (0xffffffe0))
#define SJ_OFF_LSB6(val)	(((Uint32)(val)) & (0xffffffc0))
#define SJ_OFF_LSB7(val)	(((Uint32)(val)) & (0xffffff80))
#define SJ_OFF_LSB8(val)	((((Uint32)(val)) >> (8)) << (8))
#define SJ_OFF_LSB16(val)	((((Uint32)(val)) >> (16)) << (16))

/* |C^2,4,8,16,32byteE܂Ŗ߂iӁFʂ(void*)^j */
/* Decreases the address value to various alignment */
#define SJ_BACK_BND2(ptr)	SJ_VOID_PTR(SJ_OFF_LSB1(ptr))
#define SJ_BACK_BND4(ptr)	SJ_VOID_PTR(SJ_OFF_LSB2(ptr))
#define SJ_BACK_BND8(ptr)	SJ_VOID_PTR(SJ_OFF_LSB3(ptr))
#define SJ_BACK_BND16(ptr)	SJ_VOID_PTR(SJ_OFF_LSB4(ptr))
#define SJ_BACK_BND32(ptr)	SJ_VOID_PTR(SJ_OFF_LSB5(ptr))

/* |C^2,4,8,16,32byteE܂Ői߂iӁFʂ(void*)^j */
/* Increases the address value to various alignment */
#define SJ_FORE_BND2(ptr)	SJ_BACK_BND2( ((Uint32)(ptr)) +  1)
#define SJ_FORE_BND4(ptr)	SJ_BACK_BND4( ((Uint32)(ptr)) +  3)
#define SJ_FORE_BND8(ptr)	SJ_BACK_BND8( ((Uint32)(ptr)) +  7)
#define SJ_FORE_BND16(ptr)	SJ_BACK_BND16(((Uint32)(ptr)) + 15)
#define SJ_FORE_BND32(ptr)	SJ_BACK_BND32(((Uint32)(ptr)) + 31)

/* 32byteË̗mۂ̂߂ɁÄTCY𐅑 */
/* Calculates the work area size which considers 32 byte alignment */
#define SJ_SIZ_BND32(siz)	((siz) + 32)

/* SJobt@AhX32oCgE̎擾 */
/* Gets 32 byte aligned address from SJ buffer */
#define	SJ_ADR_BND32(adr)	SJ_FORE_BND32(adr)

/* E̐[ƌI[߂ */
/* Gets the end position from start position and length */
#define SJ_GET_ENDPOS(bgn, num)		((bgn) + (num) - 1)

/* ĚiElFbgn <= endj */
/* Gets the number of the objects in boundary */
#define SJ_INNER_NUM(bgn, end)		((end) - (bgn) + 1)

/* E̔iElFbgn <= x <= endj */
/* Checks whether the value is in boundary */
#define SJ_IS_INNER(x, bgn, end) ( ((x) >= (bgn)) && ((x) <= (end)) )

/***********************************************************************
 *		f[^^
 *		Data type declaration
 ***********************************************************************/

/*	f[^C̒`		*/
/*	Data line definition	*/
#define	SJ_LIN_FREE	(0)			/*	t[`NC				*/
								/*	Free chunk line						*/
#define	SJ_LIN_DATA	(1)			/*	f[^`NC				*/
								/*	Data chunk line						*/

#define SJ_ERR_FATAL		(-1)
#define SJ_ERR_INTERNAL		(-2)
#define SJ_ERR_PRM			(-3)

/*	`N̏TCY	*/
/*	Maximum size of chunk	*/
#define	SJCK_LEN_MAX		(0x7fffffff)

#ifndef UUID_DEFINED
#define UUID_DEFINED
typedef struct _UUID {
    Uint32 Data1;
    Uint16 Data2;
    Uint16 Data3;
    Uint8 Data4[8];
} UUID;
#define uuid_t UUID
#endif

/*	f[^`N	*/
/*	Data chunk		*/
#ifndef SJCK_DEFINED
#define SJCK_DEFINED
typedef struct {
	Sint8 *data;				/*	JnAhX						*/
								/*	Begin address						*/
	Sint32 len;					/*	oCg							*/
								/*	Size of chunk length				*/
} SJCK;
#endif

/*	Cunh	*/
/*	SJ handle			*/
typedef struct {
	struct _sj_vtbl *vtbl;		/*	C^tF[X						*/
								/*	Interfaces							*/
} SJ_OBJ;
#ifndef SJ_DEFINED
#define SJ_DEFINED
typedef SJ_OBJ *SJ;
#endif

/*	C^tF[X֐  				*/
/*	Interface functions					*/
typedef struct _sj_vtbl {
	void (*QueryInterface)();		/*		for COM compatibility			*/
	void (*AddRef)();				/*		for COM compatibility			*/
	void (*Release)();				/*		for COM compatibility			*/
	void (*Destroy)(SJ sj);			/*		nh̏					*/
									/*		Destroys specified SJ handle	*/
	UUID *(*GetUuid)(SJ sj);		/*		UUID̎擾						*/
									/*		Get a UUID						*/
	void (*Reset)(SJ sj);			/*		Zbg						*/
									/*		Resets SJ						*/
	/*	`N̎擾	(FIFO̐擪擾)								*/
	/*	Get a chunk	(Get chunk from top of FIFO)							*/
	void (*GetChunk)(SJ sj, Sint32 id, Sint32 nbyte, SJCK *ck);
	/*	`N߂@(FIFO̐擪ɑ})									*/
	/*	Unget a chunk	(Insert chunk in top of FIFO)						*/
	void (*UngetChunk)(SJ sj, Sint32 id, SJCK *ck);
	/*	`N}	(FIFO̍Ōɑ})									*/
	/*	Put a chunk	(Insert chunk in last of FIFO)							*/
	void (*PutChunk)(SJ sj, Sint32 id, SJCK *ck);
	/*	擾łf[^̃oCg̎擾									*/
	/*	Get the data number which can be got								*/
	Sint32 (*GetNumData)(SJ sj, Sint32 id);
	/*	`N̎擾\̔											*/
	/*	Check whether can get chunk											*/
	Sint32 (*IsGetChunk)(SJ sj, Sint32 id, Sint32 nbyte, Sint32 *rbyte);
	/*	G[ɋN֐̓o^									*/
	/*	Entry error callback function										*/
	void (*EntryErrFunc)(SJ sj,
					void (*func)(void *obj, Sint32 ecode), void *obj);
} SJ_IF;
typedef SJ_IF *SJIF;

/*	Xg[WCg̏												*/
/*	Destroys specified SJ handle											*/
#define SJ_Destroy(sj) \
		(*(sj)->vtbl->Destroy)(sj)
/*	Xg[WCg̃Zbg											*/
/*	Resets SJ																*/
#define SJ_Reset(sj) \
		(*(sj)->vtbl->Reset)(sj)
/*	`N̎擾															*/
/*	Get a chunk																*/
#define SJ_GetChunk(sj, id, nbyte, ck) \
		(*(sj)->vtbl->GetChunk)(sj, id, nbyte, ck)
/*	`N߂															*/
/*	Unget a chunk 															*/
#define SJ_UngetChunk(sj, id, ck) \
		(*(sj)->vtbl->UngetChunk)(sj, id, ck)
/*	`N}															*/
/*	Put a chunk																*/
#define SJ_PutChunk(sj, id, ck) \
		(*(sj)->vtbl->PutChunk)(sj, id, ck)
/*	擾\ȃf[^̃oCg߂										*/
/*	Get the data number which can be got									*/
#define SJ_GetNumData(sj, id) \
		(*(sj)->vtbl->GetNumData)(sj, id)
/*	Xg[WCgUUID̎擾 (UUIDւ̃AhX)						*/
/*	Get a UUID																*/
#define SJ_GetUuid(sj) \
		(*(sj)->vtbl->GetUuid)(sj)
/*	G[ɋNR[obN֐̓o^							*/
/*	Entry error callback function											*/
#define SJ_EntryErrFunc(sj, f, o) \
		(*(sj)->vtbl->EntryErrFunc)(sj, f, o)
/*	`N̎擾\̔ 												*/
/*	Check whether can get chunk												*/
#define SJ_IsGetChunk(sj, id, nbyte, rbyte) \
			(*(sj)->vtbl->IsGetChunk)(sj, id, nbyte, rbyte)

/****************************************************************************
 *		֐̐錾
 *		Function Declaration
 ****************************************************************************/

#ifdef		__cplusplus
extern	"C" {
#endif

/*	$func$ `N̕
 * [@] void SJ_SplitChunk(SJCK *ck, Sint32 nbyte,
 *													SJCK *ck1, SJCK *ck2);
 * [@] ck		: ΏۂƂȂ`N
 *			nbyte	: ck1 ̃oCg
 * [o@] ck1		: ꂽÕ`N
 *			ck2		: ꂽ㔼̃`N
 * [֐l] ck2	`ÑoCg
 * [@@\] ck`Nck1`Nck2`NɕB
 *			ck1`ŃAnbyte ̒ɂȂB
 *			ck1`N̑傫Anbyte ɖȂꍇ́AꂸA
 *			ck2`N̒́A0ƂȂB
 *			ck1cḱÂw肵ĂǂB
 *			Pɕꍇ́Aȉ̂悤ɋLqB
 *				SJ_SplitChunk(&ck, 100, &ck, &ck2);
 *  
 * [Inputs  ] ck	: Target chunk
 *			  nbyte	: Size of ck1(byte)
 * [Outputs ] ck1	: Split chunk of the first half
 *			  ck2	: Split chunk of the latter half
 * [Return  ] None
 * [Function] Split a chunk.
 */
void CRIAPI SJ_SplitChunk(SJCK *ck, Sint32 nbyte, SJCK *ck1, SJCK *ck2);

/***
*		^O֐
*			^OtH[}bg
*				0-6		^O
*				7		0(=\0)
*				8-14	f[^ (PUi)
*				15		0(=\0)
***/

/*	$func$ ^O̐
 * [@] void SJ_MakeTag(SJCK *ck, char *tag);
 * [@] ck		: ^O𐶐`N
 *			tag		: ^O
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ck`NɃ^O𐶐B^O̎ck.len-16oCgƂȂB
 * [Inputs  ] ck	: Target chunk
 *			  tag	: TAG strings
 * [Outputs ] none
 * [Return  ] None
 * [Function] Creating tag.
 */
void CRIAPI SJ_MakeTag(SJCK *ck, char *tag);

/*	$func$ ^O̓e̎擾
 * [@] void SJ_GetTagContent(Sint8 *tag, SJCK *cko);
 * [@] tag		: ^O
 * [o@] ck		: ^O̓eƂȂ`N
 * [֐l] Ȃ
 * [@@\] ^O炻̓e`N擾B
 * [Inputs  ] tag	: TAG strings
 * [Outputs ] ck	: chunk
 * [Return  ] None
 * [Function] Creating chunk from TAG.
 */
void CRIAPI SJ_GetTagContent(Sint8 *tag, SJCK *cko);

/*	$func$ ^Ǒ
 * [@] Sint8 *SJ_SearchTag(SJCK *cki, Char8 *kw, Char8 *endkw, SJCK *cko);
 * [@] cki		: ΏۂƂȂ`N
 *			kw		: ړIƂ^ÕL[[h
 *			endkw	: ̃L[[h^OƂ͌𒆒fB
 *					  NULLw肳ꂽƂ́A𒆒fȂB
 * [o@] ck		: ^O̓eƂȂ`NB
 *					  ȂƂ́Acko->data=NULL, cko->len=0ƂȂB
 * [֐l] ^ÕAhXBȂƂNULLԂB
 * [@@\] ^O炻̓e`N擾B
 * [Inputs  ] cki	: chunk for searching
 *			@kw	: Keyword of tag
 *			  endkw : Serach end keyword
 * [Outputs ] cko	: target chunk
 * [Return  ] tag
 * [Function] Searching chunk.
 */
Sint8 * CRIAPI SJ_SearchTag(SJCK *cki, Char8 *kw, Char8 *endkw, SJCK *cko);


/***
*		Oobt@^CṽXg[WCg
*		Stream joint of Ring buffer types
***/

/*																		*/
/*	Initialization															*/
void CRIAPI SJRBF_Init(void);
/*	I																*/
/*	Finalization															*/
void CRIAPI SJRBF_Finish(void);
/*	Oobt@̐													*/
/*	Creates a Ring buffer													*/
SJ CRIAPI SJRBF_Create(Sint8 *buf, Sint32 bsize, Sint32 xsize);
/*	Oobt@nh̐											*/
/*	Creates a Ring buffer handle from work area								*/
SJ CRIAPI SJRBF_CreateHndl(void *work, Sint32 wksize);
/*	Oobt@nhɑ΂ăobt@ݒ							*/
/*	Sets the buffer to a Ring buffer handle									*/
void CRIAPI SJRBF_SetBuffer(SJ sj, Sint8 *buf, Sint32 bsize, Sint32 xsize);

/***
*		^CṽXg[WCg
*		Stream joint of Memory buffer types
***/

/*																		*/
/*	Initialize																*/
void CRIAPI SJMEM_Init(void);
/*	I																*/
/*	Finish																	*/
void CRIAPI SJMEM_Finish(void);
/*	Xg[̐													*/
/*	Create a Memory buffer													*/
SJ CRIAPI SJMEM_Create(Sint8 *data, Sint32 bsize);

/***
*		ėpXg[WCg
*		General Stream joint		
***/

/*	`Ň[h		*/
/*	Combination mode of chunk	*/
#define	SJUNI_MODE_SEPA			(0)
#define	SJUNI_MODE_JOIN			(1)

#define	SJUNI_CALC_WORK(nck)	((nck)*16)

/*																		*/
/*	Initialize																*/
void CRIAPI SJUNI_Init(void);
/*	I																*/
/*	Finish																	*/
void CRIAPI SJUNI_Finish(void);
/*	ėpXg[WCg̐											*/
/*	Create a Stream joint													*/
SJ CRIAPI SJUNI_Create(Sint32 mode, Sint8 *work, Sint32 wksize);
/*	`N̎擾														*/
/*	Get chunk number														*/
Sint32 CRIAPI SJUNI_GetNumChunk(SJ sj, Sint32 id);
/*	`FCv[̎擾													*/
/*	Get Chain pool	number													*/
Sint32 CRIAPI SJUNI_GetNumChainPool(SJ sj);

#if 0	/* Unused functions */
/*	GetChunk֐Ă΂ꂽƂ̃R[obN֐̓o^						*/
void CRIAPI SJUNI_EntryGetFunc(SJ sj, Sint32 id, void (*f)(void *o, SJCK *ck), void *o);
/*	PutChunk֐Ă΂ꂽƂ̃R[obN֐̓o^						*/
void CRIAPI SJUNI_EntryPutFunc(SJ sj, Sint32 id, void (*f)(void *o, SJCK *ck), void *o);
/*	UngetChunk֐Ă΂ꂽƂ̃R[obN֐̓o^					*/
void CRIAPI SJUNI_EntryUngetFunc(SJ sj, Sint32 id, void (*f)(void *o, SJCK *ck), void *o);
#endif

/***
*		ʊ֐
*		Common functions
***/

/*	NeBJZNVւ̐i	*/
/*	Enters to the criticalsection	*/
void CRIAPI SJCRS_Lock(void);
/*	NeBJZNV̒Eo	*/
/*	Leaves from the criticalsection		*/
void CRIAPI SJCRS_Unlock(void);
/*	G[֐̋N					*/
/*	Calls the error callback function	*/
void CRIAPI SJERR_CallErr(Char8 *msg);


#ifdef		__cplusplus
}
#endif

#endif     /*  #ifndef _SJ_H_INCLUDED	*/


