/***************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2001-2004 CRI-MW
 *
 * Appli.   : ADXT Sample Program 
 * Module   : Main function.(Seamless Continuous Play)
 * File     : adxslply.c
 *
 ***************************************************************************/

/***************************************************************************
 *		CN[ht@C
 *		Include file
 ***************************************************************************/
#include <stdio.h>
#include <cri_mw.h>
#include "usr/usr.h"

/***************************************************************************
 *		萔}N
 *		Constant Macro
 ***************************************************************************/

/*	ő`l				*/
/*	The number of maximum channels	*/
#define	MAX_CH			(2)

/*	ĐőXg[									*/
/*	The number of maximum disc streams playing at the same time	*/
#define	MAX_STM			(1)

/*	ōTvOg		*/
/*	Maximum sampling frequency	*/
#define	MAX_SFREQ		(48000)

/*	ADXĐpƗ̈̑傫	*/
/*	Work area size of ADX play	*/
#define	ADXT_WKSIZE		ADXT_CALC_WORK(MAX_CH, 1, MAX_STM, MAX_SFREQ)

/***************************************************************************
 *		}N
 *		Process MACRO
 ***************************************************************************/

/*	tOON/OFF̔]		*/
/*	Turn over flag(ON/OFF)	*/
#define NOT_FLAG(flag)		(((flag) == OFF) ? ON : OFF)

#define UNUSED(x)				((x) = (x))

/***************************************************************************
 *		ϐ`
 *		Variable Definition
 ***************************************************************************/

/*	AvP[V\											*/
/*	Application structure											*/
typedef struct {
	Sint32	disp_flag;				//	Display information flag
	Sint32	pause;					//	Pause flag
	ADXT 	adxt;					//	ADXT Player
	Char8	*fname[2];				//	ADX File name
	Char8	adxt_work[ADXT_WKSIZE];	//	Work area for ADXT
} AP_OBJ;

/*	AvP[VIuWFNg									*/
/*	Application Object												*/
AP_OBJ ap_obj = {
	ON,								//	Display Info.
	OFF,							//	not puase
	NULL,							//	Player
	{
		"smpsl48a.adx",				//	ADX File name 1
		"smpsl48b.adx"				//	ADX File name 2
	}, 		
};

/***************************************************************************
 *		֐錾
 *		Function Declaration
 ***************************************************************************/
void ap_adx_err_func(void *obj, Char8 *msg);
void ApInitMw(AP_OBJ *ap);
void ApFinishMw(AP_OBJ *ap);
void ApStart(AP_OBJ *ap);
void ApStop(AP_OBJ *ap);
void ap_disp_info(AP_OBJ *ap);
Sint32 ApExec(AP_OBJ *ap);

/***************************************************************************
 *		֐`
 *		Function Definition
 ***************************************************************************/

/***
 *			~hEFA̍Đ
 *			Playing middleware
 ***/

/*	~hEFÃG[ɋN֐			*/
/*	Callback function when an error occur in middleware	*/
void ap_adx_err_func(void *obj, Char8 *msg)
{
	UNUSED(obj);		// gpϐ

	UsrDbgPrintf(msg);

	for (;;) {		/*	[Xɂ͖					*/
		;			/*	Delete when you release application.	*/
	}
}

/*	~hEFȀ				*/
/*	Initialize Middleware				*/
void ApInitMw(AP_OBJ *ap)
{
	UNUSED(ap);

	/*	ADXCu		*/
	/*	Initialize ADX library	*/
	ADXT_Init();
}


/*	~hEFȀI					*/
/*	Finalize Middleware					*/
void ApFinishMw(AP_OBJ *ap)
{
	UNUSED(ap);
	
	ADXT_Finish();
}

/*	AvP[VJn	*/
/*	Start application		*/
void ApStart(AP_OBJ *ap)
{
	ADXT adxt;
	
	adxt = ap->adxt = ADXT_Create(2, ap->adxt_work, ADXT_WKSIZE);
	ADXT_EntryFname(adxt, ap->fname[0]);
	ADXT_EntryFname(adxt, ap->fname[0]);
	ADXT_EntryFname(adxt, ap->fname[1]);
	ADXT_SetSeamlessLp(adxt, 1);			// V[X[vĐ̐ݒ
	ADXT_StartSeamless(adxt);
}

/*	AvP[V~	*/
/*	Stop application		*/
void ApStop(AP_OBJ *ap)
{
	ADXT_Destroy(ap->adxt);
}

/*	̕\			*/
/*	Display infomation	*/
void ap_disp_info(AP_OBJ *ap)
{
	ADXT adxt=ap->adxt;
	char *ststr[6] =
		{"STOP   ", "DECINFO   ", "PREP   ", "PLAYING", "DECEND ", "PLAYEND"};
	Sint32 stat, sfreq, cnt;
	Sint32 hh, mm, ss, ff;

	UsrPrintf(3, 3, "ADX Sample Program");
	UsrPrintf(3, 4, "   (Seamless Continuous Play)");
	stat = ADXT_GetStat(adxt);
	UsrPrintf(5, 6, "Stat = %s", ststr[stat]);
	ADXT_GetTime(adxt, &cnt, &sfreq);
	UsrSfcnt2time(sfreq,  cnt, &hh, &mm, &ss, &ff);
	UsrPrintf(5, 7, "Time =%2d:%02d:%02d.%02d", hh, mm, ss, ff);
	UsrPrintf(5, 8, "Number of Files = %d", ADXT_GetNumFiles(adxt));
}

/*	̍Đ					*/
/*	Playing the animation file	*/
Sint32 ApExec(AP_OBJ *ap)
{
	ADXT					adxt=ap->adxt;
	Sint32					stat;
	const USR_PERIPHERAL	*per;

	per = UsrGetPeripheral(0);	
	if (per->press & UTPAD_L)
		ap->disp_flag = NOT_FLAG(ap->disp_flag);

	if (per->press & UTPAD_BUTTON1)
		return FALSE;

	if (per->press & UTPAD_START) {
		ap->pause = NOT_FLAG(ap->pause);
		ADXT_Pause(adxt, ap->pause);	/*	ꎞ~			*/
										/*	Release pause status	*/
	}
	/*	Checking status												*/
	stat = ADXT_GetStat(adxt);
	if (stat == ADXT_STAT_PLAYEND)
		return FALSE;
	if (ap->disp_flag == ON)
		ap_disp_info(ap);

	/* CRI Middleware Library's Server function */
	ADXM_ExecMain();

	return TRUE;
}

/***
 *		C
 *		MAIN
 ***/
int main(void)
{
	AP_OBJ	*ap;
	Sint32	term_flag = OFF;
	Bool	ret;

	ap = &ap_obj;

	/*	G[R[obN֐̓o^		*/
	/*	Entry ADX error callback function	*/
	ADXM_SetCbErr(ap_adx_err_func, NULL);
	
	/*	VXȅ										*/
	/*	Initialize System										*/
	UsrInitSystem(NULL, NULL);
	
	/*	rfȈ											*/
	/*	Initialize Video System									*/
	UsrInitVideo(NULL, NULL);
	
	/*	TEh̏										*/
	/*	Initialize Sound System									*/
	UsrInitSound(NULL, NULL);

	ApInitMw(ap);

	while (term_flag == OFF) {
		ApStart(ap);
		/*	cnt :frame count						*/
		/*	cnt=0:interlace	/ cnt>0:non interlace	*/
		UsrInitSync(2);
		for (;;) {
			UsrSyncFrame();
			UsrBeginDraw();
			ret = ApExec(ap);
			UsrEndDraw();

			/* I邩ǂ̊mF					*/
			/* Checks whether Usr module is terminated	*/
			if (UsrIsTerminated() == TRUE) {
				term_flag = ON;
			}
			
			if (ret == FALSE || term_flag == ON) {
				break;
			}
		}
		ApStop(ap);
	}
	/*	AvP[VI	*/
	/*	Finalize application		*/
	ApFinishMw(ap);			/*	~hEFȀI				*/
							/*	Finalize Middleware				*/
	UsrFinishSound();		/*	TEhVXȅI		*/
							/*	Finalize sound system			*/
	UsrFinishVideo();		/*	rfȈI				*/
							/*	Finalize Video system			*/
	UsrFinishSystem();		/*	VXȅI				*/
							/*	Finalize system					*/
	return 0;
}

/* end of file */
